/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.SparkHashTableSinkOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.SparkHashTableSinkDesc;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;

public class VectorSparkHashTableSinkOperator
extends SparkHashTableSinkOperator {
    private static final long serialVersionUID = 1L;
    private VectorizationContext vContext;
    private transient boolean firstBatch;
    private transient VectorExtractRow vectorExtractRow;
    protected transient Object[] singleRow;

    @VisibleForTesting
    public VectorSparkHashTableSinkOperator() {
    }

    public VectorSparkHashTableSinkOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorSparkHashTableSinkOperator(CompilationOpContext ctx, VectorizationContext vContext, OperatorDesc conf) {
        this(ctx);
        this.vContext = vContext;
        this.conf = (SparkHashTableSinkDesc)conf;
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        this.inputObjInspectors[0] = VectorizedBatchUtil.convertToStandardStructObjectInspector((StructObjectInspector)this.inputObjInspectors[0]);
        super.initializeOp(hconf);
        this.firstBatch = true;
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        VectorizedRowBatch batch = (VectorizedRowBatch)row;
        if (this.firstBatch) {
            this.vectorExtractRow = new VectorExtractRow();
            this.vectorExtractRow.init((StructObjectInspector)this.inputObjInspectors[0], this.vContext.getProjectedColumns());
            this.singleRow = new Object[this.vectorExtractRow.getCount()];
            this.firstBatch = false;
        }
        if (batch.selectedInUse) {
            int[] selected = batch.selected;
            for (int logical = 0; logical < batch.size; ++logical) {
                int batchIndex = selected[logical];
                this.vectorExtractRow.extractRow(batch, batchIndex, this.singleRow);
                super.process(this.singleRow, tag);
            }
        } else {
            for (int batchIndex = 0; batchIndex < batch.size; ++batchIndex) {
                this.vectorExtractRow.extractRow(batch, batchIndex, this.singleRow);
                super.process(this.singleRow, tag);
            }
        }
    }
}

