/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hive.common.util.AnnotationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorExpressionDescriptor {
    private static final Logger LOG = LoggerFactory.getLogger(VectorExpressionDescriptor.class.getName());
    static final int MAX_NUM_ARGUMENTS = 3;

    public Class<?> getVectorExpressionClass(Class<?> udf, Descriptor descriptor) throws HiveException {
        Class<? extends VectorExpression>[] list;
        VectorizedExpressions annotation = AnnotationUtils.getAnnotation(udf, VectorizedExpressions.class);
        if (annotation == null || annotation.value() == null) {
            return null;
        }
        for (Class<? extends VectorExpression> ve : list = annotation.value()) {
            try {
                if (!ve.newInstance().getDescriptor().matches(descriptor)) continue;
                return ve;
            }
            catch (Exception ex) {
                throw new HiveException("Could not instantiate VectorExpression class " + ve.getSimpleName(), ex);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getVectorExpressionClass udf " + udf.getSimpleName() + " descriptor: " + descriptor.toString());
            for (Class<? extends VectorExpression> ve : list) {
                try {
                    LOG.debug("getVectorExpressionClass doesn't match " + ve.getSimpleName() + " " + ve.newInstance().getDescriptor().toString());
                }
                catch (Exception ex) {
                    throw new HiveException(ex);
                }
            }
        }
        return null;
    }

    public static final class Descriptor {
        private final Mode mode;
        private final ArgumentType[] argTypes;
        private final InputExpressionType[] exprTypes;
        private final int argCount;

        public boolean matches(Descriptor other) {
            if (!this.mode.equals((Object)other.mode) || this.argCount != other.argCount) {
                return false;
            }
            for (int i = 0; i < this.argCount; ++i) {
                if (!this.argTypes[i].isSameTypeOrFamily(other.argTypes[i])) {
                    return false;
                }
                if (this.exprTypes[i].equals((Object)other.exprTypes[i])) continue;
                return false;
            }
            return true;
        }

        private Descriptor(Mode mode, int argCount, ArgumentType[] argTypes, InputExpressionType[] exprTypes) {
            this.mode = mode;
            this.argTypes = (ArgumentType[])argTypes.clone();
            this.exprTypes = (InputExpressionType[])exprTypes.clone();
            this.argCount = argCount;
        }

        public String toString() {
            int i;
            StringBuilder b = new StringBuilder("Argument Count = ");
            b.append(this.argCount);
            b.append(", mode = ");
            b.append((Object)this.mode);
            b.append(", Argument Types = {");
            for (i = 0; i < this.argCount; ++i) {
                if (i != 0) {
                    b.append(",");
                }
                b.append((Object)this.argTypes[i]);
            }
            b.append("}");
            b.append(", Input Expression Types = {");
            for (i = 0; i < this.argCount; ++i) {
                if (i != 0) {
                    b.append(",");
                }
                b.append((Object)this.exprTypes[i]);
            }
            b.append("}");
            return b.toString();
        }
    }

    public static class Builder {
        private Mode mode = Mode.PROJECTION;
        ArgumentType[] argTypes = new ArgumentType[3];
        InputExpressionType[] exprTypes = new InputExpressionType[3];
        private int argCount = 0;

        public Builder() {
            for (int i = 0; i < 3; ++i) {
                this.argTypes[i] = ArgumentType.NONE;
                this.exprTypes[i] = InputExpressionType.NONE;
            }
        }

        public Builder setMode(Mode m) {
            this.mode = m;
            return this;
        }

        public Builder setNumArguments(int argCount) {
            this.argCount = argCount;
            return this;
        }

        public Builder setArgumentTypes(ArgumentType ... types) {
            for (int i = 0; i < types.length; ++i) {
                this.argTypes[i] = types[i];
            }
            return this;
        }

        public Builder setArgumentTypes(String ... types) {
            for (int i = 0; i < types.length; ++i) {
                this.argTypes[i] = ArgumentType.getType(types[i]);
            }
            return this;
        }

        public Builder setArgumentType(int index, ArgumentType type) {
            this.argTypes[index] = type;
            return this;
        }

        public Builder setArgumentType(int index, String type) {
            this.argTypes[index] = ArgumentType.getType(type);
            return this;
        }

        public Builder setInputExpressionTypes(InputExpressionType ... types) {
            for (int i = 0; i < types.length; ++i) {
                this.exprTypes[i] = types[i];
            }
            return this;
        }

        public Builder setInputExpressionType(int index, InputExpressionType type) {
            this.exprTypes[index] = type;
            return this;
        }

        public Descriptor build() {
            return new Descriptor(this.mode, this.argCount, this.argTypes, this.exprTypes);
        }
    }

    public static enum Mode {
        PROJECTION(0),
        FILTER(1);

        private final int value;

        private Mode(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum InputExpressionType {
        NONE(0),
        COLUMN(1),
        SCALAR(2),
        DYNAMICVALUE(3);

        private final int value;

        private InputExpressionType(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ArgumentType {
        NONE(0),
        INT_FAMILY(1),
        FLOAT_FAMILY(2),
        DECIMAL(4),
        STRING(8),
        CHAR(16),
        VARCHAR(32),
        STRING_FAMILY(ArgumentType.STRING.value | ArgumentType.CHAR.value | ArgumentType.VARCHAR.value),
        DATE(64),
        TIMESTAMP(128),
        INTERVAL_YEAR_MONTH(256),
        INTERVAL_DAY_TIME(512),
        BINARY(1024),
        DATETIME_FAMILY(ArgumentType.DATE.value | ArgumentType.TIMESTAMP.value),
        INTERVAL_FAMILY(ArgumentType.INTERVAL_YEAR_MONTH.value | ArgumentType.INTERVAL_DAY_TIME.value),
        INT_INTERVAL_YEAR_MONTH(ArgumentType.INT_FAMILY.value | ArgumentType.INTERVAL_YEAR_MONTH.value),
        INT_DATE_INTERVAL_YEAR_MONTH(ArgumentType.INT_FAMILY.value | ArgumentType.DATE.value | ArgumentType.INTERVAL_YEAR_MONTH.value),
        STRING_DATETIME_FAMILY(ArgumentType.STRING_FAMILY.value | ArgumentType.DATETIME_FAMILY.value),
        ALL_FAMILY(4095);

        private final int value;

        private ArgumentType(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public static ArgumentType fromHiveTypeName(String hiveTypeName) {
            String lower = hiveTypeName.toLowerCase();
            if (lower.equals("tinyint") || lower.equals("smallint") || lower.equals("int") || lower.equals("bigint") || lower.equals("boolean") || lower.equals("long")) {
                return INT_FAMILY;
            }
            if (lower.equals("double") || lower.equals("float")) {
                return FLOAT_FAMILY;
            }
            if (lower.equals("string")) {
                return STRING;
            }
            if (VectorizationContext.charTypePattern.matcher(lower).matches()) {
                return CHAR;
            }
            if (VectorizationContext.varcharTypePattern.matcher(lower).matches()) {
                return VARCHAR;
            }
            if (lower.equals("binary")) {
                return BINARY;
            }
            if (VectorizationContext.decimalTypePattern.matcher(lower).matches()) {
                return DECIMAL;
            }
            if (lower.equals("timestamp")) {
                return TIMESTAMP;
            }
            if (lower.equals("date")) {
                return DATE;
            }
            if (lower.equals("interval_year_month")) {
                return INTERVAL_YEAR_MONTH;
            }
            if (lower.equals("interval_day_time")) {
                return INTERVAL_DAY_TIME;
            }
            if (lower.equals("void")) {
                return INT_FAMILY;
            }
            return NONE;
        }

        public static ArgumentType getType(String inType) {
            if (inType.equalsIgnoreCase("long")) {
                return INT_FAMILY;
            }
            if (inType.equalsIgnoreCase("double")) {
                return FLOAT_FAMILY;
            }
            if (VectorizationContext.decimalTypePattern.matcher(inType).matches()) {
                return DECIMAL;
            }
            if (VectorizationContext.charTypePattern.matcher(inType).matches()) {
                return CHAR;
            }
            if (VectorizationContext.varcharTypePattern.matcher(inType).matches()) {
                return VARCHAR;
            }
            return ArgumentType.valueOf(inType.toUpperCase());
        }

        public boolean isSameTypeOrFamily(ArgumentType other) {
            return (this.value & other.value) != 0;
        }

        public static String getVectorColumnSimpleName(ArgumentType argType) {
            if (argType == INT_FAMILY || argType == DATE || argType == INTERVAL_YEAR_MONTH) {
                return "Long";
            }
            if (argType == TIMESTAMP || argType == INTERVAL_DAY_TIME) {
                return "Timestamp";
            }
            if (argType == FLOAT_FAMILY) {
                return "Double";
            }
            if (argType == DECIMAL) {
                return "Decimal";
            }
            if (argType == STRING || argType == CHAR || argType == VARCHAR || argType == BINARY) {
                return "String";
            }
            return "None";
        }

        public static String getVectorColumnSimpleName(String hiveTypeName) {
            ArgumentType argType = ArgumentType.fromHiveTypeName(hiveTypeName);
            return ArgumentType.getVectorColumnSimpleName(argType);
        }
    }
}

