/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class OperatorUtils {
    public static <T> Set<T> findOperators(Operator<?> start, Class<T> clazz) {
        return OperatorUtils.findOperators(start, clazz, new HashSet());
    }

    public static <T> T findSingleOperator(Operator<?> start, Class<T> clazz) {
        Set<T> found = OperatorUtils.findOperators(start, clazz, new HashSet());
        return found.size() == 1 ? (T)found.iterator().next() : null;
    }

    public static <T> Set<T> findOperators(Collection<Operator<?>> starts, Class<T> clazz) {
        HashSet found = new HashSet();
        for (Operator<?> start : starts) {
            OperatorUtils.findOperators(start, clazz, found);
        }
        return found;
    }

    private static <T> Set<T> findOperators(Operator<?> start, Class<T> clazz, Set<T> found) {
        if (clazz.isInstance(start)) {
            found.add(start);
        }
        if (start.getChildOperators() != null) {
            for (Operator<OperatorDesc> child : start.getChildOperators()) {
                OperatorUtils.findOperators(child, clazz, found);
            }
        }
        return found;
    }
}

