/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestMiniYARNClusterForHA {
    MiniYARNCluster cluster;

    @Before
    public void setup() throws IOException, InterruptedException {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", false);
        conf.set("yarn.resourcemanager.webapp.address", "localhost:0");
        this.cluster = new MiniYARNCluster(TestMiniYARNClusterForHA.class.getName(), 2, 1, 1, 1);
        this.cluster.init((Configuration)conf);
        this.cluster.start();
        this.cluster.getResourceManager(0).getRMContext().getRMAdminService().transitionToActive(new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER));
        Assert.assertFalse((String)"RM never turned active", (-1 == this.cluster.getActiveRMIndex() ? 1 : 0) != 0);
    }

    @Test
    public void testClusterWorks() throws YarnException, InterruptedException {
        Assert.assertTrue((String)"NMs fail to connect to the RM", (boolean)this.cluster.waitForNodeManagersToConnect(5000L));
    }
}

