/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;

final class BufferReaderWriterUtil {
    static final int HEADER_LENGTH = 8;
    static final int HEADER_VALUE_IS_BUFFER = 0;
    static final int HEADER_VALUE_IS_EVENT = 1;

    BufferReaderWriterUtil() {
    }

    static boolean writeBuffer(Buffer buffer, ByteBuffer memory) {
        int bufferSize = buffer.getSize();
        if (memory.remaining() < bufferSize + 8) {
            return false;
        }
        memory.putInt(buffer.isBuffer() ? 0 : 1);
        memory.putInt(bufferSize);
        memory.put(buffer.getNioBufferReadable());
        return true;
    }

    @Nullable
    static Buffer sliceNextBuffer(ByteBuffer memory) {
        int remaining = memory.remaining();
        if (remaining == 0) {
            return null;
        }
        int header = memory.getInt();
        int size = memory.getInt();
        memory.limit(memory.position() + size);
        ByteBuffer buf = memory.slice();
        memory.position(memory.limit());
        memory.limit(memory.capacity());
        MemorySegment memorySegment = MemorySegmentFactory.wrapOffHeapMemory((ByteBuffer)buf);
        return BufferReaderWriterUtil.bufferFromMemorySegment(memorySegment, FreeingBufferRecycler.INSTANCE, size, header == 1);
    }

    static long writeToByteChannel(FileChannel channel, Buffer buffer, ByteBuffer[] arrayWithHeaderBuffer) throws IOException {
        ByteBuffer dataBuffer;
        ByteBuffer headerBuffer = arrayWithHeaderBuffer[0];
        headerBuffer.clear();
        headerBuffer.putInt(buffer.isBuffer() ? 0 : 1);
        headerBuffer.putInt(buffer.getSize());
        headerBuffer.flip();
        arrayWithHeaderBuffer[1] = dataBuffer = buffer.getNioBufferReadable();
        long bytesExpected = 8 + dataBuffer.remaining();
        if (bytesExpected < channel.write(arrayWithHeaderBuffer)) {
            BufferReaderWriterUtil.writeBuffers(channel, arrayWithHeaderBuffer);
        }
        return bytesExpected;
    }

    static long writeToByteChannelIfBelowSize(FileChannel channel, Buffer buffer, ByteBuffer[] arrayWithHeaderBuffer, long bytesLeft) throws IOException {
        if (bytesLeft >= (long)(8 + buffer.getSize())) {
            return BufferReaderWriterUtil.writeToByteChannel(channel, buffer, arrayWithHeaderBuffer);
        }
        return -1L;
    }

    @Nullable
    static Buffer readFromByteChannel(FileChannel channel, ByteBuffer headerBuffer, MemorySegment memorySegment, BufferRecycler bufferRecycler) throws IOException {
        ByteBuffer targetBuf;
        int size;
        int header;
        headerBuffer.clear();
        if (!BufferReaderWriterUtil.tryReadByteBuffer(channel, headerBuffer)) {
            return null;
        }
        headerBuffer.flip();
        try {
            header = headerBuffer.getInt();
            size = headerBuffer.getInt();
            targetBuf = memorySegment.wrap(0, size);
        }
        catch (IllegalArgumentException | BufferUnderflowException e) {
            BufferReaderWriterUtil.throwCorruptDataException();
            return null;
        }
        BufferReaderWriterUtil.readByteBufferFully(channel, targetBuf);
        return BufferReaderWriterUtil.bufferFromMemorySegment(memorySegment, bufferRecycler, size, header == 1);
    }

    static ByteBuffer allocatedHeaderBuffer() {
        ByteBuffer bb = ByteBuffer.allocateDirect(8);
        BufferReaderWriterUtil.configureByteBuffer(bb);
        return bb;
    }

    static ByteBuffer[] allocatedWriteBufferArray() {
        return new ByteBuffer[]{BufferReaderWriterUtil.allocatedHeaderBuffer(), null};
    }

    private static boolean tryReadByteBuffer(FileChannel channel, ByteBuffer b) throws IOException {
        if (channel.read(b) == -1) {
            return false;
        }
        while (b.hasRemaining()) {
            if (channel.read(b) != -1) continue;
            BufferReaderWriterUtil.throwPrematureEndOfFile();
        }
        return true;
    }

    private static void readByteBufferFully(FileChannel channel, ByteBuffer b) throws IOException {
        do {
            if (channel.read(b) != -1) continue;
            BufferReaderWriterUtil.throwPrematureEndOfFile();
        } while (b.hasRemaining());
    }

    private static void writeBuffer(FileChannel channel, ByteBuffer buffer) throws IOException {
        while (buffer.hasRemaining()) {
            channel.write(buffer);
        }
    }

    private static void writeBuffers(FileChannel channel, ByteBuffer ... buffers) throws IOException {
        for (ByteBuffer buffer : buffers) {
            BufferReaderWriterUtil.writeBuffer(channel, buffer);
        }
    }

    private static void throwPrematureEndOfFile() throws IOException {
        throw new IOException("The spill file is corrupt: premature end of file");
    }

    private static void throwCorruptDataException() throws IOException {
        throw new IOException("The spill file is corrupt: buffer size and boundaries invalid");
    }

    static Buffer bufferFromMemorySegment(MemorySegment memorySegment, BufferRecycler memorySegmentRecycler, int size, boolean isEvent) {
        NetworkBuffer buffer = new NetworkBuffer(memorySegment, memorySegmentRecycler);
        buffer.setSize(size);
        if (isEvent) {
            buffer.tagAsEvent();
        }
        return buffer;
    }

    static void configureByteBuffer(ByteBuffer buffer) {
        buffer.order(ByteOrder.nativeOrder());
    }
}

