/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.writer;

import org.apache.flink.runtime.io.network.api.writer.BroadcastRecordWriter;
import org.apache.flink.runtime.io.network.api.writer.ChannelSelector;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.api.writer.RoundRobinChannelSelector;

public class RecordWriterBuilder {
    private ChannelSelector selector = new RoundRobinChannelSelector();
    private long timeout = -1L;
    private String taskName = "test";

    public RecordWriterBuilder setChannelSelector(ChannelSelector selector) {
        this.selector = selector;
        return this;
    }

    public RecordWriterBuilder setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public RecordWriterBuilder setTaskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    public RecordWriter build(ResultPartitionWriter writer) {
        if (this.selector.isBroadcast()) {
            return new BroadcastRecordWriter(writer, this.selector, this.timeout, this.taskName);
        }
        return new RecordWriter(writer, this.selector, this.timeout, this.taskName);
    }
}

