/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;
import org.apache.dubbo.common.config.Environment;
import org.apache.dubbo.common.utils.AnnotationUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;
import org.apache.dubbo.rpc.protocol.tri.rest.RestException;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.GeneralTypeConverter;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.TypeConverter;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestToolKit;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestUtils;

public abstract class AbstractRestToolKit
implements RestToolKit {
    protected final FrameworkModel frameworkModel;
    protected final TypeConverter typeConverter;

    public AbstractRestToolKit(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
        this.typeConverter = (TypeConverter)frameworkModel.getBeanFactory().getOrRegisterBean(GeneralTypeConverter.class);
    }

    @Override
    public String resolvePlaceholders(String text) {
        return RestUtils.hasPlaceholder(text) ? this.getEnvironment().resolvePlaceholders(text) : text;
    }

    private Environment getEnvironment() {
        return this.frameworkModel.defaultApplication().modelEnvironment();
    }

    @Override
    public Object convert(Object value, ParameterMeta parameter) {
        Object target = this.typeConverter.convert(value, parameter.getGenericType());
        if (target == null && value != null) {
            throw new RestException(Messages.ARGUMENT_CONVERT_ERROR, parameter.getName(), value, value.getClass(), parameter.getGenericType());
        }
        return target;
    }

    @Override
    public String[] getParameterNames(Method method) {
        Parameter[] parameters = method.getParameters();
        int len = parameters.length;
        String[] names = new String[len];
        for (int i = 0; i < len; ++i) {
            Parameter param = parameters[i];
            if (!param.isNamePresent()) {
                return null;
            }
            names[i] = param.getName();
        }
        return names;
    }

    @Override
    public Map<String, Object> getAttributes(AnnotatedElement element, Annotation annotation) {
        return AnnotationUtils.getAttributes((Annotation)annotation, (boolean)false);
    }
}

