/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;
import org.apache.dubbo.rpc.protocol.tri.rest.RestException;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationSupport;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestToolKit;
import org.apache.dubbo.rpc.protocol.tri.rest.util.TypeUtils;

public abstract class ParameterMeta
extends AnnotationSupport {
    private final String prefix;
    private final String name;
    private Boolean simple;
    private Class<?> actualType;
    private Type actualGenericType;

    protected ParameterMeta(RestToolKit toolKit, String prefix, String name) {
        super(toolKit);
        this.prefix = prefix;
        this.name = name;
    }

    protected ParameterMeta(RestToolKit toolKit, String name) {
        super(toolKit);
        this.prefix = null;
        this.name = name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public String getRequiredName() {
        String name = this.getName();
        if (name == null) {
            throw new RestException(Messages.ARGUMENT_NAME_MISSING, this.getType());
        }
        return name;
    }

    public final boolean isSimple() {
        Boolean simple = this.simple;
        if (simple == null) {
            Class<?> type = Collection.class.isAssignableFrom(this.getType()) ? TypeUtils.getNestedActualType(this.getGenericType(), 0) : this.getActualType();
            this.simple = simple = Boolean.valueOf(TypeUtils.isSimpleProperty(type));
        }
        return simple;
    }

    public final Class<?> getActualType() {
        Class<Object> type = this.actualType;
        if (type == null) {
            type = this.getType();
            if (type == Optional.class && (type = TypeUtils.getNestedActualType(this.getGenericType(), 0)) == null) {
                type = Object.class;
            }
            this.actualType = type;
        }
        return type;
    }

    public final Type getActualGenericType() {
        Object type = this.actualGenericType;
        if (type == null) {
            type = this.getGenericType();
            if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() == Optional.class && (type = TypeUtils.getNestedGenericType(this.getGenericType(), 0)) == null) {
                type = Object.class;
            }
            this.actualGenericType = type;
        }
        return type;
    }

    public final Object bind(HttpRequest request, HttpResponse response) {
        return this.getToolKit().bind(this, request, response);
    }

    public int getIndex() {
        return -1;
    }

    public String getDescription() {
        return this.name;
    }

    public abstract Class<?> getType();

    public abstract Type getGenericType();

    public String toString() {
        return "ParameterMeta{name='" + this.name + "', type=" + this.getType() + '}';
    }
}

