/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.Condition;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.NameValueExpression;

public final class ParamsCondition
implements Condition<ParamsCondition, HttpRequest> {
    private final Set<NameValueExpression> expressions;

    public ParamsCondition(String ... params) {
        this.expressions = NameValueExpression.parse(params);
    }

    private ParamsCondition(Set<NameValueExpression> expressions) {
        this.expressions = expressions;
    }

    @Override
    public ParamsCondition combine(ParamsCondition other) {
        LinkedHashSet<NameValueExpression> set = new LinkedHashSet<NameValueExpression>(this.expressions);
        set.addAll(other.expressions);
        return new ParamsCondition(set);
    }

    @Override
    public ParamsCondition match(HttpRequest request) {
        for (NameValueExpression expression : this.expressions) {
            if (expression.match(arg_0 -> ((HttpRequest)request).hasParameter(arg_0), arg_0 -> ((HttpRequest)request).parameter(arg_0))) continue;
            return null;
        }
        return this;
    }

    @Override
    public int compareTo(ParamsCondition other, HttpRequest request) {
        return other.expressions.size() - this.expressions.size();
    }

    public int hashCode() {
        return this.expressions.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ParamsCondition.class) {
            return false;
        }
        return this.expressions.equals(((ParamsCondition)obj).expressions);
    }

    public String toString() {
        return "ParamsCondition{params=" + this.expressions + '}';
    }
}

