/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.Condition;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.MediaTypeExpression;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.NameValueExpression;

public final class ConsumesCondition
implements Condition<ConsumesCondition, HttpRequest> {
    public static final MediaTypeExpression DEFAULT = MediaTypeExpression.parse("application/octet-stream");
    private final List<MediaTypeExpression> expressions;

    public ConsumesCondition(String ... consumes) {
        this(consumes, (String[])null);
    }

    public ConsumesCondition(String[] consumes, String[] headers) {
        LinkedHashSet<MediaTypeExpression> expressions = null;
        if (headers != null) {
            for (String header : headers) {
                MediaTypeExpression expression;
                NameValueExpression expr = NameValueExpression.parse(header);
                if (!HttpHeaderNames.CONTENT_TYPE.getName().equalsIgnoreCase(expr.getName()) || (expression = MediaTypeExpression.parse(expr.getValue())) == null) continue;
                if (expressions == null) {
                    expressions = new LinkedHashSet();
                }
                expressions.add(expression);
            }
        }
        if (consumes != null) {
            for (String consume : consumes) {
                MediaTypeExpression expression = MediaTypeExpression.parse(consume);
                if (expression == null) continue;
                if (expressions == null) {
                    expressions = new LinkedHashSet<MediaTypeExpression>();
                }
                expressions.add(expression);
            }
        }
        if (expressions == null) {
            this.expressions = Collections.emptyList();
        } else {
            this.expressions = new ArrayList<MediaTypeExpression>(expressions);
            Collections.sort(this.expressions);
        }
    }

    private ConsumesCondition(List<MediaTypeExpression> expressions) {
        this.expressions = expressions;
    }

    @Override
    public ConsumesCondition combine(ConsumesCondition other) {
        return other.expressions.isEmpty() ? this : other;
    }

    @Override
    public ConsumesCondition match(HttpRequest request) {
        if (this.expressions.isEmpty()) {
            return null;
        }
        String contentType = request.contentType();
        MediaTypeExpression mediaType = contentType == null ? DEFAULT : MediaTypeExpression.parse(contentType);
        ArrayList<MediaTypeExpression> result = null;
        int size = this.expressions.size();
        for (int i = 0; i < size; ++i) {
            MediaTypeExpression expression = this.expressions.get(i);
            if (!expression.match(mediaType)) continue;
            if (result == null) {
                result = new ArrayList<MediaTypeExpression>();
            }
            result.add(expression);
        }
        return result == null ? null : new ConsumesCondition(result);
    }

    @Override
    public int compareTo(ConsumesCondition other, HttpRequest request) {
        if (this.expressions.isEmpty()) {
            return other.expressions.isEmpty() ? 0 : 1;
        }
        if (other.expressions.isEmpty()) {
            return -1;
        }
        return this.expressions.get(0).compareTo(other.expressions.get(0));
    }

    public int hashCode() {
        return this.expressions.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ConsumesCondition.class) {
            return false;
        }
        return this.expressions.equals(((ConsumesCondition)obj).expressions);
    }

    public String toString() {
        return "ConsumesCondition{mediaTypes=" + this.expressions + '}';
    }
}

