/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.argument;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.Pair;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.ArgumentConverter;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.util.TypeUtils;

public final class CompositeArgumentConverter
implements ArgumentConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeArgumentConverter.class);
    private final List<ArgumentConverter> converters;
    private final Map<Pair<Class, Class>, List<ArgumentConverter>> cache = CollectionUtils.newConcurrentHashMap();

    public CompositeArgumentConverter(FrameworkModel frameworkModel) {
        this.converters = frameworkModel.getActivateExtensions(ArgumentConverter.class);
    }

    public Object convert(Object value, ParameterMeta parameter) {
        Class<?> type = parameter.getType();
        if (value == null) {
            return TypeUtils.nullDefault(type);
        }
        if (type.isInstance(value)) {
            if (parameter.getGenericType() instanceof Class) {
                return value;
            }
            return parameter.getToolKit().convert(value, parameter);
        }
        List<ArgumentConverter> converters = this.getSuitableConverters(value.getClass(), type);
        int size = converters.size();
        for (int i = 0; i < size; ++i) {
            Object target = converters.get(i).convert(value, parameter);
            if (target == null) continue;
            return target;
        }
        return parameter.getToolKit().convert(value, parameter);
    }

    public Object convert(Object value, Class<?> type) {
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return value;
        }
        TypeParameterMeta parameter = new TypeParameterMeta(type);
        List<ArgumentConverter> converters = this.getSuitableConverters(value.getClass(), type);
        int size = converters.size();
        for (int i = 0; i < size; ++i) {
            Object target = converters.get(i).convert(value, parameter);
            if (target == null) continue;
            return target;
        }
        return null;
    }

    private List<ArgumentConverter> getSuitableConverters(Class sourceType, Class targetType) {
        return this.cache.computeIfAbsent((Pair<Class, Class>)Pair.of((Object)sourceType, (Object)targetType), k -> {
            ArrayList<ArgumentConverter> result = new ArrayList<ArgumentConverter>();
            for (ArgumentConverter converter : this.converters) {
                Class<?> supportTargetType;
                Class<?> supportSourceType = TypeUtils.getSuperGenericType(converter.getClass(), 0);
                if (supportSourceType == null || (supportTargetType = TypeUtils.getSuperGenericType(converter.getClass(), 1)) == null || !supportSourceType.isAssignableFrom(sourceType) || !targetType.isAssignableFrom(supportTargetType)) continue;
                result.add(converter);
            }
            if (result.isEmpty()) {
                return Collections.emptyList();
            }
            LOGGER.info("Found suitable ArgumentConverter for [{}], converters: {}", new Object[]{sourceType, result});
            return result;
        });
    }

    private static final class TypeParameterMeta
    extends ParameterMeta {
        private final Class<?> type;

        TypeParameterMeta(Class<?> type) {
            super(null, null);
            this.type = type;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public Type getGenericType() {
            return this.type;
        }

        @Override
        protected AnnotatedElement getAnnotatedElement() {
            return Object.class;
        }
    }
}

