/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h3;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.DefaultHttp2ResetFrame;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.incubator.codec.http3.DefaultHttp3DataFrame;
import io.netty.incubator.codec.http3.DefaultHttp3HeadersFrame;
import io.netty.incubator.codec.http3.Http3DataFrame;
import io.netty.incubator.codec.http3.Http3ErrorCode;
import io.netty.incubator.codec.http3.Http3Exception;
import io.netty.incubator.codec.http3.Http3GoAwayFrame;
import io.netty.incubator.codec.http3.Http3Headers;
import io.netty.incubator.codec.http3.Http3HeadersFrame;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import org.apache.dubbo.remoting.http3.netty4.Http2HeadersAdapter;
import org.apache.dubbo.remoting.http3.netty4.Http3HeadersAdapter;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;

@ChannelHandler.Sharable
public class Http3ClientFrameCodec
extends ChannelDuplexHandler {
    public static final Http3ClientFrameCodec INSTANCE = new Http3ClientFrameCodec();

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof Http3HeadersFrame) {
            Http2HeadersAdapter headers = new Http2HeadersAdapter(((Http3HeadersFrame)msg).headers());
            boolean endStream = headers.contains(TripleHeaderEnum.STATUS_KEY.getKey());
            ctx.fireChannelRead((Object)new DefaultHttp2HeadersFrame((Http2Headers)headers, endStream));
        } else if (msg instanceof Http3DataFrame) {
            ctx.fireChannelRead((Object)new DefaultHttp2DataFrame(((Http3DataFrame)msg).content()));
        } else if (msg instanceof Http3GoAwayFrame) {
            ctx.fireUserEventTriggered((Object)new DefaultHttp2GoAwayFrame(((Http3GoAwayFrame)msg).id()));
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.fireChannelRead((Object)new DefaultHttp2DataFrame(Unpooled.EMPTY_BUFFER, true));
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof Http2HeadersFrame) {
            Http2HeadersFrame frame = (Http2HeadersFrame)msg;
            ctx.write((Object)new DefaultHttp3HeadersFrame((Http3Headers)new Http3HeadersAdapter(frame.headers())), promise);
            if (frame.isEndStream()) {
                ((QuicStreamChannel)ctx.channel()).shutdownOutput(promise);
            }
        } else if (msg instanceof Http2DataFrame) {
            Http2DataFrame frame = (Http2DataFrame)msg;
            if (frame.isEndStream()) {
                ((QuicStreamChannel)ctx.channel()).shutdownOutput(promise);
                return;
            }
            ctx.write((Object)new DefaultHttp3DataFrame(frame.content()), promise);
        } else {
            ctx.write(msg, promise);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Http3Exception e;
        Http3ErrorCode errorCode;
        if (cause instanceof Http3Exception && (errorCode = (e = (Http3Exception)cause).errorCode()) == Http3ErrorCode.H3_CLOSED_CRITICAL_STREAM) {
            ctx.fireUserEventTriggered((Object)new DefaultHttp2ResetFrame((long)(256 + errorCode.ordinal())));
            return;
        }
        super.exceptionCaught(ctx, cause);
    }
}

