/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.grpc;

import java.io.IOException;
import java.io.InputStream;
import org.apache.dubbo.remoting.http12.message.LengthFieldStreamingDecoder;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.protocol.tri.compressor.DeCompressor;

public class GrpcStreamingDecoder
extends LengthFieldStreamingDecoder {
    private static final int COMPRESSED_FLAG_MASK = 1;
    private static final int RESERVED_MASK = 254;
    private boolean compressedFlag;
    private DeCompressor deCompressor = DeCompressor.NONE;

    public GrpcStreamingDecoder() {
        super(1, 4);
    }

    public void setDeCompressor(DeCompressor deCompressor) {
        this.deCompressor = deCompressor;
    }

    protected void processOffset(InputStream inputStream, int lengthFieldOffset) throws IOException {
        int type = inputStream.read();
        if ((type & 0xFE) != 0) {
            throw new RpcException("gRPC frame header malformed: reserved bits not zero");
        }
        this.compressedFlag = (type & 1) != 0;
    }

    protected byte[] readRawMessage(InputStream inputStream, int length) throws IOException {
        byte[] rawMessage = super.readRawMessage(inputStream, length);
        return this.compressedFlag ? this.deCompressedMessage(rawMessage) : rawMessage;
    }

    private byte[] deCompressedMessage(byte[] rawMessage) {
        return this.deCompressor.decompress(rawMessage);
    }
}

