/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12;

import org.apache.dubbo.common.logger.Level;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpResult;
import org.apache.dubbo.remoting.http12.RequestMetadata;
import org.apache.dubbo.remoting.http12.message.DefaultHttpResult;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.h12.CompositeExceptionHandler;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcHeaderNames;

public final class ExceptionCustomizerWrapper {
    private final CompositeExceptionHandler exceptionHandler;
    private RequestMetadata metadata;
    private MethodDescriptor methodDescriptor;
    private boolean needWrap;

    public ExceptionCustomizerWrapper(FrameworkModel frameworkModel) {
        this.exceptionHandler = (CompositeExceptionHandler)frameworkModel.getBeanFactory().getOrRegisterBean(CompositeExceptionHandler.class);
    }

    public void setMetadata(RequestMetadata metadata) {
        this.metadata = metadata;
    }

    public void setMethodDescriptor(MethodDescriptor methodDescriptor) {
        this.methodDescriptor = methodDescriptor;
    }

    public void setNeedWrap(boolean needWrap) {
        this.needWrap = needWrap;
    }

    public Level resolveLogLevel(Throwable throwable) {
        return this.exceptionHandler.resolveLogLevel(throwable);
    }

    public void customizeGrpcStatus(HttpHeaders headers, Throwable throwable) {
        if (throwable == null) {
            headers.set((CharSequence)GrpcHeaderNames.GRPC_STATUS.getName(), "0");
            return;
        }
        this.exceptionHandler.resolveGrpcStatus(throwable, headers, this.metadata, this.methodDescriptor);
    }

    public Object customize(Throwable throwable) {
        return this.exceptionHandler.handle(throwable, this.metadata, this.methodDescriptor);
    }

    public Object customizeGrpc(Throwable throwable) {
        Object result = this.exceptionHandler.handleGrpc(throwable, this.metadata, this.methodDescriptor);
        if (this.needWrap) {
            HttpResult httpResult;
            DefaultHttpResult.Builder builder = null;
            if (result == null) {
                builder = HttpResult.builder().body((Object)throwable);
            } else if (result instanceof Throwable) {
                builder = HttpResult.builder().body(result);
            } else if (result instanceof HttpResult && (httpResult = (HttpResult)result).getBody() instanceof Throwable) {
                builder = HttpResult.builder().from(httpResult);
            }
            if (builder == null) {
                return result;
            }
            TriRpcStatus.Code code = TriRpcStatus.getStatus((Throwable)throwable).code;
            return builder.header(TripleHeaderEnum.TRI_EXCEPTION_CODE.getName(), (Object)(code == TriRpcStatus.UNKNOWN.code ? 3 : code.code)).build();
        }
        return result instanceof Throwable ? result : null;
    }
}

