/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry;

import java.util.List;
import java.util.function.Consumer;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.RegistryServiceListener;

public class ListenerRegistryWrapper
implements Registry {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ListenerRegistryWrapper.class);
    private final Registry registry;
    private final List<RegistryServiceListener> listeners;

    public ListenerRegistryWrapper(Registry registry, List<RegistryServiceListener> listeners) {
        this.registry = registry;
        this.listeners = listeners;
    }

    public URL getUrl() {
        return this.registry.getUrl();
    }

    public boolean isAvailable() {
        return this.registry.isAvailable();
    }

    public void destroy() {
        this.registry.destroy();
    }

    @Override
    public void register(URL url) {
        try {
            if (this.registry != null) {
                this.registry.register(url);
            }
        }
        finally {
            if (!UrlUtils.isConsumer((URL)url)) {
                this.listenerEvent(serviceListener -> serviceListener.onRegister(url, this.registry));
            }
        }
    }

    @Override
    public void unregister(URL url) {
        try {
            if (this.registry != null) {
                this.registry.unregister(url);
            }
        }
        finally {
            if (!UrlUtils.isConsumer((URL)url)) {
                this.listenerEvent(serviceListener -> serviceListener.onUnregister(url, this.registry));
            }
        }
    }

    @Override
    public void subscribe(URL url, NotifyListener listener) {
        try {
            if (this.registry != null) {
                this.registry.subscribe(url, listener);
            }
        }
        finally {
            this.listenerEvent(serviceListener -> serviceListener.onSubscribe(url, this.registry));
        }
    }

    @Override
    public void unsubscribe(URL url, NotifyListener listener) {
        try {
            this.registry.unsubscribe(url, listener);
        }
        finally {
            this.listenerEvent(serviceListener -> serviceListener.onUnsubscribe(url, this.registry));
        }
    }

    @Override
    public boolean isServiceDiscovery() {
        return this.registry.isServiceDiscovery();
    }

    @Override
    public List<URL> lookup(URL url) {
        return this.registry.lookup(url);
    }

    public Registry getRegistry() {
        return this.registry;
    }

    private void listenerEvent(Consumer<RegistryServiceListener> consumer) {
        if (CollectionUtils.isNotEmpty(this.listeners)) {
            RuntimeException exception = null;
            for (RegistryServiceListener listener : this.listeners) {
                if (listener == null) continue;
                try {
                    consumer.accept(listener);
                }
                catch (RuntimeException t) {
                    logger.error("99-0", "unknown error in registry module", "", t.getMessage(), (Throwable)t);
                    exception = t;
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }
}

