/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata.store;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.cache.FileCacheStore;
import org.apache.dubbo.common.cache.FileCacheStoreFactory;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.resource.Disposable;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.common.utils.LRUCache;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;

public class MetaCacheManager
implements ScopeModelAware,
Disposable {
    private static final Logger logger = LoggerFactory.getLogger(MetaCacheManager.class);
    private static final String DEFAULT_FILE_NAME = ".metadata";
    private static final String DEFAULT_COMMENT = "Metadata cache";
    private static final int DEFAULT_ENTRY_SIZE = 1000;
    private static final long INTERVAL = 60L;
    private ScheduledExecutorService executorService;
    protected FileCacheStore cacheStore;
    protected LRUCache<String, MetadataInfo> cache;

    public static MetaCacheManager getInstance(ScopeModel scopeModel) {
        return (MetaCacheManager)scopeModel.getBeanFactory().getOrRegisterBean(MetaCacheManager.class);
    }

    public MetaCacheManager() {
        this("");
    }

    public MetaCacheManager(String registryName) {
        String rawEntrySize;
        int entrySize;
        String filePath = System.getProperty("dubbo.meta.cache.filePath");
        String fileName = System.getProperty("dubbo.meta.cache.fileName");
        if (StringUtils.isEmpty((String)fileName)) {
            fileName = DEFAULT_FILE_NAME;
        }
        if (StringUtils.isNotEmpty((String)registryName)) {
            fileName = fileName + "." + registryName;
        }
        entrySize = (entrySize = StringUtils.parseInteger((String)(rawEntrySize = System.getProperty("dubbo.meta.cache.entrySize")))) == 0 ? 1000 : entrySize;
        this.cache = new LRUCache(entrySize);
        try {
            this.cacheStore = FileCacheStoreFactory.getInstance((String)filePath, (String)fileName);
            Map properties = this.cacheStore.loadCache(entrySize);
            logger.info("Successfully loaded meta cache from file " + fileName + ", entries " + properties.size());
            for (Map.Entry entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                MetadataInfo metadataInfo = (MetadataInfo)JsonUtils.getGson().fromJson(value, MetadataInfo.class);
                this.cache.put((Object)key, (Object)metadataInfo);
            }
            this.executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("Dubbo-cache-refresh", true));
            String rawMaxFileSize = System.getProperty("dubbo.meta.cache.maxFileSize");
            long maxFileSize = StringUtils.parseLong((String)rawMaxFileSize);
            this.executorService.scheduleWithFixedDelay(new CacheRefreshTask(this.cacheStore, this.cache, maxFileSize), 10L, 60L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            logger.error("Load metadata from local cache file error ", (Throwable)e);
        }
    }

    public MetadataInfo get(String key) {
        return (MetadataInfo)this.cache.get((Object)key);
    }

    public void put(String key, MetadataInfo metadataInfo) {
        this.cache.put((Object)key, (Object)metadataInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, MetadataInfo> getAll() {
        if (this.cache.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap copyMap = new HashMap();
        this.cache.lock();
        try {
            for (Map.Entry entry : this.cache.entrySet()) {
                copyMap.put(entry.getKey(), entry.getValue());
            }
        }
        finally {
            this.cache.releaseLock();
        }
        return Collections.unmodifiableMap(copyMap);
    }

    public void update(Map<String, MetadataInfo> revisionToMetadata) {
        for (Map.Entry<String, MetadataInfo> entry : revisionToMetadata.entrySet()) {
            this.cache.put((Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    public void destroy() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        if (this.cacheStore != null) {
            this.cacheStore.destroy();
        }
    }

    protected static class CacheRefreshTask
    implements Runnable {
        private final FileCacheStore cacheStore;
        private final LRUCache<String, MetadataInfo> cache;
        private final long maxFileSize;

        public CacheRefreshTask(FileCacheStore cacheStore, LRUCache<String, MetadataInfo> cache, long maxFileSize) {
            this.cacheStore = cacheStore;
            this.cache = cache;
            this.maxFileSize = maxFileSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap properties = new HashMap();
            this.cache.lock();
            try {
                for (Map.Entry entry : this.cache.entrySet()) {
                    properties.put(entry.getKey(), JsonUtils.getGson().toJson(entry.getValue()));
                }
            }
            finally {
                this.cache.releaseLock();
            }
            logger.info("Dumping meta caches, latest entries " + properties.size());
            this.cacheStore.refreshCache(properties, MetaCacheManager.DEFAULT_COMMENT, this.maxFileSize);
        }
    }
}

