/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.definition.model.FullServiceDefinition;
import org.apache.dubbo.metadata.definition.model.ServiceDefinition;
import org.apache.dubbo.metadata.report.MetadataReport;
import org.apache.dubbo.metadata.report.MetadataReportInstance;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.SubscriberMetadataIdentifier;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.metadata.MetadataServiceURLBuilder;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ServiceDescriptor;

public class MetadataUtils {
    public static final Logger logger = LoggerFactory.getLogger(MetadataUtils.class);
    public static ConcurrentMap<String, MetadataService> metadataServiceProxies = new ConcurrentHashMap<String, MetadataService>();
    public static ConcurrentMap<String, Invoker<?>> metadataServiceInvokers = new ConcurrentHashMap();

    public static ConcurrentMap<String, Invoker<?>> getMetadataServiceInvokers() {
        return metadataServiceInvokers;
    }

    public static synchronized MetadataService getMetadataServiceProxy(ServiceInstance instance) {
        return metadataServiceProxies.computeIfAbsent(MetadataUtils.computeKey(instance), k -> MetadataUtils.referProxy(k, instance));
    }

    public static void publishServiceDefinition(String serviceName, URL url, ModuleModel scopeModel, ApplicationModel applicationModel) {
        if (MetadataUtils.getMetadataReports(applicationModel).size() == 0) {
            String msg = "Remote Metadata Report Server not hasn't been configured or unavailable . Unable to get Metadata from remote!";
            logger.warn(msg);
        }
        try {
            String side = url.getSide();
            if ("provider".equalsIgnoreCase(side)) {
                ServiceDescriptor serviceDescriptor = scopeModel.getServiceRepository().getService(serviceName);
                if (serviceDescriptor == null) {
                    return;
                }
                FullServiceDefinition serviceDefinition = serviceDescriptor.getServiceDefinition(serviceName);
                if (StringUtils.isNotEmpty((String)serviceName) && serviceDefinition != null) {
                    serviceDefinition.setParameters(url.getParameters());
                    for (Map.Entry<String, MetadataReport> entry : MetadataUtils.getMetadataReports(applicationModel).entrySet()) {
                        MetadataReport metadataReport = entry.getValue();
                        metadataReport.storeProviderMetadata(new MetadataIdentifier(serviceName, url.getVersion() == null ? "" : url.getVersion(), url.getGroup() == null ? "" : url.getGroup(), "provider", applicationModel.getApplicationName()), (ServiceDefinition)serviceDefinition);
                    }
                }
            } else {
                for (Map.Entry<String, MetadataReport> entry : MetadataUtils.getMetadataReports(applicationModel).entrySet()) {
                    MetadataReport metadataReport = entry.getValue();
                    metadataReport.storeConsumerMetadata(new MetadataIdentifier(serviceName, url.getVersion() == null ? "" : url.getVersion(), url.getGroup() == null ? "" : url.getGroup(), "consumer", applicationModel.getApplicationName()), url.getParameters());
                }
            }
        }
        catch (Exception e) {
            logger.error("publish service definition metadata error.", (Throwable)e);
        }
    }

    public static String computeKey(ServiceInstance serviceInstance) {
        return serviceInstance.getServiceName() + "##" + serviceInstance.getAddress() + "##" + ServiceInstanceMetadataUtils.getExportedServicesRevision(serviceInstance);
    }

    public static synchronized void destroyMetadataServiceProxy(ServiceInstance instance) {
        String key = MetadataUtils.computeKey(instance);
        if (metadataServiceProxies.containsKey(key)) {
            metadataServiceProxies.remove(key);
        }
        if (metadataServiceInvokers.containsKey(key)) {
            Invoker invoker = (Invoker)metadataServiceInvokers.remove(key);
            invoker.destroy();
        }
    }

    private static MetadataService referProxy(String key, ServiceInstance instance) {
        ExtensionLoader loader = instance.getApplicationModel().getExtensionLoader(MetadataServiceURLBuilder.class);
        Map<String, String> metadata = instance.getMetadata();
        String dubboUrlsForJson = metadata.get("dubbo.metadata-service.urls");
        MetadataServiceURLBuilder builder = metadata.isEmpty() || StringUtils.isEmpty((String)dubboUrlsForJson) ? (MetadataServiceURLBuilder)loader.getExtension("standard") : (MetadataServiceURLBuilder)loader.getExtension("spring-cloud");
        List<URL> urls = builder.build(instance);
        if (CollectionUtils.isEmpty(urls)) {
            throw new IllegalStateException("Introspection service discovery mode is enabled " + instance + ", but no metadata service can build from it.");
        }
        ApplicationModel scopeModel = instance.getApplicationModel();
        Protocol protocol = (Protocol)scopeModel.getExtensionLoader(Protocol.class).getAdaptiveExtension();
        Invoker invoker = protocol.refer(MetadataService.class, urls.get(0));
        metadataServiceInvokers.put(key, invoker);
        ProxyFactory proxyFactory = (ProxyFactory)scopeModel.getExtensionLoader(ProxyFactory.class).getAdaptiveExtension();
        return (MetadataService)proxyFactory.getProxy(invoker);
    }

    public static ConcurrentMap<String, MetadataService> getMetadataServiceProxies() {
        return metadataServiceProxies;
    }

    public static MetadataInfo getRemoteMetadata(String revision, ServiceInstance instance, MetadataReport metadataReport) {
        MetadataInfo metadataInfo;
        String metadataType = ServiceInstanceMetadataUtils.getMetadataStorageType(instance);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Instance " + instance.getAddress() + " is using metadata type " + metadataType);
            }
            if ("remote".equals(metadataType)) {
                metadataInfo = MetadataUtils.getMetadata(revision, instance, metadataReport);
            } else {
                MetadataService metadataServiceProxy = MetadataUtils.getMetadataServiceProxy(instance);
                metadataInfo = metadataServiceProxy.getMetadataInfo(ServiceInstanceMetadataUtils.getExportedServicesRevision(instance));
                MetadataUtils.destroyMetadataServiceProxy(instance);
            }
        }
        catch (Exception e) {
            metadataInfo = null;
        }
        if (metadataInfo == null) {
            metadataInfo = MetadataInfo.EMPTY;
        }
        return metadataInfo;
    }

    public static MetadataInfo getMetadata(String revision, ServiceInstance instance, MetadataReport metadataReport) {
        SubscriberMetadataIdentifier identifier = new SubscriberMetadataIdentifier(instance.getServiceName(), revision);
        if (metadataReport == null) {
            throw new IllegalStateException("No valid remote metadata report specified.");
        }
        String registryCluster = instance.getRegistryCluster();
        HashMap<String, String> params = new HashMap<String, String>(instance.getExtendParams());
        if (registryCluster != null && !registryCluster.equalsIgnoreCase((String)params.get("REGISTRY_CLUSTER"))) {
            params.put("REGISTRY_CLUSTER", registryCluster);
        }
        return metadataReport.getAppMetadata(identifier, params);
    }

    private static Map<String, MetadataReport> getMetadataReports(ApplicationModel applicationModel) {
        return ((MetadataReportInstance)applicationModel.getBeanFactory().getBean(MetadataReportInstance.class)).getMetadataReports(false);
    }
}

