/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.event.listener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.RetryServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

public class ServiceInstancesChangedListener {
    private static final Logger logger = LoggerFactory.getLogger(ServiceInstancesChangedListener.class);
    protected final Set<String> serviceNames;
    protected final ServiceDiscovery serviceDiscovery;
    protected URL url;
    protected Map<String, Set<NotifyListener>> listeners;
    protected ConcurrentLinkedQueue<NotifyListenerWithKey> listenerQueue;
    protected AtomicBoolean destroyed = new AtomicBoolean(false);
    protected Map<String, List<ServiceInstance>> allInstances;
    protected Map<String, Object> serviceUrls;
    private volatile long lastRefreshTime;
    private final Semaphore retryPermission;
    private volatile ScheduledFuture<?> retryFuture;
    private final ScheduledExecutorService scheduler;
    private volatile boolean hasEmptyMetadata;

    public ServiceInstancesChangedListener(Set<String> serviceNames, ServiceDiscovery serviceDiscovery) {
        this.serviceNames = serviceNames;
        this.serviceDiscovery = serviceDiscovery;
        this.listeners = new ConcurrentHashMap<String, Set<NotifyListener>>();
        this.listenerQueue = new ConcurrentLinkedQueue();
        this.allInstances = new HashMap<String, List<ServiceInstance>>();
        this.serviceUrls = new HashMap<String, Object>();
        this.retryPermission = new Semaphore(1);
        this.scheduler = ((ExecutorRepository)ScopeModelUtil.getApplicationModel(serviceDiscovery == null || serviceDiscovery.getUrl() == null ? null : serviceDiscovery.getUrl().getScopeModel()).getExtensionLoader(ExecutorRepository.class).getDefaultExtension()).getMetadataRetryExecutor();
    }

    public void onEvent(ServiceInstancesChangedEvent event) {
        if (this.destroyed.get() || !this.accept(event) || this.isRetryAndExpired(event)) {
            return;
        }
        this.doOnEvent(event);
    }

    private synchronized void doOnEvent(ServiceInstancesChangedEvent event) {
        if (this.destroyed.get() || !this.accept(event) || this.isRetryAndExpired(event)) {
            return;
        }
        this.refreshInstance(event);
        if (logger.isDebugEnabled()) {
            logger.debug(event.getServiceInstances().toString());
        }
        HashMap<String, List<ServiceInstance>> revisionToInstances = new HashMap<String, List<ServiceInstance>>();
        HashMap<String, Map<String, Set<String>>> localServiceToRevisions = new HashMap<String, Map<String, Set<String>>>();
        for (Map.Entry<String, List<ServiceInstance>> entry : this.allInstances.entrySet()) {
            List<ServiceInstance> instances = entry.getValue();
            for (ServiceInstance serviceInstance : instances) {
                String revision = ServiceInstanceMetadataUtils.getExportedServicesRevision(serviceInstance);
                if (revision == null || "0".equals(revision)) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Find instance without valid service metadata: " + serviceInstance.getAddress());
                    continue;
                }
                List subInstances = revisionToInstances.computeIfAbsent(revision, r -> new LinkedList());
                subInstances.add(serviceInstance);
            }
        }
        for (Map.Entry<String, List<ServiceInstance>> entry : revisionToInstances.entrySet()) {
            String revision = entry.getKey();
            List<ServiceInstance> subInstances = entry.getValue();
            ServiceInstance serviceInstance = this.selectInstance(subInstances);
            MetadataInfo metadata = this.serviceDiscovery.getRemoteMetadata(revision, serviceInstance);
            this.parseMetadata(revision, metadata, localServiceToRevisions);
            for (ServiceInstance tmpInstance : subInstances) {
                MetadataInfo originMetadata = tmpInstance.getServiceMetadata();
                if (originMetadata != null && Objects.equals(originMetadata.getRevision(), metadata.getRevision())) continue;
                tmpInstance.setServiceMetadata(metadata);
            }
        }
        int emptyNum = this.hasEmptyMetadata(revisionToInstances);
        if (emptyNum != 0) {
            this.hasEmptyMetadata = true;
            if (this.retryPermission.tryAcquire()) {
                if (this.retryFuture != null && !this.retryFuture.isDone()) {
                    this.retryFuture.cancel(true);
                }
                this.retryFuture = this.scheduler.schedule(new AddressRefreshRetryTask(this.retryPermission, event.getServiceName()), 10000L, TimeUnit.MILLISECONDS);
                logger.warn("Address refresh try task submitted.");
            }
            logger.error("Address refresh failed because of Metadata Server failure, wait for retry or new address refresh event.");
            if (emptyNum == revisionToInstances.size()) {
                return;
            }
        }
        this.hasEmptyMetadata = false;
        HashMap hashMap = new HashMap();
        HashMap<String, Object> newServiceUrls = new HashMap<String, Object>();
        for (Map.Entry entry : localServiceToRevisions.entrySet()) {
            String protocol = (String)entry.getKey();
            ((Map)entry.getValue()).forEach((protocolServiceKey, revisions) -> {
                Map revisionsToUrls = protocolRevisionsToUrls.computeIfAbsent(protocol, k -> new HashMap());
                Object urls = revisionsToUrls.get(revisions);
                if (urls == null) {
                    urls = this.getServiceUrlsCache((Map<String, List<ServiceInstance>>)revisionToInstances, (Set<String>)revisions, protocol);
                    revisionsToUrls.put(revisions, urls);
                }
                newServiceUrls.put((String)protocolServiceKey, urls);
            });
        }
        this.serviceUrls = newServiceUrls;
        this.notifyAddressChanged();
    }

    public synchronized void addListenerAndNotify(String serviceKey, NotifyListener listener) {
        List<URL> urls;
        Set<NotifyListener> notifyListeners;
        if (!this.listeners.containsKey(serviceKey)) {
            this.listeners.put(serviceKey, (Set<NotifyListener>)new ConcurrentHashSet());
        }
        if ((notifyListeners = this.listeners.get(serviceKey)).add(listener)) {
            NotifyListenerWithKey listenerWithKey = new NotifyListenerWithKey(serviceKey, listener);
            this.listenerQueue.offer(listenerWithKey);
        }
        if (CollectionUtils.isNotEmpty(urls = this.getAddresses(serviceKey, listener.getConsumerUrl()))) {
            listener.notify(urls);
        }
    }

    public synchronized void removeListener(String serviceKey, NotifyListener notifyListener) {
        Set<NotifyListener> notifyListeners = this.listeners.get(serviceKey);
        if (notifyListeners != null) {
            if (notifyListeners.contains(notifyListener)) {
                notifyListeners.remove(notifyListener);
                NotifyListenerWithKey listenerWithKey = new NotifyListenerWithKey(serviceKey, notifyListener);
                this.listenerQueue.remove(listenerWithKey);
            }
            if (notifyListeners.size() == 0) {
                this.listeners.remove(serviceKey);
            }
        }
        logger.info("Interface listener of interface " + serviceKey + " removed.");
    }

    public boolean hasListeners() {
        return CollectionUtils.isNotEmptyMap(this.listeners);
    }

    public final Set<String> getServiceNames() {
        return this.serviceNames;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    public Map<String, List<ServiceInstance>> getAllInstances() {
        return this.allInstances;
    }

    private boolean accept(ServiceInstancesChangedEvent event) {
        return this.serviceNames.contains(event.getServiceName());
    }

    protected boolean isRetryAndExpired(ServiceInstancesChangedEvent event) {
        if (event instanceof RetryServiceInstancesChangedEvent) {
            RetryServiceInstancesChangedEvent retryEvent = (RetryServiceInstancesChangedEvent)event;
            logger.warn("Received address refresh retry event, " + retryEvent.getFailureRecordTime());
            if (retryEvent.getFailureRecordTime() < this.lastRefreshTime && !this.hasEmptyMetadata) {
                logger.warn("Ignore retry event, event time: " + retryEvent.getFailureRecordTime() + ", last refresh time: " + this.lastRefreshTime);
                return true;
            }
            logger.warn("Retrying address notification...");
        }
        return false;
    }

    private void refreshInstance(ServiceInstancesChangedEvent event) {
        if (event instanceof RetryServiceInstancesChangedEvent) {
            return;
        }
        String appName = event.getServiceName();
        List<ServiceInstance> appInstances = event.getServiceInstances();
        logger.info("Received instance notification, serviceName: " + appName + ", instances: " + appInstances.size());
        this.allInstances.put(appName, appInstances);
        this.lastRefreshTime = System.currentTimeMillis();
    }

    protected int hasEmptyMetadata(Map<String, List<ServiceInstance>> revisionToInstances) {
        if (revisionToInstances == null) {
            return 0;
        }
        int emptyMetadataNum = 0;
        for (Map.Entry<String, List<ServiceInstance>> entry : revisionToInstances.entrySet()) {
            DefaultServiceInstance serviceInstance = (DefaultServiceInstance)entry.getValue().get(0);
            if (serviceInstance != null && serviceInstance.getServiceMetadata() != MetadataInfo.EMPTY) continue;
            ++emptyMetadataNum;
        }
        return emptyMetadataNum;
    }

    protected Map<String, Map<String, Set<String>>> parseMetadata(String revision, MetadataInfo metadata, Map<String, Map<String, Set<String>>> localServiceToRevisions) {
        Map serviceInfos = metadata.getServices();
        for (Map.Entry entry : serviceInfos.entrySet()) {
            String protocol = ((MetadataInfo.ServiceInfo)entry.getValue()).getProtocol();
            String protocolServiceKey = ((MetadataInfo.ServiceInfo)entry.getValue()).getMatchKey();
            Map map = localServiceToRevisions.computeIfAbsent(protocol, _p -> new HashMap());
            Set set = map.computeIfAbsent(protocolServiceKey, _k -> new TreeSet());
            set.add(revision);
        }
        return localServiceToRevisions;
    }

    private ServiceInstance selectInstance(List<ServiceInstance> instances) {
        if (instances.size() == 1) {
            return instances.get(0);
        }
        return instances.get(ThreadLocalRandom.current().nextInt(0, instances.size()));
    }

    protected Object getServiceUrlsCache(Map<String, List<ServiceInstance>> revisionToInstances, Set<String> revisions, String protocol) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String r : revisions) {
            for (ServiceInstance i : revisionToInstances.get(r)) {
                DefaultServiceInstance.Endpoint endpoint;
                if (ServiceInstanceMetadataUtils.hasEndpoints(i) && (endpoint = ServiceInstanceMetadataUtils.getEndpoint(i, protocol)) != null && endpoint.getPort() != i.getPort()) {
                    urls.add(((DefaultServiceInstance)i).copyFrom(endpoint).toURL());
                    continue;
                }
                urls.add(i.toURL().setScopeModel((ScopeModel)i.getApplicationModel()));
            }
        }
        return urls;
    }

    protected List<URL> getAddresses(String serviceProtocolKey, URL consumerURL) {
        return (List)this.serviceUrls.get(serviceProtocolKey);
    }

    protected void notifyAddressChanged() {
        this.listenerQueue.forEach(listenerWithKey -> {
            String key = listenerWithKey.getServiceKey();
            NotifyListener notifyListener = listenerWithKey.getNotifyListener();
            List<URL> urls = this.toUrlsWithEmpty(this.getAddresses(key, notifyListener.getConsumerUrl()));
            logger.info("Notify service " + key + " with urls " + urls.size());
            notifyListener.notify(urls);
        });
    }

    protected List<URL> toUrlsWithEmpty(List<URL> urls) {
        if (urls == null) {
            urls = Collections.emptyList();
        }
        boolean emptyProtectionEnabled = this.serviceDiscovery.getUrl().getParameter("enable-empty-protection", true);
        if (CollectionUtils.isEmpty(urls) && !emptyProtectionEnabled) {
            ServiceConfigURL empty = URLBuilder.from((URL)this.url).setProtocol("empty").build();
            urls.add((URL)empty);
        }
        return urls;
    }

    public synchronized void destroy() {
        if (!this.destroyed.get() && CollectionUtils.isEmptyMap(this.listeners) && this.destroyed.compareAndSet(false, true)) {
            if (this.listeners.isEmpty()) {
                logger.info("No interface listeners exist, will stop instance listener for " + this.getServiceNames());
                this.serviceDiscovery.removeServiceInstancesChangedListener(this);
            }
            this.allInstances.clear();
            this.serviceUrls.clear();
            if (this.retryFuture != null && !this.retryFuture.isDone()) {
                this.retryFuture.cancel(true);
            }
        }
    }

    public boolean isDestroyed() {
        return this.destroyed.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceInstancesChangedListener)) {
            return false;
        }
        ServiceInstancesChangedListener that = (ServiceInstancesChangedListener)o;
        return Objects.equals(this.getServiceNames(), that.getServiceNames());
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.getServiceNames());
    }

    public List<ServiceInstance> getInstancesOfApp(String appName) {
        return this.allInstances.get(appName);
    }

    protected static class NotifyListenerWithKey {
        private String serviceKey;
        private NotifyListener notifyListener;

        public NotifyListenerWithKey(String serviceKey, NotifyListener notifyListener) {
            this.serviceKey = serviceKey;
            this.notifyListener = notifyListener;
        }

        public String getServiceKey() {
            return this.serviceKey;
        }

        public NotifyListener getNotifyListener() {
            return this.notifyListener;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NotifyListenerWithKey that = (NotifyListenerWithKey)o;
            return Objects.equals(this.serviceKey, that.serviceKey) && Objects.equals(this.notifyListener, that.notifyListener);
        }

        public int hashCode() {
            return Objects.hash(this.serviceKey, this.notifyListener);
        }
    }

    protected class AddressRefreshRetryTask
    implements Runnable {
        private final RetryServiceInstancesChangedEvent retryEvent;
        private final Semaphore retryPermission;

        public AddressRefreshRetryTask(Semaphore semaphore, String serviceName) {
            this.retryEvent = new RetryServiceInstancesChangedEvent(serviceName);
            this.retryPermission = semaphore;
        }

        @Override
        public void run() {
            this.retryPermission.release();
            ServiceInstancesChangedListener.this.onEvent(this.retryEvent);
        }
    }
}

