/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.function.ThrowableAction;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metadata.MappingChangedEvent;
import org.apache.dubbo.metadata.MappingListener;
import org.apache.dubbo.metadata.ServiceNameMapping;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceDiscoveryFactory;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.client.metadata.SubscribedURLsSynthesizer;
import org.apache.dubbo.registry.support.FailbackRegistry;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModel;

public class ServiceDiscoveryRegistry
extends FailbackRegistry {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ServiceDiscovery serviceDiscovery;
    private final ServiceNameMapping serviceNameMapping;
    private final Map<String, ServiceInstancesChangedListener> serviceListeners = new ConcurrentHashMap<String, ServiceInstancesChangedListener>();

    public ServiceDiscoveryRegistry(URL registryURL, ApplicationModel applicationModel) {
        super(registryURL);
        this.serviceDiscovery = this.createServiceDiscovery(registryURL);
        this.serviceNameMapping = ServiceNameMapping.getDefaultExtension((ScopeModel)registryURL.getScopeModel());
        this.applicationModel = applicationModel;
    }

    protected ServiceDiscoveryRegistry(URL registryURL, ServiceDiscovery serviceDiscovery, ServiceNameMapping serviceNameMapping) {
        super(registryURL);
        this.serviceDiscovery = serviceDiscovery;
        this.serviceNameMapping = serviceNameMapping;
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    protected ServiceDiscovery createServiceDiscovery(URL registryURL) {
        return this.getServiceDiscovery(registryURL.addParameter("interface", ServiceDiscovery.class.getName()).removeParameter("registry-type"));
    }

    private List<SubscribedURLsSynthesizer> initSubscribedURLsSynthesizers() {
        ExtensionLoader loader = this.getUrl().getOrDefaultApplicationModel().getExtensionLoader(SubscribedURLsSynthesizer.class);
        return Collections.unmodifiableList(new ArrayList(loader.getSupportedExtensionInstances()));
    }

    private ServiceDiscovery getServiceDiscovery(URL registryURL) {
        ServiceDiscoveryFactory factory = ServiceDiscoveryFactory.getExtension(registryURL);
        return factory.getServiceDiscovery(registryURL);
    }

    protected boolean shouldRegister(URL providerURL) {
        String side = providerURL.getSide();
        boolean should = "provider".equals(side);
        if (!should && this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("The URL[%s] should not be registered.", providerURL));
        }
        if (!this.acceptable(providerURL)) {
            this.logger.info("URL " + providerURL + " will not be registered to Registry. Registry " + this.getUrl() + " does not accept service of this protocol type.");
            return false;
        }
        return should;
    }

    protected boolean shouldSubscribe(URL subscribedURL) {
        return !this.shouldRegister(subscribedURL);
    }

    @Override
    public final void register(URL url) {
        if (!this.shouldRegister(url)) {
            return;
        }
        this.doRegister(url);
    }

    @Override
    public void doRegister(URL url) {
        url = this.addRegistryClusterKey(url);
        this.serviceDiscovery.register(url);
    }

    @Override
    public final void unregister(URL url) {
        if (!this.shouldRegister(url)) {
            return;
        }
        this.doUnregister(url);
    }

    @Override
    public void doUnregister(URL url) {
        url = this.addRegistryClusterKey(url);
        this.serviceDiscovery.unregister(url);
    }

    @Override
    public final void subscribe(URL url, NotifyListener listener) {
        if (!this.shouldSubscribe(url)) {
            return;
        }
        this.doSubscribe(url, listener);
    }

    @Override
    public void doSubscribe(URL url, NotifyListener listener) {
        url = this.addRegistryClusterKey(url);
        this.serviceDiscovery.subscribe(url, listener);
        boolean check = url.getParameter("check", false);
        Set subscribedServices = Collections.emptySet();
        try {
            subscribedServices = this.serviceNameMapping.getAndListen(this.getUrl(), url, (MappingListener)new DefaultMappingListener(url, subscribedServices, listener));
        }
        catch (Exception e) {
            this.logger.warn("Cannot find app mapping for service " + url.getServiceInterface() + ", will not migrate.", (Throwable)e);
        }
        if (CollectionUtils.isEmpty((Collection)subscribedServices)) {
            if (check) {
                throw new IllegalStateException("Should has at least one way to know which services this interface belongs to, subscription url: " + url);
            }
            return;
        }
        this.subscribeURLs(url, listener, subscribedServices);
    }

    @Override
    public final void unsubscribe(URL url, NotifyListener listener) {
        if (!this.shouldSubscribe(url)) {
            return;
        }
        url = this.addRegistryClusterKey(url);
        this.doUnsubscribe(url, listener);
    }

    private URL addRegistryClusterKey(URL url) {
        String registryCluster = this.serviceDiscovery.getUrl().getParameter("REGISTRY_CLUSTER");
        if (registryCluster != null && url.getParameter("REGISTRY_CLUSTER") == null) {
            url = url.addParameter("REGISTRY_CLUSTER", registryCluster);
        }
        return url;
    }

    @Override
    public void doUnsubscribe(URL url, NotifyListener listener) {
        String serviceNamesKey;
        ServiceInstancesChangedListener instancesChangedListener;
        this.serviceDiscovery.unsubscribe(url, listener);
        String protocolServiceKey = url.getServiceKey() + ":" + url.getParameter("protocol", "dubbo");
        Set serviceNames = this.serviceNameMapping.getCachedMapping(url);
        this.serviceNameMapping.stopListen(url);
        if (CollectionUtils.isNotEmpty((Collection)serviceNames) && (instancesChangedListener = this.serviceListeners.get(serviceNamesKey = ServiceNameMapping.toStringKeys((Set)serviceNames))) != null) {
            instancesChangedListener.removeListener(protocolServiceKey, listener);
            if (!instancesChangedListener.hasListeners()) {
                this.serviceListeners.remove(serviceNamesKey);
                instancesChangedListener.destroy();
            }
        }
    }

    @Override
    public List<URL> lookup(URL url) {
        throw new UnsupportedOperationException("");
    }

    public boolean isAvailable() {
        return !this.serviceDiscovery.isDestroy() && !this.serviceDiscovery.getServices().isEmpty();
    }

    @Override
    public void destroy() {
        this.registryManager.removeDestroyedRegistry(this);
        ThrowableAction.execute(this.serviceDiscovery::destroy);
        for (ServiceInstancesChangedListener listener : this.serviceListeners.values()) {
            listener.destroy();
        }
        this.serviceListeners.clear();
    }

    @Override
    public boolean isServiceDiscovery() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void subscribeURLs(URL url, NotifyListener listener, Set<String> serviceNames) {
        ServiceInstancesChangedListener serviceInstancesChangedListener;
        serviceNames = new TreeSet<String>(serviceNames);
        String serviceNamesKey = ServiceNameMapping.toStringKeys(serviceNames);
        String protocolServiceKey = url.getServiceKey() + ":" + url.getParameter("protocol", "dubbo");
        ServiceDiscoveryRegistry serviceDiscoveryRegistry = this;
        synchronized (serviceDiscoveryRegistry) {
            serviceInstancesChangedListener = this.serviceListeners.get(serviceNamesKey);
            if (serviceInstancesChangedListener == null) {
                serviceInstancesChangedListener = this.serviceDiscovery.createListener(serviceNames);
                serviceInstancesChangedListener.setUrl(url);
                for (String serviceName : serviceNames) {
                    List<ServiceInstance> serviceInstances = this.serviceDiscovery.getInstances(serviceName);
                    if (!CollectionUtils.isNotEmpty(serviceInstances)) continue;
                    serviceInstancesChangedListener.onEvent(new ServiceInstancesChangedEvent(serviceName, serviceInstances));
                }
                this.serviceListeners.put(serviceNamesKey, serviceInstancesChangedListener);
            }
        }
        serviceInstancesChangedListener.setUrl(url);
        listener.addServiceListener(serviceInstancesChangedListener);
        serviceInstancesChangedListener.addListenerAndNotify(protocolServiceKey, listener);
        this.serviceDiscovery.addServiceInstancesChangedListener(serviceInstancesChangedListener);
    }

    public static boolean supports(URL registryURL) {
        return "service".equalsIgnoreCase(registryURL.getParameter("registry-type"));
    }

    public Map<String, ServiceInstancesChangedListener> getServiceListeners() {
        return this.serviceListeners;
    }

    private class DefaultMappingListener
    implements MappingListener {
        private final Logger logger = LoggerFactory.getLogger(DefaultMappingListener.class);
        private URL url;
        private Set<String> oldApps;
        private NotifyListener listener;
        private boolean stopped;

        public DefaultMappingListener(URL subscribedURL, Set<String> serviceNames, NotifyListener listener) {
            this.url = subscribedURL;
            this.oldApps = serviceNames;
            this.listener = listener;
        }

        public void onEvent(MappingChangedEvent event) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Received mapping notification from meta server, " + event);
            }
            if (this.stopped) {
                this.logger.warn("Listener has been stopped, ignore mapping notification, check why listener is not removed.");
                return;
            }
            Set newApps = event.getApps();
            Set<String> tempOldApps = this.oldApps;
            this.oldApps = newApps;
            if (CollectionUtils.isEmpty((Collection)newApps)) {
                return;
            }
            if (CollectionUtils.isEmpty(tempOldApps) && newApps.size() > 0) {
                ServiceDiscoveryRegistry.this.serviceNameMapping.putCachedMapping(ServiceNameMapping.buildMappingKey((URL)this.url), newApps);
                ServiceDiscoveryRegistry.this.subscribeURLs(this.url, this.listener, newApps);
                return;
            }
            for (String newAppName : newApps) {
                if (tempOldApps.contains(newAppName)) continue;
                ServiceDiscoveryRegistry.this.serviceNameMapping.removeCachedMapping(ServiceNameMapping.buildMappingKey((URL)this.url));
                ServiceDiscoveryRegistry.this.serviceNameMapping.putCachedMapping(ServiceNameMapping.buildMappingKey((URL)this.url), newApps);
                ServiceDiscoveryRegistry.this.subscribeURLs(this.url, this.listener, newApps);
                return;
            }
        }

        public void stop() {
            this.stopped = true;
        }
    }
}

