/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.util.List;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.report.MetadataReport;
import org.apache.dubbo.metadata.report.MetadataReportInstance;
import org.apache.dubbo.metadata.report.identifier.SubscriberMetadataIdentifier;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.client.metadata.MetadataUtils;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.registry.client.metadata.store.MetaCacheManager;
import org.apache.dubbo.rpc.model.ApplicationModel;

public abstract class AbstractServiceDiscovery
implements ServiceDiscovery {
    private final Logger logger = LoggerFactory.getLogger(AbstractServiceDiscovery.class);
    private volatile boolean isDestroy;
    protected final String serviceName;
    protected volatile ServiceInstance serviceInstance;
    protected volatile MetadataInfo metadataInfo;
    protected MetadataReport metadataReport;
    protected String metadataType;
    protected MetaCacheManager metaCacheManager;
    protected URL registryURL;
    protected Set<ServiceInstancesChangedListener> instanceListeners = new ConcurrentHashSet();
    protected ApplicationModel applicationModel = ApplicationModel.defaultModel();

    public AbstractServiceDiscovery(ApplicationModel applicationModel, URL registryURL) {
        this(applicationModel.getApplicationName(), registryURL);
        this.applicationModel = applicationModel;
        MetadataReportInstance metadataReportInstance = (MetadataReportInstance)applicationModel.getBeanFactory().getBean(MetadataReportInstance.class);
        this.metadataType = metadataReportInstance.getMetadataType();
        this.metadataReport = metadataReportInstance.getMetadataReport(registryURL.getParameter("REGISTRY_CLUSTER"));
    }

    public AbstractServiceDiscovery(String serviceName, URL registryURL) {
        this.registryURL = registryURL;
        this.serviceName = serviceName;
        this.metadataInfo = new MetadataInfo(serviceName);
        this.metaCacheManager = new MetaCacheManager(this.getCacheNameSuffix());
    }

    @Override
    public synchronized void register() throws RuntimeException {
        this.serviceInstance = this.createServiceInstance(this.metadataInfo);
        if (!ServiceInstanceMetadataUtils.isValidInstance(this.serviceInstance)) {
            this.logger.warn("No valid instance found, stop registering instance address to registry.");
            return;
        }
        this.metadataInfo.calAndGetRevision();
        MetadataInfo copyOfMetaInfo = this.metadataInfo.clone();
        boolean revisionUpdated = this.calOrUpdateInstanceRevision(this.serviceInstance, copyOfMetaInfo);
        if (revisionUpdated) {
            this.reportMetadata(copyOfMetaInfo);
            this.doRegister(this.serviceInstance);
        }
    }

    @Override
    public synchronized void update() throws RuntimeException {
        if (this.isDestroy) {
            return;
        }
        if (this.serviceInstance == null) {
            this.serviceInstance = this.createServiceInstance(this.metadataInfo);
        } else if (!ServiceInstanceMetadataUtils.isValidInstance(this.serviceInstance)) {
            ServiceInstanceMetadataUtils.customizeInstance(this.serviceInstance, this.applicationModel);
        }
        if (!ServiceInstanceMetadataUtils.isValidInstance(this.serviceInstance)) {
            return;
        }
        this.metadataInfo.calAndGetRevision();
        MetadataInfo copyOfMetaInfo = this.metadataInfo.clone();
        boolean revisionUpdated = this.calOrUpdateInstanceRevision(this.serviceInstance, copyOfMetaInfo);
        if (revisionUpdated) {
            this.logger.info(String.format("Metadata of instance changed, updating instance with revision %s.", copyOfMetaInfo.getRevision()));
            this.doUpdate(this.serviceInstance, copyOfMetaInfo);
        }
    }

    @Override
    public synchronized void unregister() throws RuntimeException {
        this.doUnregister(this.serviceInstance);
    }

    @Override
    public final ServiceInstance getLocalInstance() {
        return this.serviceInstance;
    }

    @Override
    public MetadataInfo getLocalMetadata() {
        return this.metadataInfo;
    }

    @Override
    public MetadataInfo getRemoteMetadata(String revision, ServiceInstance instance) {
        MetadataInfo metadata = this.metaCacheManager.get(revision);
        if (metadata != null && metadata != MetadataInfo.EMPTY) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("MetadataInfo for instance " + instance.getAddress() + "?revision=" + revision + "&cluster=" + instance.getRegistryCluster() + ", " + metadata);
            }
            return metadata;
        }
        int triedTimes = 0;
        while (triedTimes < 3) {
            metadata = MetadataUtils.getRemoteMetadata(revision, instance, this.metadataReport);
            if (metadata != MetadataInfo.EMPTY) {
                metadata.init();
                break;
            }
            if (triedTimes > 0) {
                this.logger.info("Retry the " + triedTimes + " times to get metadata for instance " + instance.getAddress() + "?revision=" + revision + "&cluster=" + instance.getRegistryCluster());
            }
            ++triedTimes;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (metadata == MetadataInfo.EMPTY) {
            this.logger.error("Failed to get metadata for instance after 3 retries, " + instance.getAddress() + "?revision=" + revision + "&cluster=" + instance.getRegistryCluster());
        } else {
            this.metaCacheManager.put(revision, metadata);
        }
        return metadata;
    }

    @Override
    public MetadataInfo getRemoteMetadata(String revision) {
        return this.metaCacheManager.get(revision);
    }

    @Override
    public final void destroy() throws Exception {
        this.isDestroy = true;
        this.metaCacheManager.destroy();
        this.doDestroy();
    }

    @Override
    public final boolean isDestroy() {
        return this.isDestroy;
    }

    @Override
    public void register(URL url) {
        this.metadataInfo.addService(url);
    }

    @Override
    public void unregister(URL url) {
        this.metadataInfo.removeService(url);
    }

    @Override
    public void subscribe(URL url, NotifyListener listener) {
        this.metadataInfo.addSubscribedURL(url);
    }

    @Override
    public void unsubscribe(URL url, NotifyListener listener) {
        this.metadataInfo.removeSubscribedURL(url);
    }

    @Override
    public List<URL> lookup(URL url) {
        throw new UnsupportedOperationException("Service discovery implementation does not support lookup of url list.");
    }

    protected void doUpdate(ServiceInstance serviceInstance, MetadataInfo metadataInfo) throws RuntimeException {
        this.unregister();
        this.reportMetadata(metadataInfo);
        this.doRegister(serviceInstance);
    }

    @Override
    public URL getUrl() {
        return this.registryURL;
    }

    protected abstract void doRegister(ServiceInstance var1) throws RuntimeException;

    protected abstract void doUnregister(ServiceInstance var1);

    protected abstract void doDestroy() throws Exception;

    protected ServiceInstance createServiceInstance(MetadataInfo metadataInfo) {
        DefaultServiceInstance instance = new DefaultServiceInstance(this.serviceName, this.applicationModel);
        instance.setServiceMetadata(metadataInfo);
        ServiceInstanceMetadataUtils.setMetadataStorageType(instance, this.metadataType);
        ServiceInstanceMetadataUtils.customizeInstance(instance, this.applicationModel);
        return instance;
    }

    protected boolean calOrUpdateInstanceRevision(ServiceInstance instance, MetadataInfo metadataInfo) {
        String existingInstanceRevision = instance.getMetadata().get("dubbo.metadata.revision");
        String newRevision = metadataInfo.calAndGetRevision();
        if (!newRevision.equals(existingInstanceRevision)) {
            if ("0".equals(newRevision)) {
                return false;
            }
            instance.getMetadata().put("dubbo.metadata.revision", metadataInfo.calAndGetRevision());
            return true;
        }
        return false;
    }

    protected void reportMetadata(MetadataInfo metadataInfo) {
        if (this.metadataReport != null) {
            SubscriberMetadataIdentifier identifier = new SubscriberMetadataIdentifier(this.serviceName, metadataInfo.getRevision());
            this.metadataReport.publishAppMetadata(identifier, metadataInfo);
        }
    }

    protected void unReportMetadata(MetadataInfo metadataInfo) {
        if (this.metadataReport != null) {
            SubscriberMetadataIdentifier identifier = new SubscriberMetadataIdentifier(this.serviceName, metadataInfo.getRevision());
            this.metadataReport.unPublishAppMetadata(identifier, metadataInfo);
        }
    }

    private String getCacheNameSuffix() {
        URL url;
        String name = this.getClass().getSimpleName();
        int i = name.indexOf(ServiceDiscovery.class.getSimpleName());
        if (i != -1) {
            name = name.substring(0, i);
        }
        if ((url = this.getUrl()) != null) {
            return name.toLowerCase() + url.getBackupAddress();
        }
        return name.toLowerCase();
    }
}

