/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.integration;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.client.migration.InvokersChangedListener;
import org.apache.dubbo.registry.integration.RegistryProtocol;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.cluster.Configurator;
import org.apache.dubbo.rpc.cluster.RouterChain;
import org.apache.dubbo.rpc.cluster.RouterFactory;
import org.apache.dubbo.rpc.cluster.directory.AbstractDirectory;

public abstract class DynamicDirectory<T>
extends AbstractDirectory<T>
implements NotifyListener {
    private static final Logger logger = LoggerFactory.getLogger(DynamicDirectory.class);
    protected static final Cluster CLUSTER = (Cluster)ExtensionLoader.getExtensionLoader(Cluster.class).getAdaptiveExtension();
    protected static final RouterFactory ROUTER_FACTORY = (RouterFactory)ExtensionLoader.getExtensionLoader(RouterFactory.class).getAdaptiveExtension();
    protected final String serviceKey;
    protected final Class<T> serviceType;
    protected final URL directoryUrl;
    protected final boolean multiGroup;
    protected Protocol protocol;
    protected Registry registry;
    protected volatile boolean forbidden = false;
    protected boolean shouldRegister;
    protected boolean shouldSimplified;
    protected volatile URL overrideDirectoryUrl;
    protected volatile URL registeredConsumerUrl;
    protected volatile List<Configurator> configurators;
    protected volatile List<Invoker<T>> invokers;
    protected ServiceInstancesChangedListener serviceListener;
    private final boolean shouldFailFast;
    private volatile InvokersChangedListener invokersChangedListener;
    private volatile boolean addressChanged;

    public DynamicDirectory(Class<T> serviceType, URL url) {
        super(url, true);
        if (serviceType == null) {
            throw new IllegalArgumentException("service type is null.");
        }
        if (url.getServiceKey() == null || url.getServiceKey().length() == 0) {
            throw new IllegalArgumentException("registry serviceKey is null.");
        }
        this.shouldRegister = !"*".equals(url.getServiceInterface()) && url.getParameter("register", true);
        this.shouldSimplified = url.getParameter("simplified", false);
        this.serviceType = serviceType;
        this.serviceKey = super.getConsumerUrl().getServiceKey();
        this.overrideDirectoryUrl = this.directoryUrl = this.turnRegistryUrlToConsumerUrl(url);
        String group = this.directoryUrl.getParameter("group", "");
        this.multiGroup = group != null && ("*".equals(group) || group.contains(","));
        this.shouldFailFast = Boolean.parseBoolean(ConfigurationUtils.getProperty((String)"dubbo.router.should-fail-fast", (String)"true"));
    }

    @Override
    public void addServiceListener(ServiceInstancesChangedListener instanceListener) {
        this.serviceListener = instanceListener;
    }

    private URL turnRegistryUrlToConsumerUrl(URL url) {
        return URLBuilder.from((URL)url).setHost(this.queryMap.get("register.ip") == null ? url.getHost() : (String)this.queryMap.get("register.ip")).setPort(0).setProtocol(this.queryMap.get("protocol") == null ? "dubbo" : (String)this.queryMap.get("protocol")).setPath((String)this.queryMap.get("interface")).clearParameters().addParameters(this.queryMap).removeParameter("monitor").addMethodParameters(URL.toMethodParameters((Map)this.queryMap)).build();
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public boolean isShouldRegister() {
        return this.shouldRegister;
    }

    public void subscribe(URL url) {
        this.setConsumerUrl(url);
        this.registry.subscribe(url, this);
    }

    public void unSubscribe(URL url) {
        this.setConsumerUrl(null);
        this.registry.unsubscribe(url, this);
    }

    public List<Invoker<T>> doList(Invocation invocation) {
        if (this.forbidden && this.shouldFailFast) {
            throw new RpcException(4, "No provider available from registry " + this.getUrl().getAddress() + " for service " + this.getConsumerUrl().getServiceKey() + " on consumer " + NetUtils.getLocalHost() + " use dubbo version " + Version.getVersion() + ", please check status of providers(disabled, not registered or in blacklist).");
        }
        if (this.multiGroup) {
            return this.invokers == null ? Collections.emptyList() : this.invokers;
        }
        List invokers = null;
        try {
            invokers = this.routerChain.route(this.getConsumerUrl(), invocation);
        }
        catch (Throwable t) {
            logger.error("Failed to execute router: " + this.getUrl() + ", cause: " + t.getMessage(), t);
        }
        return invokers == null ? Collections.emptyList() : invokers;
    }

    public Class<T> getInterface() {
        return this.serviceType;
    }

    public List<Invoker<T>> getAllInvokers() {
        return this.invokers;
    }

    public URL getConsumerUrl() {
        return this.overrideDirectoryUrl;
    }

    public URL getRegisteredConsumerUrl() {
        return this.registeredConsumerUrl;
    }

    public void setRegisteredConsumerUrl(URL url) {
        this.registeredConsumerUrl = !this.shouldSimplified ? url.addParameters(new String[]{"category", "consumers", "check", String.valueOf(false)}) : URL.valueOf((URL)url, (String[])RegistryProtocol.DEFAULT_REGISTER_CONSUMER_KEYS, null).addParameters(new String[]{"category", "consumers", "check", String.valueOf(false)});
    }

    public void buildRouterChain(URL url) {
        this.setRouterChain(RouterChain.buildChain((URL)url));
    }

    public List<Invoker<T>> getInvokers() {
        return this.invokers;
    }

    public void destroy() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            if (this.getRegisteredConsumerUrl() != null && this.registry != null && this.registry.isAvailable()) {
                this.registry.unregister(this.getRegisteredConsumerUrl());
            }
        }
        catch (Throwable t) {
            logger.warn("unexpected error when unregister service " + this.serviceKey + "from registry" + this.registry.getUrl(), t);
        }
        try {
            if (this.getSubscribeConsumerurl() != null && this.registry != null && this.registry.isAvailable()) {
                this.unSubscribe(this.getSubscribeConsumerurl());
            }
        }
        catch (Throwable t) {
            logger.warn("unexpected error when unsubscribe service " + this.serviceKey + "from registry" + this.registry.getUrl(), t);
        }
        super.destroy();
        try {
            this.destroyAllInvokers();
        }
        catch (Throwable t) {
            logger.warn("Failed to destroy service " + this.serviceKey, t);
        }
        this.invokersChangedListener = null;
    }

    public void discordAddresses() {
        try {
            this.destroyAllInvokers();
        }
        catch (Throwable t) {
            logger.warn("Failed to destroy service " + this.serviceKey, t);
        }
    }

    public void setInvokersChangedListener(InvokersChangedListener listener) {
        this.invokersChangedListener = listener;
        if (this.addressChanged && this.invokersChangedListener != null) {
            this.invokersChangedListener.onChange();
            this.addressChanged = false;
        }
    }

    protected void invokersChanged() {
        if (this.invokersChangedListener != null) {
            this.invokersChangedListener.onChange();
            this.addressChanged = false;
        } else {
            this.addressChanged = true;
        }
    }

    protected abstract void destroyAllInvokers();
}

