/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.registry.event;

import java.util.Map;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.TimeCounter;
import org.apache.dubbo.metrics.model.MetricsKey;
import org.apache.dubbo.metrics.model.TimePair;
import org.apache.dubbo.metrics.registry.collector.RegistryMetricsCollector;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class RegistryEvent
extends MetricsEvent
implements TimeCounter {
    private final TimePair timePair;
    private final RegistryMetricsCollector collector;
    private final boolean available;

    public RegistryEvent(ApplicationModel applicationModel, TimePair timePair) {
        super((Object)applicationModel);
        this.timePair = timePair;
        this.collector = (RegistryMetricsCollector)applicationModel.getBeanFactory().getBean(RegistryMetricsCollector.class);
        this.available = this.collector != null && this.collector.isCollectEnabled();
    }

    public ApplicationModel getSource() {
        return (ApplicationModel)this.source;
    }

    public RegistryMetricsCollector getCollector() {
        return this.collector;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public TimePair getTimePair() {
        return this.timePair;
    }

    public static class MetricsDirectoryEvent
    extends RegistryEvent {
        private final Type type;
        private final int size;

        public MetricsDirectoryEvent(ApplicationModel applicationModel, Type type) {
            this(applicationModel, type, 1);
        }

        public MetricsDirectoryEvent(ApplicationModel applicationModel, Type type, int size) {
            super(applicationModel, TimePair.empty());
            this.type = type;
            this.size = size;
        }

        public Type getType() {
            return this.type;
        }

        public int getSize() {
            return this.size;
        }
    }

    public static class MetricsNotifyEvent
    extends RegistryEvent {
        private final Map<String, Integer> lastNumMap;

        public MetricsNotifyEvent(ApplicationModel applicationModel, TimePair timePair, Map<String, Integer> lastNumMap) {
            super(applicationModel, timePair);
            this.lastNumMap = lastNumMap;
        }

        public Map<String, Integer> getLastNotifyNum() {
            return this.lastNumMap;
        }
    }

    public static class MetricsSubscribeEvent
    extends RegistryEvent {
        public MetricsSubscribeEvent(ApplicationModel applicationModel, TimePair timePair) {
            super(applicationModel, timePair);
        }
    }

    public static class MetricsRegisterEvent
    extends RegistryEvent {
        public MetricsRegisterEvent(ApplicationModel applicationModel, TimePair timePair) {
            super(applicationModel, timePair);
        }
    }

    public static enum Type {
        R_TOTAL(MetricsKey.REGISTER_METRIC_REQUESTS),
        R_SUCCEED(MetricsKey.REGISTER_METRIC_REQUESTS_SUCCEED),
        R_FAILED(MetricsKey.REGISTER_METRIC_REQUESTS_FAILED),
        S_TOTAL(MetricsKey.SUBSCRIBE_METRIC_NUM),
        S_SUCCEED(MetricsKey.SUBSCRIBE_METRIC_NUM_SUCCEED),
        S_FAILED(MetricsKey.SUBSCRIBE_METRIC_NUM_FAILED),
        D_VALID(MetricsKey.DIRECTORY_METRIC_NUM_VALID),
        D_UN_VALID(MetricsKey.DIRECTORY_METRIC_NUM_UN_VALID),
        D_DISABLE(MetricsKey.DIRECTORY_METRIC_NUM_DISABLE),
        D_CURRENT(MetricsKey.DIRECTORY_METRIC_NUM_CURRENT, false),
        D_RECOVER_DISABLE(MetricsKey.DIRECTORY_METRIC_NUM_RECOVER_DISABLE),
        N_TOTAL(MetricsKey.NOTIFY_METRIC_REQUESTS),
        N_LAST_NUM(MetricsKey.NOTIFY_METRIC_NUM_LAST);

        private final MetricsKey metricsKey;
        private final boolean isIncrement;

        private Type(MetricsKey metricsKey) {
            this(metricsKey, true);
        }

        private Type(MetricsKey metricsKey, boolean isIncrement) {
            this.metricsKey = metricsKey;
            this.isIncrement = isIncrement;
        }

        public MetricsKey getMetricsKey() {
            return this.metricsKey;
        }

        public boolean isIncrement() {
            return this.isIncrement;
        }
    }
}

