/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.registry.collector.stat;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.metrics.model.ApplicationMetric;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.MetricsKey;
import org.apache.dubbo.metrics.model.MetricsKeyWrapper;
import org.apache.dubbo.metrics.model.container.AtomicLongContainer;
import org.apache.dubbo.metrics.model.container.LongAccumulatorContainer;
import org.apache.dubbo.metrics.model.container.LongContainer;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.registry.collector.stat.ServiceKeyMetric;
import org.apache.dubbo.metrics.registry.event.RegistryEvent;
import org.apache.dubbo.metrics.report.MetricsExport;

public class RegistryStatComposite
implements MetricsExport {
    public Map<RegistryEvent.Type, Map<String, AtomicLong>> numStats = new ConcurrentHashMap<RegistryEvent.Type, Map<String, AtomicLong>>();
    public Map<RegistryEvent.Type, Map<ServiceKeyMetric, AtomicLong>> skStats = new ConcurrentHashMap<RegistryEvent.Type, Map<ServiceKeyMetric, AtomicLong>>();
    public List<LongContainer<? extends Number>> rtStats = new ArrayList<LongContainer<? extends Number>>();
    public static String OP_TYPE_REGISTER = "register";
    public static String OP_TYPE_SUBSCRIBE = "subscribe";
    public static String OP_TYPE_NOTIFY = "notify";

    public RegistryStatComposite() {
        for (RegistryEvent.Type type : RegistryEvent.Type.values()) {
            this.numStats.put(type, new ConcurrentHashMap());
        }
        this.rtStats.addAll(this.initStats(OP_TYPE_REGISTER));
        this.rtStats.addAll(this.initStats(OP_TYPE_SUBSCRIBE));
        this.rtStats.addAll(this.initStats(OP_TYPE_NOTIFY));
    }

    private List<LongContainer<? extends Number>> initStats(String registryOpType) {
        ArrayList<LongContainer<? extends Number>> singleRtStats = new ArrayList<LongContainer<? extends Number>>();
        singleRtStats.add((LongContainer<? extends Number>)new AtomicLongContainer(new MetricsKeyWrapper(registryOpType, MetricsKey.METRIC_RT_LAST)));
        singleRtStats.add((LongContainer<? extends Number>)new LongAccumulatorContainer(new MetricsKeyWrapper(registryOpType, MetricsKey.METRIC_RT_MIN), new LongAccumulator(Long::min, Long.MAX_VALUE)));
        singleRtStats.add((LongContainer<? extends Number>)new LongAccumulatorContainer(new MetricsKeyWrapper(registryOpType, MetricsKey.METRIC_RT_MAX), new LongAccumulator(Long::max, Long.MIN_VALUE)));
        singleRtStats.add((LongContainer<? extends Number>)new AtomicLongContainer(new MetricsKeyWrapper(registryOpType, MetricsKey.METRIC_RT_SUM), (responseTime, longAccumulator) -> longAccumulator.addAndGet((long)responseTime)));
        AtomicLongContainer avgContainer = new AtomicLongContainer(new MetricsKeyWrapper(registryOpType, MetricsKey.METRIC_RT_AVG), (k, v) -> v.incrementAndGet());
        avgContainer.setValueSupplier(applicationName -> {
            LongContainer totalContainer = this.rtStats.stream().filter(longContainer -> longContainer.isKeyWrapper(MetricsKey.METRIC_RT_SUM, registryOpType)).findFirst().get();
            AtomicLong totalRtTimes = (AtomicLong)avgContainer.get(applicationName);
            AtomicLong totalRtSum = (AtomicLong)totalContainer.get(applicationName);
            return totalRtSum.get() / totalRtTimes.get();
        });
        singleRtStats.add((LongContainer<? extends Number>)avgContainer);
        return singleRtStats;
    }

    public void setApplicationKey(RegistryEvent.Type type, String applicationName, int num) {
        if (!this.numStats.containsKey((Object)type)) {
            return;
        }
        this.numStats.get((Object)type).computeIfAbsent(applicationName, k -> new AtomicLong(0L)).set(num);
    }

    public void setServiceKey(RegistryEvent.Type type, String applicationName, String serviceKey, int num) {
        if (!this.skStats.containsKey((Object)type)) {
            return;
        }
        this.skStats.get((Object)type).computeIfAbsent(new ServiceKeyMetric(applicationName, serviceKey), k -> new AtomicLong(0L)).set(num);
    }

    public void increment(RegistryEvent.Type type, String applicationName) {
        if (!this.numStats.containsKey((Object)type)) {
            return;
        }
        this.numStats.get((Object)type).computeIfAbsent(applicationName, k -> new AtomicLong(0L)).incrementAndGet();
    }

    public void calcRt(String applicationName, String registryOpType, Long responseTime) {
        for (LongContainer container : this.rtStats.stream().filter(longContainer -> longContainer.specifyType(registryOpType)).collect(Collectors.toList())) {
            Number current = (Number)ConcurrentHashMapUtils.computeIfAbsent((ConcurrentMap)container, (Object)applicationName, (Function)container.getInitFunc());
            container.getConsumerFunc().accept(responseTime, current);
        }
    }

    public List<GaugeMetricSample> exportNumMetrics() {
        ArrayList<GaugeMetricSample> list = new ArrayList<GaugeMetricSample>();
        for (RegistryEvent.Type type : this.numStats.keySet()) {
            Map<String, AtomicLong> stringAtomicLongMap = this.numStats.get((Object)type);
            for (String applicationName : stringAtomicLongMap.keySet()) {
                list.add(this.convertToSample(applicationName, type, MetricsCategory.REGISTRY, stringAtomicLongMap.get(applicationName)));
            }
        }
        return list;
    }

    public List<GaugeMetricSample> exportRtMetrics() {
        ArrayList<GaugeMetricSample> list = new ArrayList<GaugeMetricSample>();
        for (LongContainer<? extends Number> rtContainer : this.rtStats) {
            MetricsKeyWrapper metricsKeyWrapper = rtContainer.getMetricsKeyWrapper();
            for (Map.Entry entry : rtContainer.entrySet()) {
                list.add(new GaugeMetricSample(metricsKeyWrapper.targetKey(), metricsKeyWrapper.targetDesc(), ApplicationMetric.getTagsByName((String)((String)entry.getKey())), MetricsCategory.RT, (Object)entry, value -> ((Long)rtContainer.getValueSupplier().apply(value.getKey())).longValue()));
            }
        }
        return list;
    }

    public List<GaugeMetricSample> exportSkMetrics() {
        ArrayList<GaugeMetricSample> list = new ArrayList<GaugeMetricSample>();
        for (RegistryEvent.Type type : this.skStats.keySet()) {
            Map<ServiceKeyMetric, AtomicLong> stringAtomicLongMap = this.skStats.get((Object)type);
            for (ServiceKeyMetric serviceKeyMetric : stringAtomicLongMap.keySet()) {
                list.add(new GaugeMetricSample(type.getMetricsKey(), serviceKeyMetric.getTags(), MetricsCategory.REGISTRY, stringAtomicLongMap, value -> ((AtomicLong)value.get(serviceKeyMetric)).get()));
            }
        }
        return list;
    }

    public GaugeMetricSample convertToSample(String applicationName, RegistryEvent.Type type, MetricsCategory category, AtomicLong targetNumber) {
        return new GaugeMetricSample(type.getMetricsKey(), ApplicationMetric.getTagsByName((String)applicationName), category, (Object)targetNumber, AtomicLong::get);
    }
}

