/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.collector.sample;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.ToDoubleFunction;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.metrics.collector.sample.MetricsCountSampleConfigurer;
import org.apache.dubbo.metrics.collector.sample.SimpleMetricsCountSampler;
import org.apache.dubbo.metrics.model.Metric;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.ThreadPoolRejectMetric;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.model.sample.MetricSample;

public class ThreadRejectMetricsCountSampler
extends SimpleMetricsCountSampler<String, String, ThreadPoolRejectMetric> {
    private final DefaultMetricsCollector collector;
    private final Set<String> metricNames = new ConcurrentHashSet();

    public ThreadRejectMetricsCountSampler(DefaultMetricsCollector collector) {
        this.collector = collector;
        this.collector.addSampler(this);
    }

    public void addMetricName(String name) {
        this.metricNames.add(name);
        this.initMetricsCounter(name, name);
    }

    @Override
    public List<MetricSample> sample() {
        ArrayList<MetricSample> metricSamples = new ArrayList<MetricSample>();
        this.metricNames.stream().forEach(name -> this.collect((List<MetricSample>)metricSamples, (String)name));
        return metricSamples;
    }

    private void collect(List<MetricSample> list, String metricName) {
        this.count(list, metricName, MetricsKey.THREAD_POOL_THREAD_REJECT_COUNT);
    }

    private <T extends Metric> void count(List<MetricSample> list, String metricName, MetricsKey metricsKey) {
        this.getCount(metricName).filter(e -> !e.isEmpty()).ifPresent(map -> map.forEach((k, v) -> list.add((MetricSample)this.getGaugeMetricSample(metricsKey, (ThreadPoolRejectMetric)k, MetricsCategory.THREAD_POOL, (Object)v, AtomicLong::get))));
    }

    private <T> GaugeMetricSample<T> getGaugeMetricSample(MetricsKey metricsKey, ThreadPoolRejectMetric methodMetric, MetricsCategory metricsCategory, T value, ToDoubleFunction<T> apply) {
        return new GaugeMetricSample(metricsKey.getNameByType(methodMetric.getThreadPoolName()), metricsKey.getDescription(), methodMetric.getTags(), metricsCategory, value, apply);
    }

    @Override
    protected void countConfigure(MetricsCountSampleConfigurer<String, String, ThreadPoolRejectMetric> sampleConfigure) {
        sampleConfigure.configureMetrics(configure -> new ThreadPoolRejectMetric(this.collector.getApplicationName(), (String)configure.getSource()));
    }
}

