/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring6.beans.factory.annotation;

import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collection;
import javax.lang.model.element.Modifier;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.config.spring.ReferenceBean;
import org.apache.dubbo.config.spring.beans.factory.annotation.AbstractAnnotationBeanPostProcessor;
import org.apache.dubbo.config.spring.beans.factory.annotation.ReferenceAnnotationBeanPostProcessor;
import org.apache.dubbo.config.spring.context.event.DubboConfigInitEvent;
import org.apache.dubbo.config.spring.util.SpringCompatUtils;
import org.apache.dubbo.config.spring6.beans.factory.aot.ReferencedFieldValueResolver;
import org.apache.dubbo.config.spring6.beans.factory.aot.ReferencedMethodArgumentsResolver;
import org.apache.dubbo.config.spring6.utils.AotUtils;
import org.apache.dubbo.rpc.service.Destroyable;
import org.apache.dubbo.rpc.service.EchoService;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.framework.Advised;
import org.springframework.aot.generate.AccessControl;
import org.springframework.aot.generate.GeneratedClass;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.aot.hint.support.ClassHintUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.aot.AutowiredArgumentsCodeGenerator;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.DecoratingProxy;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.CodeBlock;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public class ReferenceAnnotationWithAotBeanPostProcessor
extends ReferenceAnnotationBeanPostProcessor
implements BeanRegistrationAotProcessor {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(((Object)((Object)this)).getClass());
    @Nullable
    private ConfigurableListableBeanFactory beanFactory;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] beanNames;
        for (String beanName : beanNames = beanFactory.getBeanDefinitionNames()) {
            Class beanType;
            if (beanFactory.isFactoryBean(beanName)) {
                BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
                if (this.isReferenceBean(beanDefinition)) continue;
                if (this.isAnnotatedReferenceBean(beanDefinition)) {
                    this.processReferenceAnnotatedBeanDefinition(beanName, (AnnotatedBeanDefinition)beanDefinition);
                    continue;
                }
                String beanClassName = beanDefinition.getBeanClassName();
                beanType = ClassUtils.resolveClass((String)beanClassName, (ClassLoader)this.getClassLoader());
            } else {
                beanType = beanFactory.getType(beanName);
            }
            if (beanType == null) continue;
            AbstractAnnotationBeanPostProcessor.AnnotatedInjectionMetadata metadata = this.findInjectionMetadata(beanName, beanType, null);
            try {
                this.prepareInjection(metadata);
            }
            catch (BeansException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException("Prepare dubbo reference injection element failed", e);
            }
        }
        try {
            this.applicationContext.publishEvent((ApplicationEvent)new DubboConfigInitEvent(this.applicationContext));
        }
        catch (Exception e) {
            this.logger.warn("5-39", "", "", "publish early application event failed, please upgrade spring version to 4.2.x or later: " + e);
        }
    }

    private boolean isAnnotatedReferenceBean(BeanDefinition beanDefinition) {
        AnnotatedBeanDefinition annotatedBeanDefinition;
        String beanClassName;
        return beanDefinition instanceof AnnotatedBeanDefinition && (beanClassName = SpringCompatUtils.getFactoryMethodReturnType((AnnotatedBeanDefinition)(annotatedBeanDefinition = (AnnotatedBeanDefinition)beanDefinition))) != null && ReferenceBean.class.getName().equals(beanClassName);
    }

    private boolean isReferenceBean(BeanDefinition beanDefinition) {
        return ReferenceBean.class.getName().equals(beanDefinition.getBeanClassName());
    }

    @Nullable
    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        Class beanClass = registeredBean.getBeanClass();
        String beanName = registeredBean.getBeanName();
        RootBeanDefinition beanDefinition = registeredBean.getMergedBeanDefinition();
        AbstractAnnotationBeanPostProcessor.AnnotatedInjectionMetadata metadata = this.findInjectionMetadata(beanDefinition, beanClass, beanName);
        if (!CollectionUtils.isEmpty((Collection)metadata.getFieldElements()) || !CollectionUtils.isEmpty((Collection)metadata.getMethodElements())) {
            return new AotContribution(beanClass, metadata, this.getAutowireCandidateResolver());
        }
        return null;
    }

    private AbstractAnnotationBeanPostProcessor.AnnotatedInjectionMetadata findInjectionMetadata(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
        AbstractAnnotationBeanPostProcessor.AnnotatedInjectionMetadata metadata = this.findInjectionMetadata(beanName, beanType, null);
        metadata.checkConfigMembers(beanDefinition);
        return metadata;
    }

    @Nullable
    private AutowireCandidateResolver getAutowireCandidateResolver() {
        if (this.beanFactory instanceof DefaultListableBeanFactory) {
            return ((DefaultListableBeanFactory)this.beanFactory).getAutowireCandidateResolver();
        }
        return null;
    }

    private static class AotContribution
    implements BeanRegistrationAotContribution {
        private static final String REGISTERED_BEAN_PARAMETER = "registeredBean";
        private static final String INSTANCE_PARAMETER = "instance";
        private final Class<?> target;
        private final AbstractAnnotationBeanPostProcessor.AnnotatedInjectionMetadata annotatedInjectionMetadata;
        @Nullable
        private final AutowireCandidateResolver candidateResolver;

        AotContribution(Class<?> target, AbstractAnnotationBeanPostProcessor.AnnotatedInjectionMetadata annotatedInjectionMetadata, AutowireCandidateResolver candidateResolver) {
            this.target = target;
            this.annotatedInjectionMetadata = annotatedInjectionMetadata;
            this.candidateResolver = candidateResolver;
        }

        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            GeneratedClass generatedClass = generationContext.getGeneratedClasses().addForFeatureComponent("DubboReference", this.target, type -> {
                type.addJavadoc("DubboReference for {@link $T}.", new Object[]{this.target});
                type.addModifiers(new Modifier[]{Modifier.PUBLIC});
            });
            GeneratedMethod generateMethod = generatedClass.getMethods().add("apply", method -> {
                method.addJavadoc("Apply the dubbo reference.", new Object[0]);
                method.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
                method.addParameter(RegisteredBean.class, REGISTERED_BEAN_PARAMETER, new Modifier[0]);
                method.addParameter(this.target, INSTANCE_PARAMETER, new Modifier[0]);
                method.returns(this.target);
                method.addCode(this.generateMethodCode(generatedClass.getName(), generationContext.getRuntimeHints()));
            });
            beanRegistrationCode.addInstancePostProcessor(generateMethod.toMethodReference());
            if (this.candidateResolver != null) {
                this.registerHints(generationContext.getRuntimeHints());
            }
        }

        private CodeBlock generateMethodCode(ClassName targetClassName, RuntimeHints hints) {
            CodeBlock.Builder code = CodeBlock.builder();
            if (!CollectionUtils.isEmpty((Collection)this.annotatedInjectionMetadata.getFieldElements())) {
                for (AbstractAnnotationBeanPostProcessor.AnnotatedInjectElement referenceElement : this.annotatedInjectionMetadata.getFieldElements()) {
                    code.addStatement(this.generateMethodStatementForElement(targetClassName, referenceElement, hints));
                }
            }
            if (!CollectionUtils.isEmpty((Collection)this.annotatedInjectionMetadata.getMethodElements())) {
                for (AbstractAnnotationBeanPostProcessor.AnnotatedInjectElement referenceElement : this.annotatedInjectionMetadata.getMethodElements()) {
                    code.addStatement(this.generateMethodStatementForElement(targetClassName, referenceElement, hints));
                }
            }
            code.addStatement("return $L", new Object[]{INSTANCE_PARAMETER});
            return code.build();
        }

        private CodeBlock generateMethodStatementForElement(ClassName targetClassName, AbstractAnnotationBeanPostProcessor.AnnotatedInjectElement referenceElement, RuntimeHints hints) {
            Member member = referenceElement.getMember();
            AnnotationAttributes attributes = referenceElement.attributes;
            Object injectedObject = referenceElement.injectedObject;
            try {
                Class c = referenceElement.getInjectedType();
                AotUtils.registerSerializationForService(c, hints);
                hints.reflection().registerType(TypeReference.of((Class)c), new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS});
                hints.proxies().registerJdkProxy(new Class[]{c, EchoService.class, Destroyable.class});
                hints.proxies().registerJdkProxy(new Class[]{c, EchoService.class, Destroyable.class, SpringProxy.class, Advised.class, DecoratingProxy.class});
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (member instanceof Field) {
                return this.generateMethodStatementForField(targetClassName, (Field)member, attributes, injectedObject, hints);
            }
            if (member instanceof Method) {
                return this.generateMethodStatementForMethod(targetClassName, (Method)member, attributes, injectedObject, hints);
            }
            throw new IllegalStateException("Unsupported member type " + member.getClass().getName());
        }

        private CodeBlock generateMethodStatementForField(ClassName targetClassName, Field field, AnnotationAttributes attributes, Object injectedObject, RuntimeHints hints) {
            hints.reflection().registerField(field);
            CodeBlock resolver = CodeBlock.of((String)"$T.$L($S)", (Object[])new Object[]{ReferencedFieldValueResolver.class, "forRequiredField", field.getName()});
            CodeBlock shortcutResolver = CodeBlock.of((String)"$L.withShortcut($S)", (Object[])new Object[]{resolver, injectedObject});
            AccessControl accessControl = AccessControl.forMember((Member)field);
            if (!accessControl.isAccessibleFrom(targetClassName)) {
                return CodeBlock.of((String)"$L.resolveAndSet($L, $L)", (Object[])new Object[]{shortcutResolver, REGISTERED_BEAN_PARAMETER, INSTANCE_PARAMETER});
            }
            return CodeBlock.of((String)"$L.$L = $L.resolve($L)", (Object[])new Object[]{INSTANCE_PARAMETER, field.getName(), shortcutResolver, REGISTERED_BEAN_PARAMETER});
        }

        private CodeBlock generateMethodStatementForMethod(ClassName targetClassName, Method method, AnnotationAttributes attributes, Object injectedObject, RuntimeHints hints) {
            AccessControl accessControl;
            CodeBlock.Builder code = CodeBlock.builder();
            code.add("$T.$L", new Object[]{ReferencedMethodArgumentsResolver.class, "forRequiredMethod"});
            code.add("($S", new Object[]{method.getName()});
            if (method.getParameterCount() > 0) {
                code.add(", $L", new Object[]{this.generateParameterTypesCode(method.getParameterTypes())});
            }
            code.add(")", new Object[0]);
            if (method.getParameterCount() > 0) {
                Parameter[] parameters = method.getParameters();
                String[] parameterNames = new String[parameters.length];
                for (int i = 0; i < parameterNames.length; ++i) {
                    parameterNames[i] = parameters[i].getName();
                }
                code.add(".withShortcut($L)", new Object[]{this.generateParameterNamesCode(parameterNames)});
            }
            if (!(accessControl = AccessControl.forMember((Member)method)).isAccessibleFrom(targetClassName)) {
                hints.reflection().registerMethod(method, ExecutableMode.INVOKE);
                code.add(".resolveAndInvoke($L, $L)", new Object[]{REGISTERED_BEAN_PARAMETER, INSTANCE_PARAMETER});
            } else {
                hints.reflection().registerMethod(method, ExecutableMode.INTROSPECT);
                CodeBlock arguments = new AutowiredArgumentsCodeGenerator(this.target, (Executable)method).generateCode((Class[])method.getParameterTypes());
                CodeBlock injectionCode = CodeBlock.of((String)"args -> $L.$L($L)", (Object[])new Object[]{INSTANCE_PARAMETER, method.getName(), arguments});
                code.add(".resolve($L, $L)", new Object[]{REGISTERED_BEAN_PARAMETER, injectionCode});
            }
            return code.build();
        }

        private CodeBlock generateParameterNamesCode(String[] parameterNames) {
            CodeBlock.Builder code = CodeBlock.builder();
            for (int i = 0; i < parameterNames.length; ++i) {
                code.add(i != 0 ? ", " : "", new Object[0]);
                code.add("$S", new Object[]{parameterNames[i]});
            }
            return code.build();
        }

        private CodeBlock generateParameterTypesCode(Class<?>[] parameterTypes) {
            CodeBlock.Builder code = CodeBlock.builder();
            for (int i = 0; i < parameterTypes.length; ++i) {
                code.add(i != 0 ? ", " : "", new Object[0]);
                code.add("$T.class", new Object[]{parameterTypes[i]});
            }
            return code.build();
        }

        private void registerHints(RuntimeHints runtimeHints) {
            Member member;
            if (!CollectionUtils.isEmpty((Collection)this.annotatedInjectionMetadata.getFieldElements())) {
                for (AbstractAnnotationBeanPostProcessor.AnnotatedInjectElement referenceElement : this.annotatedInjectionMetadata.getFieldElements()) {
                    member = referenceElement.getMember();
                    if (!(member instanceof Field)) continue;
                    Field field = (Field)member;
                    DependencyDescriptor dependencyDescriptor = new DependencyDescriptor(field, true);
                    this.registerProxyIfNecessary(runtimeHints, dependencyDescriptor);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)this.annotatedInjectionMetadata.getMethodElements())) {
                for (AbstractAnnotationBeanPostProcessor.AnnotatedInjectElement referenceElement : this.annotatedInjectionMetadata.getMethodElements()) {
                    member = referenceElement.getMember();
                    if (!(member instanceof Method)) continue;
                    Method method = (Method)member;
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        MethodParameter methodParam = new MethodParameter(method, i);
                        DependencyDescriptor dependencyDescriptor = new DependencyDescriptor(methodParam, true);
                        this.registerProxyIfNecessary(runtimeHints, dependencyDescriptor);
                    }
                }
            }
        }

        private void registerProxyIfNecessary(RuntimeHints runtimeHints, DependencyDescriptor dependencyDescriptor) {
            Class proxyClass;
            if (this.candidateResolver != null && (proxyClass = this.candidateResolver.getLazyResolutionProxyClass(dependencyDescriptor, null)) != null) {
                ClassHintUtils.registerProxyIfNecessary((Class)proxyClass, (RuntimeHints)runtimeHints);
            }
        }
    }
}

