/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.extension;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.dubbo.common.extension.ExtensionDirector;
import org.apache.dubbo.common.extension.ExtensionLoader;

public interface ExtensionAccessor {
    public ExtensionDirector getExtensionDirector();

    default public <T> ExtensionLoader<T> getExtensionLoader(Class<T> type) {
        return this.getExtensionDirector().getExtensionLoader(type);
    }

    default public <T> T getExtension(Class<T> type, String name) {
        ExtensionLoader<T> extensionLoader = this.getExtensionLoader(type);
        return extensionLoader != null ? (T)extensionLoader.getExtension(name) : null;
    }

    default public <T> T getAdaptiveExtension(Class<T> type) {
        ExtensionLoader<T> extensionLoader = this.getExtensionLoader(type);
        return extensionLoader != null ? (T)extensionLoader.getAdaptiveExtension() : null;
    }

    default public <T> T getDefaultExtension(Class<T> type) {
        ExtensionLoader<T> extensionLoader = this.getExtensionLoader(type);
        return extensionLoader != null ? (T)extensionLoader.getDefaultExtension() : null;
    }

    default public <T> List<T> getActivateExtensions(Class<T> type) {
        ExtensionLoader<T> extensionLoader = this.getExtensionLoader(type);
        return extensionLoader != null ? extensionLoader.getActivateExtensions() : Collections.emptyList();
    }

    default public <T> T getFirstActivateExtension(Class<T> type) {
        ExtensionLoader<T> extensionLoader = this.getExtensionLoader(type);
        if (extensionLoader == null) {
            throw new IllegalArgumentException("ExtensionLoader for [" + type + "] is not found");
        }
        List<T> extensions = extensionLoader.getActivateExtensions();
        if (extensions.isEmpty()) {
            throw new IllegalArgumentException("No activate extensions for [" + type + "] found");
        }
        return extensions.get(0);
    }

    default public Set<String> getSupportedExtensions(Class<?> type) {
        ExtensionLoader<?> extensionLoader = this.getExtensionLoader(type);
        return extensionLoader != null ? extensionLoader.getSupportedExtensions() : Collections.emptySet();
    }
}

