/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ExtendedRequestDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.extended.PwdModifyRequest;
import org.apache.directory.api.ldap.extras.extended.PwdModifyRequestImpl;
import org.apache.directory.api.ldap.extras.extended.PwdModifyResponse;
import org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify.PasswordModifyRequest;
import org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify.PasswordModifyRequestDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordModifyRequestDecorator
extends ExtendedRequestDecorator<PwdModifyRequest, PwdModifyResponse>
implements PwdModifyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordModifyRequestDecorator.class);
    private PasswordModifyRequest passwordModifyRequest;

    public PasswordModifyRequestDecorator(LdapApiService codec, PwdModifyRequest decoratedMessage) {
        super(codec, decoratedMessage);
        this.passwordModifyRequest = new PasswordModifyRequest(decoratedMessage);
    }

    public PasswordModifyRequest getPasswordModifyRequest() {
        return this.passwordModifyRequest;
    }

    @Override
    public void setRequestValue(byte[] requestValue) {
        PasswordModifyRequestDecoder decoder = new PasswordModifyRequestDecoder();
        try {
            this.passwordModifyRequest = (PasswordModifyRequest)decoder.decode(requestValue);
            ((PwdModifyRequestImpl)this.getDecorated()).setUserIdentity(this.passwordModifyRequest.getPwdModifyRequest().getUserIdentity());
            ((PwdModifyRequestImpl)this.getDecorated()).setOldPassword(this.passwordModifyRequest.getPwdModifyRequest().getOldPassword());
            ((PwdModifyRequestImpl)this.getDecorated()).setNewPassword(this.passwordModifyRequest.getPwdModifyRequest().getNewPassword());
            if (requestValue != null) {
                this.requestValue = new byte[requestValue.length];
                System.arraycopy(requestValue, 0, this.requestValue, 0, requestValue.length);
            } else {
                this.requestValue = null;
            }
        }
        catch (DecoderException e) {
            LOG.error(I18n.err(I18n.ERR_04165, new Object[0]), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] getRequestValue() {
        if (this.requestValue == null) {
            try {
                this.requestValue = this.passwordModifyRequest.encode().array();
            }
            catch (EncoderException e) {
                LOG.error(I18n.err(I18n.ERR_04167, new Object[0]), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        if (this.requestValue == null) {
            return null;
        }
        byte[] copy = new byte[this.requestValue.length];
        System.arraycopy(this.requestValue, 0, copy, 0, this.requestValue.length);
        return copy;
    }

    @Override
    public PwdModifyResponse getResultResponse() {
        return (PwdModifyResponse)((PwdModifyRequest)this.getDecorated()).getResultResponse();
    }

    @Override
    public byte[] getUserIdentity() {
        return ((PwdModifyRequestImpl)this.getDecorated()).getUserIdentity();
    }

    public void setUserIdentity(byte[] userIdentity) {
        ((PwdModifyRequestImpl)this.getDecorated()).setUserIdentity(userIdentity);
    }

    @Override
    public byte[] getOldPassword() {
        return ((PwdModifyRequestImpl)this.getDecorated()).getOldPassword();
    }

    public void setOldPassword(byte[] oldPassword) {
        ((PwdModifyRequestImpl)this.getDecorated()).setOldPassword(oldPassword);
    }

    @Override
    public byte[] getNewPassword() {
        return ((PwdModifyRequestImpl)this.getDecorated()).getNewPassword();
    }

    public void setNewPassword(byte[] newPassword) {
        ((PwdModifyRequestImpl)this.getDecorated()).setNewPassword(newPassword);
    }
}

