/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test.catalog;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.ColumnStrategy;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql2rel.InitializerContext;
import org.apache.calcite.sql2rel.NullInitializerExpressionFactory;

public class CountingFactory
extends NullInitializerExpressionFactory {
    public static final ThreadLocal<AtomicInteger> THREAD_CALL_COUNT = ThreadLocal.withInitial(AtomicInteger::new);
    private final List<String> defaultColumns;

    CountingFactory(List<String> defaultColumns) {
        this.defaultColumns = ImmutableList.copyOf(defaultColumns);
    }

    public ColumnStrategy generationStrategy(RelOptTable table, int iColumn) {
        RelDataTypeField field = (RelDataTypeField)table.getRowType().getFieldList().get(iColumn);
        if (this.defaultColumns.contains(field.getName())) {
            return ColumnStrategy.DEFAULT;
        }
        return super.generationStrategy(table, iColumn);
    }

    public RexNode newColumnDefaultValue(RelOptTable table, int iColumn, InitializerContext context) {
        THREAD_CALL_COUNT.get().incrementAndGet();
        RelDataTypeField field = (RelDataTypeField)table.getRowType().getFieldList().get(iColumn);
        if (this.defaultColumns.contains(field.getName())) {
            RexBuilder rexBuilder = context.getRexBuilder();
            return rexBuilder.makeExactLiteral(BigDecimal.ONE);
        }
        return super.newColumnDefaultValue(table, iColumn, context);
    }

    public RexNode newAttributeInitializer(RelDataType type, SqlFunction constructor, int iAttribute, List<RexNode> constructorArgs, InitializerContext context) {
        THREAD_CALL_COUNT.get().incrementAndGet();
        return super.newAttributeInitializer(type, constructor, iAttribute, constructorArgs, context);
    }
}

