/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Collection;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.hydromatic.quidem.CommandHandler;
import net.hydromatic.quidem.Quidem;
import org.apache.calcite.adapter.java.ReflectiveSchema;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.ConnectionProperty;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.ConnectionSpec;
import org.apache.calcite.test.DiffTestCase;
import org.apache.calcite.test.schemata.catchall.CatchallSchema;
import org.apache.calcite.util.Closer;
import org.apache.calcite.util.Sources;
import org.apache.calcite.util.Util;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public abstract class QuidemTest {
    private static final Pattern PATTERN = Pattern.compile("\\.iq$");

    private static Object getEnv(String varName) {
        switch (varName) {
            case "jdk18": {
                return System.getProperty("java.version").startsWith("1.8");
            }
            case "fixed": {
                return v -> {
                    switch (v) {
                        case "calcite1045": {
                            return false;
                        }
                        case "calcite1048": {
                            return false;
                        }
                    }
                    return null;
                };
            }
            case "not": {
                return v -> {
                    Object o = QuidemTest.getEnv(v);
                    if (o instanceof Function) {
                        Function f = (Function)o;
                        return v2 -> (Boolean)f.apply(v2) == false;
                    }
                    return null;
                };
            }
        }
        return null;
    }

    private Method findMethod(String path) {
        Method m;
        String path1 = path.replace(File.separatorChar, '_');
        String path2 = PATTERN.matcher(path1).replaceAll("");
        String methodName = AvaticaUtils.toCamelCase((String)("test_" + path2));
        try {
            m = this.getClass().getMethod(methodName, String.class);
        }
        catch (NoSuchMethodException e) {
            m = null;
        }
        return m;
    }

    /*
     * Exception decompiling
     */
    protected static Collection<Object[]> data(String first) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void checkRun(String path) throws Exception {
        File outFile;
        File inFile;
        File f = new File(path);
        if (f.isAbsolute()) {
            inFile = f;
            outFile = new File(path + ".out");
        } else {
            URL inUrl = QuidemTest.class.getResource("/" + QuidemTest.n2u(path));
            inFile = Sources.of((URL)inUrl).file();
            outFile = new File(inFile.getAbsoluteFile().getParent(), QuidemTest.u2n("surefire/") + path);
        }
        Util.discard((boolean)outFile.getParentFile().mkdirs());
        try (BufferedReader reader = Util.reader((File)inFile);
             PrintWriter writer = Util.printWriter((File)outFile);
             Closer closer = new Closer();){
            Quidem.Config config = Quidem.configBuilder().withReader((Reader)reader).withWriter((Writer)writer).withConnectionFactory(this.createConnectionFactory()).withCommandHandler(this.createCommandHandler()).withPropertyHandler((propertyName, value) -> {
                boolean b;
                if (propertyName.equals("bindable")) {
                    b = value instanceof Boolean && (Boolean)value != false;
                    closer.add((AutoCloseable)Hook.ENABLE_BINDABLE.addThread(Hook.propertyJ((Object)b)));
                }
                if (propertyName.equals("expand")) {
                    b = value instanceof Boolean && (Boolean)value != false;
                    closer.add((AutoCloseable)Prepare.THREAD_EXPAND.push((Object)b));
                }
                if (propertyName.equals("insubquerythreshold")) {
                    int thresholdValue = ((BigDecimal)value).intValue();
                    closer.add((AutoCloseable)Prepare.THREAD_INSUBQUERY_THRESHOLD.push((Object)thresholdValue));
                }
            }).withEnv(QuidemTest::getEnv).build();
            new Quidem(config).execute();
        }
        String diff = DiffTestCase.diff(inFile, outFile);
        if (!diff.isEmpty()) {
            Assertions.fail((String)("Files differ: " + outFile + " " + inFile + "\n" + diff));
        }
    }

    protected CommandHandler createCommandHandler() {
        return Quidem.EMPTY_COMMAND_HANDLER;
    }

    protected Quidem.ConnectionFactory createConnectionFactory() {
        return new QuidemConnectionFactory();
    }

    private static String u2n(String s) {
        return File.separatorChar == '\\' ? s.replace('/', '\\') : s;
    }

    private static String n2u(String s) {
        return File.separatorChar == '\\' ? s.replace('\\', '/') : s;
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void test(String path) throws Exception {
        Method method = this.findMethod(path);
        if (method != null) {
            try {
                method.invoke((Object)this, path);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw e;
            }
        } else {
            this.checkRun(path);
        }
    }

    protected static class QuidemConnectionFactory
    implements Quidem.ConnectionFactory {
        protected QuidemConnectionFactory() {
        }

        public Connection connect(String name) throws Exception {
            return this.connect(name, false);
        }

        public Connection connect(String name, boolean reference) throws Exception {
            if (reference) {
                if (name.equals("foodmart")) {
                    ConnectionSpec db = CalciteAssert.DatabaseInstance.HSQLDB.foodmart;
                    Connection connection = DriverManager.getConnection(db.url, db.username, db.password);
                    connection.setSchema("foodmart");
                    return connection;
                }
                return null;
            }
            switch (name) {
                case "hr": {
                    return CalciteAssert.hr().connect();
                }
                case "foodmart": {
                    return CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).connect();
                }
                case "geo": {
                    return CalciteAssert.that().with(CalciteAssert.Config.GEO).connect();
                }
                case "scott": {
                    return CalciteAssert.that().with(CalciteAssert.Config.SCOTT).connect();
                }
                case "jdbc_scott": {
                    return CalciteAssert.that().with(CalciteAssert.Config.JDBC_SCOTT).connect();
                }
                case "post": {
                    return CalciteAssert.that().with(CalciteAssert.Config.REGULAR).with(CalciteAssert.SchemaSpec.POST).connect();
                }
                case "post-big-query": {
                    return CalciteAssert.that().with((ConnectionProperty)CalciteConnectionProperty.FUN, (Object)"standard,bigquery").with(CalciteAssert.Config.REGULAR).with(CalciteAssert.SchemaSpec.POST).connect();
                }
                case "mysqlfunc": {
                    return CalciteAssert.that().with((ConnectionProperty)CalciteConnectionProperty.FUN, (Object)"mysql").with(CalciteAssert.Config.REGULAR).with(CalciteAssert.SchemaSpec.POST).connect();
                }
                case "oraclefunc": {
                    return CalciteAssert.that().with((ConnectionProperty)CalciteConnectionProperty.FUN, (Object)"oracle").with(CalciteAssert.Config.REGULAR).connect();
                }
                case "catchall": {
                    return CalciteAssert.that().withSchema("s", (Schema)new ReflectiveSchema((Object)new CatchallSchema())).connect();
                }
                case "orinoco": {
                    return CalciteAssert.that().with(CalciteAssert.SchemaSpec.ORINOCO).connect();
                }
                case "seq": {
                    Connection connection = CalciteAssert.that().withSchema("s", (Schema)new AbstractSchema()).connect();
                    connection.unwrap(CalciteConnection.class).getRootSchema().getSubSchema("s").add("my_seq", (Table)new AbstractTable(){

                        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                            return typeFactory.builder().add("$seq", SqlTypeName.BIGINT).build();
                        }

                        public Schema.TableType getJdbcTableType() {
                            return Schema.TableType.SEQUENCE;
                        }
                    });
                    return connection;
                }
                case "bookstore": {
                    return CalciteAssert.that().with(CalciteAssert.SchemaSpec.BOOKSTORE).connect();
                }
            }
            throw new RuntimeException("unknown connection '" + name + "'");
        }
    }
}

