/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableList;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlTableFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import org.apache.calcite.sql.util.ListSqlOperatorTable;
import org.apache.calcite.util.Optionality;

public class MockSqlOperatorTable
extends ChainedSqlOperatorTable {
    private final ListSqlOperatorTable listOpTab;

    public MockSqlOperatorTable(SqlOperatorTable parentTable) {
        super(ImmutableList.of((Object)parentTable, (Object)new ListSqlOperatorTable()));
        this.listOpTab = (ListSqlOperatorTable)this.tableList.get(1);
    }

    public void addOperator(SqlOperator op) {
        this.listOpTab.add(op);
    }

    public static void addRamp(MockSqlOperatorTable opTab) {
        opTab.addOperator((SqlOperator)new RampFunction());
        opTab.addOperator((SqlOperator)new DedupFunction());
        opTab.addOperator((SqlOperator)new MyFunction());
        opTab.addOperator((SqlOperator)new MyAvgAggFunction());
        opTab.addOperator((SqlOperator)new RowFunction());
        opTab.addOperator((SqlOperator)new NotATableFunction());
        opTab.addOperator((SqlOperator)new BadTableFunction());
        opTab.addOperator((SqlOperator)new StructuredFunction());
        opTab.addOperator((SqlOperator)new CompositeFunction());
    }

    public static class CompositeFunction
    extends SqlFunction {
        public CompositeFunction() {
            super("COMPOSITE", new SqlIdentifier("COMPOSITE", SqlParserPos.ZERO), SqlKind.OTHER_FUNCTION, null, null, OperandTypes.or((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.variadic((SqlOperandCountRange)SqlOperandCountRanges.from((int)1)), OperandTypes.variadic((SqlOperandCountRange)SqlOperandCountRanges.from((int)2))}), SqlFunctionCategory.USER_DEFINED_FUNCTION);
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.BIGINT);
        }
    }

    public static class StructuredFunction
    extends SqlFunction {
        StructuredFunction() {
            super("STRUCTURED_FUNC", new SqlIdentifier("STRUCTURED_FUNC", SqlParserPos.ZERO), SqlKind.OTHER_FUNCTION, null, null, (SqlOperandTypeChecker)OperandTypes.NILADIC, SqlFunctionCategory.USER_DEFINED_FUNCTION);
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            RelDataType bigintType = typeFactory.createSqlType(SqlTypeName.BIGINT);
            RelDataType varcharType = typeFactory.createSqlType(SqlTypeName.VARCHAR, 20);
            return typeFactory.builder().add("F0", bigintType).add("F1", varcharType).build();
        }
    }

    public static class RowFunction
    extends SqlFunction
    implements SqlTableFunction {
        RowFunction() {
            super("ROW_FUNC", SqlKind.OTHER_FUNCTION, ReturnTypes.CURSOR, null, (SqlOperandTypeChecker)OperandTypes.NILADIC, SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION);
        }

        private static RelDataType inferRowType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            RelDataType bigintType = typeFactory.createSqlType(SqlTypeName.BIGINT);
            return typeFactory.builder().add("NOT_NULL_FIELD", bigintType).add("NULLABLE_FIELD", bigintType).nullable(true).build();
        }

        public SqlReturnTypeInference getRowTypeInference() {
            return RowFunction::inferRowType;
        }
    }

    public static class MyAvgAggFunction
    extends SqlAggFunction {
        public MyAvgAggFunction() {
            super("MYAGG", null, SqlKind.AVG, ReturnTypes.AVG_AGG_FUNCTION, null, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC}), SqlFunctionCategory.NUMERIC, false, false, Optionality.FORBIDDEN);
        }

        public boolean isDeterministic() {
            return false;
        }
    }

    public static class MapFunction
    extends SqlFunction {
        public MapFunction() {
            super("MAP", new SqlIdentifier("MAP", SqlParserPos.ZERO), SqlKind.OTHER_FUNCTION, null, null, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.STRING}), SqlFunctionCategory.USER_DEFINED_FUNCTION);
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createMapType(typeFactory.createSqlType(SqlTypeName.VARCHAR), typeFactory.createSqlType(SqlTypeName.VARCHAR));
        }
    }

    public static class SplitFunction
    extends SqlFunction {
        public SplitFunction() {
            super("SPLIT", new SqlIdentifier("SPLIT", SqlParserPos.ZERO), SqlKind.OTHER_FUNCTION, null, null, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.STRING}), SqlFunctionCategory.USER_DEFINED_FUNCTION);
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createArrayType(typeFactory.createSqlType(SqlTypeName.VARCHAR), -1L);
        }
    }

    public static class MyAggFunc
    extends SqlAggFunction {
        public MyAggFunc() {
            super("myAggFunc", null, SqlKind.OTHER_FUNCTION, ReturnTypes.BIGINT, null, OperandTypes.ONE_OR_MORE, SqlFunctionCategory.USER_DEFINED_FUNCTION, false, false, Optionality.FORBIDDEN);
        }
    }

    public static class MyFunction
    extends SqlFunction {
        public MyFunction() {
            super("MYFUN", new SqlIdentifier("MYFUN", SqlParserPos.ZERO), SqlKind.OTHER_FUNCTION, null, null, (SqlOperandTypeChecker)OperandTypes.NUMERIC, SqlFunctionCategory.USER_DEFINED_FUNCTION);
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.BIGINT);
        }
    }

    public static class DedupFunction
    extends SqlFunction
    implements SqlTableFunction {
        public DedupFunction() {
            super("DEDUP", SqlKind.OTHER_FUNCTION, ReturnTypes.CURSOR, null, OperandTypes.VARIADIC, SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION);
        }

        public SqlReturnTypeInference getRowTypeInference() {
            return opBinding -> opBinding.getTypeFactory().builder().add("NAME", SqlTypeName.VARCHAR, 1024).build();
        }
    }

    public static class BadTableFunction
    extends SqlFunction
    implements SqlTableFunction {
        public BadTableFunction() {
            super("BAD_TABLE_FUNCTION", SqlKind.OTHER_FUNCTION, null, null, (SqlOperandTypeChecker)OperandTypes.NUMERIC, SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION);
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return opBinding.getTypeFactory().builder().add("I", SqlTypeName.INTEGER).build();
        }

        public SqlReturnTypeInference getRowTypeInference() {
            return this::inferReturnType;
        }
    }

    public static class NotATableFunction
    extends SqlFunction {
        public NotATableFunction() {
            super("BAD_RAMP", SqlKind.OTHER_FUNCTION, ReturnTypes.CURSOR, null, (SqlOperandTypeChecker)OperandTypes.NUMERIC, SqlFunctionCategory.USER_DEFINED_FUNCTION);
        }
    }

    public static class DynamicTypeFunction
    extends SqlFunction
    implements SqlTableFunction {
        public DynamicTypeFunction() {
            super("RAMP", SqlKind.OTHER_FUNCTION, ReturnTypes.CURSOR, null, (SqlOperandTypeChecker)OperandTypes.NUMERIC, SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION);
        }

        public SqlReturnTypeInference getRowTypeInference() {
            return opBinding -> opBinding.getTypeFactory().builder().add("I", SqlTypeName.INTEGER).build();
        }
    }

    public static class RampFunction
    extends SqlFunction
    implements SqlTableFunction {
        public RampFunction() {
            super("RAMP", SqlKind.OTHER_FUNCTION, ReturnTypes.CURSOR, null, (SqlOperandTypeChecker)OperandTypes.NUMERIC, SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION);
        }

        public SqlReturnTypeInference getRowTypeInference() {
            return opBinding -> opBinding.getTypeFactory().builder().add("I", SqlTypeName.INTEGER).build();
        }
    }
}

