/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bigtop.itest.junit;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Parameterized;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class OrderedParameterized
extends Suite {
    private final ArrayList<Runner> runners = new ArrayList();

    private FrameworkMethod getParametersMethod(TestClass testClass) throws Exception {
        List methods = testClass.getAnnotatedMethods(Parameterized.Parameters.class);
        for (FrameworkMethod each : methods) {
            int modifiers = each.getMethod().getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            return each;
        }
        throw new Exception("No public static parameters method on class " + testClass.getName());
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    private Map<String, Object[]> getParametersList(TestClass klass) throws Throwable {
        return (Map)this.getParametersMethod(klass).invokeExplosively(null, new Object[0]);
    }

    public OrderedParameterized(Class<?> klass) throws Throwable {
        super(klass, Collections.emptyList());
        Map<String, Object[]> parametersMap = this.getParametersList(this.getTestClass());
        for (Map.Entry<String, Object[]> entry : parametersMap.entrySet()) {
            this.runners.add((Runner)new TestClassRunnerForParameters(this.getTestClass().getJavaClass(), parametersMap, entry.getKey()));
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface RunStage {
        public int level() default 0;
    }

    private class TestClassRunnerForParameters
    extends BlockJUnit4ClassRunner {
        private final String fParameterSetNumber;
        private final Map<String, Object[]> fParameterList;

        TestClassRunnerForParameters(Class<?> type, Map<String, Object[]> parameterList, String i) throws InitializationError {
            super(type);
            this.fParameterList = parameterList;
            this.fParameterSetNumber = i;
        }

        public Object createTest() throws Exception {
            return this.getTestClass().getOnlyConstructor().newInstance(this.computeParams());
        }

        private Object[] computeParams() throws Exception {
            try {
                return this.fParameterList.get(this.fParameterSetNumber);
            }
            catch (ClassCastException classCastException) {
                throw new Exception(String.format("%s.%s() must return a Map from Strings to arrays.", this.getTestClass().getName(), OrderedParameterized.this.getParametersMethod(this.getTestClass()).getName()));
            }
        }

        protected List<FrameworkMethod> getChildren() {
            List c = super.getChildren();
            Collections.sort(c, new Comparator<FrameworkMethod>(){

                @Override
                public int compare(FrameworkMethod m1, FrameworkMethod m2) {
                    RunStage r1 = (RunStage)m1.getAnnotation(RunStage.class);
                    RunStage r2 = (RunStage)m2.getAnnotation(RunStage.class);
                    return (r1 != null ? r1.level() : 0) - (r2 != null ? r2.level() : 0);
                }
            });
            return c;
        }

        protected String getName() {
            return String.format("[%s]", this.fParameterSetNumber);
        }

        protected String testName(FrameworkMethod method) {
            return String.format("%s[%s]", method.getName(), this.fParameterSetNumber);
        }

        protected void validateConstructor(List<Throwable> errors) {
            this.validateOnlyOneConstructor(errors);
        }

        protected Statement classBlock(RunNotifier notifier) {
            return this.childrenInvoker(notifier);
        }
    }
}

