/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bigtop.itest;

import java.lang.reflect.Field;
import org.apache.bigtop.itest.Contract;
import org.apache.bigtop.itest.Property;
import org.apache.bigtop.itest.Variable;
import org.junit.Assert;

public class ParameterSetter {
    public static void setEnv(Class target) throws NoSuchFieldException, IllegalAccessException {
        Contract contract = target.getAnnotation(Contract.class);
        Variable[] vars = contract.env();
        int i = 0;
        while (i < vars.length) {
            Variable var = vars[i];
            String name = var.name();
            Field field = target.getDeclaredField(name);
            String value = System.getenv(name);
            if (value == null && var.required()) {
                Assert.assertNotNull((String)(String.valueOf(name) + " is not set"), (Object)value);
            }
            field.setAccessible(true);
            field.set(target, value);
            ++i;
        }
    }

    public static void setEnv(Class target, String[] fieldNames) throws NoSuchFieldException, IllegalAccessException {
        Contract contract = target.getAnnotation(Contract.class);
        Variable[] vars = contract.env();
        assert (vars.length == fieldNames.length);
        int i = 0;
        while (i < vars.length) {
            Variable var = vars[i];
            String name = var.name();
            Field field = target.getDeclaredField(fieldNames[i]);
            String value = System.getenv(name);
            if (value == null && var.required()) {
                Assert.assertNotNull((String)(String.valueOf(name) + " is not set"), (Object)value);
            }
            field.setAccessible(true);
            field.set(target, value);
            ++i;
        }
    }

    public static void setProperties(Class target) throws NoSuchFieldException, IllegalAccessException {
        Contract contract = target.getAnnotation(Contract.class);
        Property[] props = contract.properties();
        int i = 0;
        while (i < props.length) {
            Property prop = props[i];
            String name = prop.name();
            Field field = target.getDeclaredField(name.replace('.', '_'));
            Object value = null;
            switch (prop.type()) {
                case STRING: {
                    value = System.getProperty(name, prop.defaultValue());
                    break;
                }
                case INT: {
                    value = Integer.getInteger(name, prop.intValue());
                    break;
                }
                case LONG: {
                    value = Long.getLong(name, prop.longValue());
                    break;
                }
                case BOOLEAN: {
                    value = Boolean.getBoolean(name);
                }
            }
            field.setAccessible(true);
            field.set(target, value);
            ++i;
        }
    }

    public static void setProperties(Class target, String[] fieldNames) throws NoSuchFieldException, IllegalAccessException {
        Contract contract = target.getAnnotation(Contract.class);
        Property[] props = contract.properties();
        assert (props.length == fieldNames.length);
        int i = 0;
        while (i < props.length) {
            Property prop = props[i];
            String name = prop.name();
            Field field = target.getDeclaredField(fieldNames[i]);
            Object value = null;
            switch (prop.type()) {
                case STRING: {
                    value = System.getProperty(name, prop.defaultValue());
                    break;
                }
                case INT: {
                    value = Integer.getInteger(name, prop.intValue());
                    break;
                }
                case LONG: {
                    value = Long.getLong(name, prop.longValue());
                    break;
                }
                case BOOLEAN: {
                    value = Boolean.getBoolean(name);
                }
            }
            field.setAccessible(true);
            field.set(target, value);
            ++i;
        }
    }
}

