/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.server.standalone.cli;

import java.io.File;
import java.io.PrintWriter;
import org.apache.axis.server.standalone.StandaloneAxisServer;
import org.apache.axis.server.standalone.cli.ConfiguratorException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class Configurator {
    public static final Configurator INSTANCE = new Configurator();
    private final Options options = new Options();

    private Configurator() {
        Option option = new Option("p", true, "the HTTP port");
        option.setArgName("port");
        option.setRequired(true);
        this.options.addOption(option);
        option = new Option("w", true, "the work directory");
        option.setArgName("dir");
        option.setRequired(true);
        this.options.addOption(option);
        option = new Option("j", true, "a list of directories to look up JWS files from");
        option.setArgName("dirs");
        this.options.addOption(option);
        option = new Option("m", true, "the maximum number of concurrently active sessions");
        option.setArgName("count");
        this.options.addOption(option);
    }

    public void printHelp(PrintWriter pw, String app) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printUsage(pw, 100, app, this.options);
        formatter.printOptions(pw, 100, this.options, 1, 2);
        pw.flush();
    }

    public void configure(StandaloneAxisServer server, String[] args) throws ConfiguratorException {
        CommandLine cmdLine;
        GnuParser parser = new GnuParser();
        try {
            cmdLine = parser.parse(this.options, args);
        }
        catch (ParseException ex) {
            throw new ConfiguratorException(ex.getMessage());
        }
        server.setPort(Integer.parseInt(cmdLine.getOptionValue("p")));
        server.setWorkDir(new File(cmdLine.getOptionValue("w")));
        if (cmdLine.hasOption("m")) {
            server.setMaxSessions(Integer.parseInt(cmdLine.getOptionValue("m")));
        }
        if (cmdLine.hasOption("j")) {
            String[] jwsDirStrings = cmdLine.getOptionValue("j").split(File.pathSeparator);
            File[] jwsDirs = new File[jwsDirStrings.length];
            for (int i = 0; i < jwsDirStrings.length; ++i) {
                jwsDirs[i] = new File(jwsDirStrings[i]);
            }
            server.setJwsDirs(jwsDirs);
        }
    }
}

