/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.server.standalone;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.Servlet;
import org.apache.axis.server.standalone.LimitSessionManager;
import org.apache.axis.server.standalone.QuitHandler;
import org.apache.axis.server.standalone.QuitListener;
import org.apache.axis.server.standalone.ServerException;
import org.apache.axis.server.standalone.StandaloneAxisServlet;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.SessionManager;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.HashSessionManager;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletMapping;
import org.mortbay.jetty.servlet.SessionHandler;
import org.mortbay.resource.Resource;
import org.mortbay.resource.ResourceCollection;

public final class StandaloneAxisServer {
    private int port;
    private File workDir;
    private int maxSessions = -1;
    private File[] jwsDirs;
    private Server server;
    private QuitListener quitListener;

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public int getMaxSessions() {
        return this.maxSessions;
    }

    public void setMaxSessions(int maxSessions) {
        this.maxSessions = maxSessions;
    }

    public File[] getJwsDirs() {
        return this.jwsDirs == null ? null : (File[])this.jwsDirs.clone();
    }

    public void setJwsDirs(File[] jwsDirs) {
        this.jwsDirs = jwsDirs == null ? null : (File[])jwsDirs.clone();
    }

    public void init() throws ServerException {
        StandaloneAxisServlet servlet = new StandaloneAxisServlet();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        new File(this.workDir, "WEB-INF").mkdir();
        try {
            resources.add(Resource.newResource((String)this.workDir.getAbsolutePath()));
        }
        catch (IOException ex) {
            throw new ServerException(ex);
        }
        if (this.jwsDirs != null) {
            for (int i = 0; i < this.jwsDirs.length; ++i) {
                try {
                    resources.add(Resource.newResource((String)this.jwsDirs[i].getAbsolutePath()));
                    continue;
                }
                catch (IOException ex) {
                    throw new ServerException(ex);
                }
            }
        }
        this.server = new Server(this.port);
        this.server.setGracefulShutdown(1000);
        Context context = new Context((HandlerContainer)this.server, "/axis");
        context.setBaseResource((Resource)new ResourceCollection(resources.toArray(new Resource[resources.size()])));
        Object sessionManager = this.maxSessions == -1 ? new HashSessionManager() : new LimitSessionManager(this.maxSessions);
        context.setSessionHandler(new SessionHandler((SessionManager)sessionManager));
        this.quitListener = new QuitListener();
        context.setAttribute(QuitHandler.QUIT_LISTENER, (Object)this.quitListener);
        ServletHandler servletHandler = context.getServletHandler();
        ServletHolder axisServletHolder = new ServletHolder((Servlet)servlet);
        axisServletHolder.setName("AxisServlet");
        servletHandler.addServlet(axisServletHolder);
        ServletMapping mapping = new ServletMapping();
        mapping.setServletName("AxisServlet");
        mapping.setPathSpec("/services/*");
        servletHandler.addServletMapping(mapping);
        mapping = new ServletMapping();
        mapping.setServletName("AxisServlet");
        mapping.setPathSpec("/servlet/AxisServlet");
        servletHandler.addServletMapping(mapping);
        if (this.jwsDirs != null && this.jwsDirs.length > 0) {
            mapping = new ServletMapping();
            mapping.setServletName("AxisServlet");
            mapping.setPathSpec("*.jws");
            servletHandler.addServletMapping(mapping);
        }
    }

    public void start() throws ServerException {
        try {
            this.server.start();
        }
        catch (Exception ex) {
            throw new ServerException(ex);
        }
    }

    public void awaitQuitRequest() throws InterruptedException {
        this.quitListener.awaitQuitRequest();
    }

    public void stop() throws ServerException {
        try {
            this.server.stop();
        }
        catch (Exception ex) {
            throw new ServerException(ex);
        }
    }
}

