/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.server.standalone;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.mortbay.jetty.servlet.AbstractSessionManager;
import org.mortbay.jetty.servlet.HashSessionManager;

final class LimitSessionManager
extends HashSessionManager {
    private final int maxSessions;
    private ScheduledExecutorService executor;

    LimitSessionManager(int maxSessions) {
        this.maxSessions = maxSessions;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.executor = new ScheduledThreadPoolExecutor(1);
        this.executor.scheduleWithFixedDelay(new Runnable(){

            public void run() {
                LimitSessionManager.this.scavenge();
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    protected AbstractSessionManager.Session newSession(HttpServletRequest request) {
        return new Session(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scavenge() {
        while (true) {
            Session sessionToRemove = null;
            LimitSessionManager limitSessionManager = this;
            synchronized (limitSessionManager) {
                if (this._sessions.size() <= this.maxSessions) {
                    break;
                }
                long minAccessed = Long.MAX_VALUE;
                for (Session session : this._sessions.values()) {
                    long accessed = session.accessed();
                    if (accessed >= minAccessed) continue;
                    minAccessed = accessed;
                    sessionToRemove = session;
                }
            }
            sessionToRemove.timeout();
        }
    }

    public void doStop() throws Exception {
        this.executor.shutdown();
        this.executor.awaitTermination(60L, TimeUnit.SECONDS);
        super.doStop();
    }

    class Session
    extends HashSessionManager.Session {
        private static final long serialVersionUID = -6648322281268846583L;

        Session(HttpServletRequest request) {
            super((HashSessionManager)LimitSessionManager.this, request);
        }

        long accessed() {
            return this._accessed;
        }

        protected void timeout() {
            super.timeout();
        }
    }
}

