/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl.jdbc;

import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.jdbc.JdbcSharedStateManager;
import org.apache.activemq.artemis.core.server.impl.jdbc.LeaseLock;
import org.apache.activemq.artemis.core.server.impl.jdbc.ScheduledLeaseLock;
import org.apache.activemq.artemis.core.server.impl.jdbc.SharedStateManager;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCUtils;
import org.apache.activemq.artemis.jdbc.store.sql.PropertySQLProvider;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.jboss.logging.Logger;

public final class JdbcNodeManager
extends NodeManager {
    private static final Logger logger = Logger.getLogger(JdbcNodeManager.class);
    private static final long MAX_PAUSE_MILLIS = 2000L;
    private final Supplier<? extends SharedStateManager> sharedStateManagerFactory;
    private final Supplier<? extends ScheduledLeaseLock> scheduledLiveLockFactory;
    private final Supplier<? extends ScheduledLeaseLock> scheduledBackupLockFactory;
    private SharedStateManager sharedStateManager;
    private ScheduledLeaseLock scheduledLiveLock;
    private ScheduledLeaseLock scheduledBackupLock;
    private final long lockRenewPeriodMillis;
    private final long lockAcquisitionTimeoutMillis;
    private volatile boolean interrupted = false;
    private final LeaseLock.Pauser pauser;
    private final IOCriticalErrorListener ioCriticalErrorListener;

    public static JdbcNodeManager with(DatabaseStorageConfiguration configuration, ScheduledExecutorService scheduledExecutorService, ExecutorFactory executorFactory, IOCriticalErrorListener ioCriticalErrorListener) {
        if (configuration.getDataSource() != null) {
            Object sqlProviderFactory = configuration.getSqlProviderFactory() != null ? configuration.getSqlProviderFactory() : new PropertySQLProvider.Factory(configuration.getDataSource());
            String brokerId = UUID.randomUUID().toString();
            return JdbcNodeManager.usingDataSource(brokerId, configuration.getJdbcLockExpirationMillis(), configuration.getJdbcLockRenewPeriodMillis(), configuration.getJdbcLockAcquisitionTimeoutMillis(), configuration.getDataSource(), sqlProviderFactory.create(configuration.getNodeManagerStoreTableName(), SQLProvider.DatabaseStoreType.NODE_MANAGER), scheduledExecutorService, executorFactory, ioCriticalErrorListener);
        }
        SQLProvider sqlProvider = JDBCUtils.getSQLProvider((String)configuration.getJdbcDriverClassName(), (String)configuration.getNodeManagerStoreTableName(), (SQLProvider.DatabaseStoreType)SQLProvider.DatabaseStoreType.NODE_MANAGER);
        String brokerId = UUID.randomUUID().toString();
        return JdbcNodeManager.usingConnectionUrl(brokerId, configuration.getJdbcLockExpirationMillis(), configuration.getJdbcLockRenewPeriodMillis(), configuration.getJdbcLockAcquisitionTimeoutMillis(), configuration.getJdbcConnectionUrl(), configuration.getJdbcDriverClassName(), sqlProvider, scheduledExecutorService, executorFactory, ioCriticalErrorListener);
    }

    static JdbcNodeManager usingDataSource(String brokerId, long lockExpirationMillis, long lockRenewPeriodMillis, long lockAcquisitionTimeoutMillis, DataSource dataSource, SQLProvider provider, ScheduledExecutorService scheduledExecutorService, ExecutorFactory executorFactory, IOCriticalErrorListener ioCriticalErrorListener) {
        return new JdbcNodeManager(() -> JdbcSharedStateManager.usingDataSource(brokerId, lockExpirationMillis, dataSource, provider), false, lockRenewPeriodMillis, lockAcquisitionTimeoutMillis, scheduledExecutorService, executorFactory, ioCriticalErrorListener);
    }

    public static JdbcNodeManager usingConnectionUrl(String brokerId, long lockExpirationMillis, long lockRenewPeriodMillis, long lockAcquisitionTimeoutMillis, String jdbcUrl, String driverClass, SQLProvider provider, ScheduledExecutorService scheduledExecutorService, ExecutorFactory executorFactory, IOCriticalErrorListener ioCriticalErrorListener) {
        return new JdbcNodeManager(() -> JdbcSharedStateManager.usingConnectionUrl(brokerId, lockExpirationMillis, jdbcUrl, driverClass, provider), false, lockRenewPeriodMillis, lockAcquisitionTimeoutMillis, scheduledExecutorService, executorFactory, ioCriticalErrorListener);
    }

    private JdbcNodeManager(Supplier<? extends SharedStateManager> sharedStateManagerFactory, boolean replicatedBackup, long lockRenewPeriodMillis, long lockAcquisitionTimeoutMillis, ScheduledExecutorService scheduledExecutorService, ExecutorFactory executorFactory, IOCriticalErrorListener ioCriticalErrorListener) {
        super(replicatedBackup, null);
        this.lockAcquisitionTimeoutMillis = lockAcquisitionTimeoutMillis;
        this.lockRenewPeriodMillis = lockRenewPeriodMillis;
        this.pauser = LeaseLock.Pauser.sleep(Math.min(this.lockRenewPeriodMillis, 2000L), TimeUnit.MILLISECONDS);
        this.sharedStateManagerFactory = sharedStateManagerFactory;
        this.scheduledLiveLockFactory = () -> ScheduledLeaseLock.of(scheduledExecutorService, executorFactory != null ? executorFactory.getExecutor() : null, "live", this.sharedStateManager.liveLock(), lockRenewPeriodMillis, ioCriticalErrorListener);
        this.scheduledBackupLockFactory = () -> ScheduledLeaseLock.of(scheduledExecutorService, executorFactory != null ? executorFactory.getExecutor() : null, "backup", this.sharedStateManager.backupLock(), lockRenewPeriodMillis, ioCriticalErrorListener);
        this.ioCriticalErrorListener = ioCriticalErrorListener;
        this.sharedStateManager = null;
        this.scheduledLiveLock = null;
        this.scheduledBackupLock = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        try {
            JdbcNodeManager jdbcNodeManager = this;
            synchronized (jdbcNodeManager) {
                if (this.isStarted()) {
                    return;
                }
                this.sharedStateManager = this.sharedStateManagerFactory.get();
                if (!this.replicatedBackup) {
                    org.apache.activemq.artemis.utils.UUID nodeId = this.sharedStateManager.setup(() -> ((UUIDGenerator)UUIDGenerator.getInstance()).generateUUID());
                    this.setUUID(nodeId);
                }
                this.scheduledLiveLock = this.scheduledLiveLockFactory.get();
                this.scheduledBackupLock = this.scheduledBackupLockFactory.get();
                super.start();
            }
        }
        catch (IllegalStateException e) {
            this.sharedStateManager = null;
            this.scheduledLiveLock = null;
            this.scheduledBackupLock = null;
            if (this.ioCriticalErrorListener != null) {
                this.ioCriticalErrorListener.onIOException((Throwable)e, "Failed to setup the JdbcNodeManager", null);
            }
            throw e;
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        if (this.isStarted()) {
            try {
                this.scheduledLiveLock.stop();
                this.scheduledBackupLock.stop();
            }
            finally {
                super.stop();
                this.sharedStateManager.close();
                this.sharedStateManager = null;
                this.scheduledLiveLock = null;
                this.scheduledBackupLock = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        this.stop();
    }

    @Override
    public boolean isAwaitingFailback() throws Exception {
        return this.readSharedState() == SharedStateManager.State.FAILING_BACK;
    }

    @Override
    public boolean isBackupLive() throws Exception {
        return this.scheduledLiveLock.lock().isHeld();
    }

    @Override
    public void stopBackup() throws Exception {
        if (this.replicatedBackup) {
            org.apache.activemq.artemis.utils.UUID nodeId = this.getUUID();
            this.sharedStateManager.writeNodeId(nodeId);
        }
        this.releaseBackup();
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
    }

    @Override
    public void releaseBackup() throws Exception {
        if (this.scheduledBackupLock.lock().isHeldByCaller()) {
            this.scheduledBackupLock.stop();
            this.scheduledBackupLock.lock().release();
        }
    }

    private void lock(LeaseLock lock) throws Exception {
        LeaseLock.AcquireResult acquireResult = lock.tryAcquire(this.lockAcquisitionTimeoutMillis, this.pauser, () -> !this.interrupted);
        switch (acquireResult) {
            case Timeout: {
                throw new Exception("timed out waiting for lock");
            }
            case Exit: {
                this.interrupted = false;
                throw new InterruptedException("LeaseLock was interrupted");
            }
            case Done: {
                break;
            }
            default: {
                throw new AssertionError((Object)((Object)((Object)acquireResult) + " not managed"));
            }
        }
    }

    private void checkInterrupted(Supplier<String> message) throws InterruptedException {
        if (this.interrupted) {
            this.interrupted = false;
            throw new InterruptedException(message.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renewLiveLockIfNeeded(long acquiredOn) {
        long acquiredMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - acquiredOn);
        if (acquiredMillis > this.scheduledLiveLock.renewPeriodMillis() && !this.scheduledLiveLock.lock().renew()) {
            IllegalStateException e = new IllegalStateException("live lock can't be renewed");
            try {
                this.ioCriticalErrorListener.onIOException((Throwable)e, "live lock can't be renewed", null);
            }
            finally {
                throw e;
            }
        }
    }

    private boolean lockLiveAndCheckLiveState() throws Exception {
        SharedStateManager.State stateWhileLocked;
        this.lock(this.scheduledLiveLock.lock());
        long acquiredOn = System.nanoTime();
        boolean liveWhileLocked = false;
        try {
            stateWhileLocked = this.readSharedState();
        }
        catch (Throwable t) {
            logger.error((Object)"error while holding the live node lock and tried to read the shared state", t);
            this.scheduledLiveLock.lock().release();
            throw t;
        }
        if (stateWhileLocked == SharedStateManager.State.LIVE) {
            this.renewLiveLockIfNeeded(acquiredOn);
            liveWhileLocked = true;
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("state is " + (Object)((Object)stateWhileLocked) + " while holding the live lock"));
            }
            this.scheduledLiveLock.lock().release();
        }
        return liveWhileLocked;
    }

    @Override
    public void awaitLiveNode() throws Exception {
        boolean liveWhileLocked = false;
        while (!liveWhileLocked) {
            SharedStateManager.State state = this.readSharedState();
            if (state == SharedStateManager.State.LIVE) {
                liveWhileLocked = this.lockLiveAndCheckLiveState();
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("awaiting live node...state: " + (Object)((Object)state)));
            }
            if (liveWhileLocked) continue;
            this.checkInterrupted(() -> "awaitLiveNode got interrupted!");
            this.pauser.idle();
        }
        logger.debug((Object)"acquired live node lock");
        this.scheduledLiveLock.start();
    }

    @Override
    public void startBackup() throws Exception {
        assert (!this.replicatedBackup);
        ActiveMQServerLogger.LOGGER.waitingToBecomeBackup();
        this.lock(this.scheduledBackupLock.lock());
        this.scheduledBackupLock.start();
        ActiveMQServerLogger.LOGGER.gotBackupLock();
        if (this.getUUID() == null) {
            this.readNodeId();
        }
    }

    @Override
    public ActivateCallback startLiveNode() throws Exception {
        this.setFailingBack();
        String timeoutMessage = this.lockAcquisitionTimeoutMillis == -1L ? "indefinitely" : this.lockAcquisitionTimeoutMillis + " milliseconds";
        ActiveMQServerLogger.LOGGER.waitingToObtainLiveLock(timeoutMessage);
        this.lock(this.scheduledLiveLock.lock());
        this.scheduledLiveLock.start();
        ActiveMQServerLogger.LOGGER.obtainedLiveLock();
        return new ActivateCallback(){

            @Override
            public void activationComplete() {
                try {
                    JdbcNodeManager.this.setLive();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.warn(e.getMessage(), e);
                }
            }
        };
    }

    @Override
    public void pauseLiveServer() throws Exception {
        if (this.scheduledLiveLock.isStarted()) {
            this.setPaused();
            this.scheduledLiveLock.stop();
            this.scheduledLiveLock.lock().release();
        } else if (this.scheduledLiveLock.lock().renew()) {
            this.setPaused();
            this.scheduledLiveLock.lock().release();
        } else {
            IllegalStateException e = new IllegalStateException("live lock can't be renewed");
            try {
                this.ioCriticalErrorListener.onIOException((Throwable)e, "live lock can't be renewed on pauseLiveServer", null);
            }
            finally {
                throw e;
            }
        }
    }

    @Override
    public void crashLiveServer() throws Exception {
        if (this.scheduledLiveLock.lock().isHeldByCaller()) {
            this.scheduledLiveLock.stop();
            this.scheduledLiveLock.lock().release();
        }
    }

    @Override
    public void awaitLiveStatus() {
        while (this.readSharedState() != SharedStateManager.State.LIVE) {
            this.pauser.idle();
        }
    }

    private void setLive() {
        this.writeSharedState(SharedStateManager.State.LIVE);
    }

    private void setFailingBack() {
        this.writeSharedState(SharedStateManager.State.FAILING_BACK);
    }

    private void setPaused() {
        this.writeSharedState(SharedStateManager.State.PAUSED);
    }

    private void writeSharedState(SharedStateManager.State state) {
        assert (!this.replicatedBackup) : "the replicated backup can't write the shared state!";
        this.sharedStateManager.writeState(state);
    }

    private SharedStateManager.State readSharedState() {
        return this.sharedStateManager.readState();
    }

    @Override
    public SimpleString readNodeId() {
        org.apache.activemq.artemis.utils.UUID nodeId = this.sharedStateManager.readNodeId();
        this.setUUID(nodeId);
        return this.getNodeId();
    }
}

