/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.postoffice.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.cluster.RemoteQueueBinding;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.group.GroupingHandler;
import org.apache.activemq.artemis.core.server.group.impl.Proposal;
import org.apache.activemq.artemis.core.server.group.impl.Response;
import org.jboss.logging.Logger;

public final class BindingsImpl
implements Bindings {
    private static final Logger logger = Logger.getLogger(BindingsImpl.class);
    public static final int MAX_GROUP_RETRY = 10;
    private final ConcurrentMap<SimpleString, List<Binding>> routingNameBindingMap = new ConcurrentHashMap<SimpleString, List<Binding>>();
    private final Map<SimpleString, Integer> routingNamePositions = new ConcurrentHashMap<SimpleString, Integer>();
    private final Map<Long, Binding> bindingsMap = new ConcurrentHashMap<Long, Binding>();
    private final List<Binding> exclusiveBindings = new CopyOnWriteArrayList<Binding>();
    private volatile MessageLoadBalancingType messageLoadBalancingType = MessageLoadBalancingType.OFF;
    private final GroupingHandler groupingHandler;
    private final PagingStore pageStore;
    private final SimpleString name;

    public BindingsImpl(SimpleString name, GroupingHandler groupingHandler, PagingStore pageStore) {
        this.groupingHandler = groupingHandler;
        this.pageStore = pageStore;
        this.name = name;
    }

    @Override
    public void setMessageLoadBalancingType(MessageLoadBalancingType messageLoadBalancingType) {
        this.messageLoadBalancingType = messageLoadBalancingType;
    }

    @Override
    public MessageLoadBalancingType getMessageLoadBalancingType() {
        return this.messageLoadBalancingType;
    }

    @Override
    public Collection<Binding> getBindings() {
        return this.bindingsMap.values();
    }

    @Override
    public void unproposed(SimpleString groupID) {
        for (Binding binding : this.bindingsMap.values()) {
            binding.unproposed(groupID);
        }
    }

    @Override
    public void addBinding(Binding binding) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("addBinding(" + binding + ") being called"));
        }
        if (binding.isExclusive()) {
            this.exclusiveBindings.add(binding);
        } else {
            List oldBindings;
            SimpleString routingName = binding.getRoutingName();
            List<Binding> bindings = (CopyOnWriteArrayList<Binding>)this.routingNameBindingMap.get(routingName);
            if (bindings == null && (oldBindings = (List)this.routingNameBindingMap.putIfAbsent(routingName, bindings = new CopyOnWriteArrayList<Binding>())) != null) {
                bindings = oldBindings;
            }
            if (!bindings.contains(binding)) {
                bindings.add(binding);
            }
        }
        this.bindingsMap.put(binding.getID(), binding);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Adding binding " + binding + " into " + this + " bindingTable: " + this.debugBindings()));
        }
    }

    @Override
    public void removeBinding(Binding binding) {
        if (binding.isExclusive()) {
            this.exclusiveBindings.remove(binding);
        } else {
            SimpleString routingName = binding.getRoutingName();
            List bindings = (List)this.routingNameBindingMap.get(routingName);
            if (bindings != null) {
                bindings.remove(binding);
                if (bindings.isEmpty()) {
                    this.routingNameBindingMap.remove(routingName);
                }
            }
        }
        this.bindingsMap.remove(binding.getID());
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Removing binding " + binding + " from " + this + " bindingTable: " + this.debugBindings()));
        }
    }

    @Override
    public boolean redistribute(Message message, Queue originatingQueue, RoutingContext context) throws Exception {
        SimpleString routingName;
        List bindings;
        if (this.messageLoadBalancingType.equals((Object)MessageLoadBalancingType.STRICT) || this.messageLoadBalancingType.equals((Object)MessageLoadBalancingType.OFF)) {
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Redistributing message " + message));
        }
        if ((bindings = (List)this.routingNameBindingMap.get(routingName = originatingQueue.getName())) == null) {
            return false;
        }
        Integer ipos = this.routingNamePositions.get(routingName);
        int pos = ipos != null ? ipos : 0;
        int length = bindings.size();
        int startPos = pos;
        Binding theBinding = null;
        while (true) {
            Binding binding;
            try {
                binding = (Binding)bindings.get(pos);
            }
            catch (IndexOutOfBoundsException e) {
                if (!bindings.isEmpty()) {
                    pos = 0;
                    startPos = 0;
                    length = bindings.size();
                    continue;
                }
                break;
            }
            pos = this.incrementPos(pos, length);
            Filter filter = binding.getFilter();
            boolean highPrior = binding.isHighAcceptPriority(message);
            if (highPrior && binding.getBindable() != originatingQueue && (filter == null || filter.match(message))) {
                theBinding = binding;
                break;
            }
            if (pos == startPos) break;
        }
        this.routingNamePositions.put(routingName, pos);
        if (theBinding != null) {
            theBinding.route(message, context);
            return true;
        }
        return false;
    }

    @Override
    public void route(Message message, RoutingContext context) throws Exception {
        this.route(message, context, true);
    }

    private void route(Message message, RoutingContext context, boolean groupRouting) throws Exception {
        byte[] ids = message.removeExtraBytesProperty(Message.HDR_SCALEDOWN_TO_IDS);
        if (ids != null) {
            ByteBuffer buffer = ByteBuffer.wrap(ids);
            while (buffer.hasRemaining()) {
                long id = buffer.getLong();
                for (Map.Entry<Long, Binding> entry : this.bindingsMap.entrySet()) {
                    RemoteQueueBinding remoteQueueBinding;
                    if (!(entry.getValue() instanceof RemoteQueueBinding) || (remoteQueueBinding = (RemoteQueueBinding)entry.getValue()).getRemoteQueueID() != id) continue;
                    message.putBytesProperty(Message.HDR_ROUTE_TO_IDS, ByteBuffer.allocate(8).putLong(remoteQueueBinding.getID()).array());
                }
            }
        }
        boolean routed = false;
        for (Binding binding : this.exclusiveBindings) {
            if (binding.getFilter() != null && !binding.getFilter().match(message)) continue;
            binding.getBindable().route(message, context);
            routed = true;
        }
        if (!routed) {
            ids = message.removeExtraBytesProperty(Message.HDR_ROUTE_TO_IDS);
            SimpleString groupId = message.getGroupID();
            if (ids != null) {
                this.routeFromCluster(message, context, ids);
            } else if (this.groupingHandler != null && groupRouting && groupId != null) {
                this.routeUsingStrictOrdering(message, context, this.groupingHandler, groupId, 0);
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Routing message " + message + " on binding=" + this));
                }
                for (Map.Entry entry : this.routingNameBindingMap.entrySet()) {
                    Binding theBinding;
                    SimpleString routingName = (SimpleString)entry.getKey();
                    List bindings = (List)entry.getValue();
                    if (bindings == null || (theBinding = this.getNextBinding(message, routingName, bindings)) == null) continue;
                    theBinding.route(message, context);
                }
            }
        }
    }

    public String toString() {
        return "BindingsImpl [name=" + this.name + "]";
    }

    private Binding getNextBinding(Message message, SimpleString routingName, List<Binding> bindings) {
        Binding theBinding;
        int startPos;
        int pos;
        block12: {
            Integer ipos = this.routingNamePositions.get(routingName);
            pos = ipos != null ? ipos : 0;
            int length = bindings.size();
            startPos = pos;
            theBinding = null;
            int lastLowPriorityBinding = -1;
            while (true) {
                Binding binding;
                try {
                    binding = bindings.get(pos);
                }
                catch (IndexOutOfBoundsException e) {
                    if (!bindings.isEmpty()) {
                        pos = 0;
                        startPos = 0;
                        length = bindings.size();
                        continue;
                    }
                    break block12;
                }
                Filter filter = binding.getFilter();
                if (filter == null || filter.match(message)) {
                    if (length == 1 || binding.isConnected() && (this.messageLoadBalancingType.equals((Object)MessageLoadBalancingType.STRICT) || binding.isHighAcceptPriority(message))) {
                        theBinding = binding;
                        pos = this.incrementPos(pos, length);
                        break block12;
                    }
                    if (lastLowPriorityBinding == -1 || this.messageLoadBalancingType.equals((Object)MessageLoadBalancingType.ON_DEMAND) && binding instanceof LocalQueueBinding) {
                        lastLowPriorityBinding = pos;
                    }
                }
                if ((pos = this.incrementPos(pos, length)) != startPos) continue;
                if (lastLowPriorityBinding == -1) break block12;
                try {
                    theBinding = bindings.get(lastLowPriorityBinding);
                }
                catch (IndexOutOfBoundsException e) {
                    if (!bindings.isEmpty()) {
                        pos = 0;
                        lastLowPriorityBinding = -1;
                        continue;
                    }
                    break block12;
                }
                break;
            }
            pos = this.incrementPos(lastLowPriorityBinding, length);
        }
        if (pos != startPos) {
            this.routingNamePositions.put(routingName, pos);
        }
        if (this.messageLoadBalancingType.equals((Object)MessageLoadBalancingType.OFF) && theBinding instanceof RemoteQueueBinding) {
            theBinding = this.getNextBinding(message, routingName, bindings);
        }
        return theBinding;
    }

    private void routeUsingStrictOrdering(Message message, RoutingContext context, GroupingHandler groupingGroupingHandler, SimpleString groupId, int tries) throws Exception {
        for (Map.Entry entry : this.routingNameBindingMap.entrySet()) {
            SimpleString routingName = (SimpleString)entry.getKey();
            List bindings = (List)entry.getValue();
            if (bindings == null) continue;
            SimpleString fullID = groupId.concat(".").concat(routingName);
            Response resp = groupingGroupingHandler.getProposal(fullID, true);
            if (resp == null) {
                Binding theBinding = this.getNextBinding(message, routingName, bindings);
                if (theBinding == null) continue;
                resp = groupingGroupingHandler.propose(new Proposal(fullID, theBinding.getClusterName()));
                if (resp == null) {
                    logger.debug((Object)("it got a timeout on propose, trying again, number of retries: " + tries));
                    theBinding = null;
                }
                if (resp != null && resp.getAlternativeClusterName() != null) {
                    theBinding = this.locateBinding(resp.getAlternativeClusterName(), bindings);
                }
                this.routeAndCheckNull(message, context, resp, theBinding, groupId, tries);
                continue;
            }
            Binding chosen = this.locateBinding(resp.getChosenClusterName(), bindings);
            this.routeAndCheckNull(message, context, resp, chosen, groupId, tries);
        }
    }

    private Binding locateBinding(SimpleString clusterName, List<Binding> bindings) {
        for (Binding binding : bindings) {
            if (!binding.getClusterName().equals((Object)clusterName)) continue;
            return binding;
        }
        return null;
    }

    private void routeAndCheckNull(Message message, RoutingContext context, Response resp, Binding theBinding, SimpleString groupId, int tries) throws Exception {
        if (theBinding != null) {
            theBinding.route(message, context);
        } else {
            if (resp != null) {
                this.groupingHandler.forceRemove(resp.getGroupId(), resp.getClusterName());
            }
            if (tries < 10) {
                this.routeUsingStrictOrdering(message, context, this.groupingHandler, groupId, tries + 1);
            } else {
                ActiveMQServerLogger.LOGGER.impossibleToRouteGrouped();
                this.route(message, context, false);
            }
        }
    }

    private String debugBindings() {
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        out.println("\n**************************************************");
        out.println("routingNameBindingMap:");
        if (this.routingNameBindingMap.isEmpty()) {
            out.println("\tEMPTY!");
        }
        for (Map.Entry entry : this.routingNameBindingMap.entrySet()) {
            out.println("\tkey=" + entry.getKey() + ", value(s):");
            for (Binding bind : (List)entry.getValue()) {
                out.println("\t\t" + bind);
            }
            out.println();
        }
        out.println("routingNamePositions:");
        if (this.routingNamePositions.isEmpty()) {
            out.println("\tEMPTY!");
        }
        for (Map.Entry<Object, Object> entry : this.routingNamePositions.entrySet()) {
            out.println("\tkey=" + entry.getKey() + ", value=" + entry.getValue());
        }
        out.println();
        out.println("bindingsMap:");
        if (this.bindingsMap.isEmpty()) {
            out.println("\tEMPTY!");
        }
        for (Map.Entry<Object, Object> entry : this.bindingsMap.entrySet()) {
            out.println("\tkey=" + entry.getKey() + ", value=" + entry.getValue());
        }
        out.println();
        out.println("exclusiveBindings:");
        if (this.exclusiveBindings.isEmpty()) {
            out.println("\tEMPTY!");
        }
        for (Binding binding : this.exclusiveBindings) {
            out.println("\t" + binding);
        }
        out.println("####################################################");
        return writer.toString();
    }

    private void routeFromCluster(Message message, RoutingContext context, byte[] ids) throws Exception {
        long bindingID;
        ByteBuffer buff;
        byte[] idsToAck = (byte[])message.removeProperty(Message.HDR_ROUTE_TO_ACK_IDS);
        ArrayList<Long> idsToAckList = new ArrayList<Long>();
        if (idsToAck != null) {
            buff = ByteBuffer.wrap(idsToAck);
            while (buff.hasRemaining()) {
                bindingID = buff.getLong();
                idsToAckList.add(bindingID);
            }
        }
        buff = ByteBuffer.wrap(ids);
        while (buff.hasRemaining()) {
            bindingID = buff.getLong();
            Binding binding = this.bindingsMap.get(bindingID);
            if (binding != null) {
                if (idsToAckList.contains(bindingID)) {
                    binding.routeWithAck(message, context);
                    continue;
                }
                binding.route(message, context);
                continue;
            }
            ActiveMQServerLogger.LOGGER.bindingNotFound(bindingID, message.toString(), this.toString());
        }
    }

    private int incrementPos(int pos, int length) {
        if (++pos == length) {
            pos = 0;
        }
        return pos;
    }

    public Map<SimpleString, List<Binding>> getRoutingNameBindingMap() {
        return this.routingNameBindingMap;
    }
}

