/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.process;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.util.ProcessInstanceHelper;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.runtime.api.impl.MappingExecutionContext;
import org.activiti.runtime.api.impl.VariablesMappingProvider;
import org.activiti.spring.process.ProcessExtensionService;
import org.activiti.spring.process.model.Extension;
import org.activiti.spring.process.model.VariableDefinition;
import org.activiti.spring.process.variable.VariableParsingService;
import org.activiti.spring.process.variable.VariableValidationService;

public class ProcessVariablesInitiator
extends ProcessInstanceHelper {
    private ProcessExtensionService processExtensionService;
    private final VariableParsingService variableParsingService;
    private final VariableValidationService variableValidationService;
    private VariablesMappingProvider mappingProvider;

    public ProcessVariablesInitiator(ProcessExtensionService processExtensionService, VariableParsingService variableParsingService, VariableValidationService variableValidationService, VariablesMappingProvider mappingProvider) {
        this.processExtensionService = processExtensionService;
        this.variableParsingService = variableParsingService;
        this.variableValidationService = variableValidationService;
        this.mappingProvider = mappingProvider;
    }

    public Map<String, Object> calculateVariablesFromExtensionFile(ProcessDefinition processDefinition, Map<String, Object> variables) {
        Map<String, Object> processedVariables = new HashMap<String, Object>();
        if (this.processExtensionService.hasExtensionsFor(processDefinition)) {
            Extension processExtension = this.processExtensionService.getExtensionsFor(processDefinition);
            Map variableDefinitionMap = processExtension.getProperties();
            processedVariables = this.processVariables(variables, variableDefinitionMap);
            Set<String> missingRequiredVars = this.checkRequiredVariables(processedVariables, variableDefinitionMap);
            if (!missingRequiredVars.isEmpty()) {
                throw new ActivitiException("Can't start process '" + processDefinition.getKey() + "' without required variables - " + String.join((CharSequence)", ", missingRequiredVars));
            }
            Set<String> varsWithMismatchedTypes = this.validateVariablesAgainstDefinitions(processedVariables, variableDefinitionMap);
            if (!varsWithMismatchedTypes.isEmpty()) {
                throw new ActivitiException("Can't start process '" + processDefinition.getKey() + "' as variables fail type validation - " + String.join((CharSequence)", ", varsWithMismatchedTypes));
            }
        }
        return processedVariables;
    }

    public ExecutionEntity createProcessInstanceWithInitialFlowElement(ProcessDefinition processDefinition, String businessKey, String processInstanceName, FlowElement initialFlowElement, Process process, Map<String, Object> variables, Map<String, Object> transientVariables) {
        Map<String, Object> processVariables = variables;
        if (this.processExtensionService.hasExtensionsFor(processDefinition)) {
            processVariables = this.mappingProvider.calculateOutPutVariables(MappingExecutionContext.buildMappingExecutionContext(processDefinition.getId(), initialFlowElement.getId()), variables);
            processVariables = this.calculateVariablesFromExtensionFile(processDefinition, processVariables);
        }
        return super.createProcessInstanceWithInitialFlowElement(processDefinition, businessKey, processInstanceName, initialFlowElement, process, processVariables, transientVariables);
    }

    private Map<String, Object> processVariables(Map<String, Object> variables, Map<String, VariableDefinition> variableDefinitionMap) {
        HashMap<String, Object> newVarsMap = new HashMap<String, Object>(Optional.ofNullable(variables).orElse(Collections.emptyMap()));
        variableDefinitionMap.forEach((k, v) -> {
            if (!newVarsMap.containsKey(v.getName()) && v.getValue() != null) {
                newVarsMap.put(v.getName(), this.createDefaultVariableValue((VariableDefinition)v));
            }
        });
        return newVarsMap;
    }

    private Object createDefaultVariableValue(VariableDefinition variableDefinition) {
        return this.variableParsingService.parse(variableDefinition);
    }

    private Set<String> checkRequiredVariables(Map<String, Object> variables, Map<String, VariableDefinition> variableDefinitionMap) {
        HashSet<String> missingRequiredVars = new HashSet<String>();
        variableDefinitionMap.forEach((k, v) -> {
            if (!variables.containsKey(v.getName()) && v.isRequired()) {
                missingRequiredVars.add(v.getName());
            }
        });
        return missingRequiredVars;
    }

    private Set<String> validateVariablesAgainstDefinitions(Map<String, Object> variables, Map<String, VariableDefinition> variableDefinitionMap) {
        HashSet<String> mismatchedVars = new HashSet<String>();
        variableDefinitionMap.forEach((k, v) -> {
            if (variables.containsKey(v.getName()) && !this.variableValidationService.validate(variables.get(v.getName()), v)) {
                mismatchedVars.add(v.getName());
            }
        });
        return mismatchedVars;
    }
}

