/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.connector;

import org.activiti.api.process.model.IntegrationContext;
import org.activiti.api.process.runtime.connector.Connector;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.runtime.api.connector.IntegrationContextBuilder;
import org.activiti.runtime.api.impl.MappingExecutionContext;
import org.activiti.runtime.api.impl.VariablesMappingProvider;
import org.springframework.context.ApplicationContext;

public class DefaultServiceTaskBehavior
extends AbstractBpmnActivityBehavior {
    private final ApplicationContext applicationContext;
    private final IntegrationContextBuilder integrationContextBuilder;
    private VariablesMappingProvider outboundVariablesProvider;

    public DefaultServiceTaskBehavior(ApplicationContext applicationContext, IntegrationContextBuilder integrationContextBuilder, VariablesMappingProvider outboundVariablesProvider) {
        this.applicationContext = applicationContext;
        this.integrationContextBuilder = integrationContextBuilder;
        this.outboundVariablesProvider = outboundVariablesProvider;
    }

    public void execute(DelegateExecution execution) {
        Connector connector = this.getConnector(this.getImplementation(execution));
        IntegrationContext integrationContext = (IntegrationContext)connector.apply((Object)this.integrationContextBuilder.from(execution));
        execution.setVariables(this.outboundVariablesProvider.calculateOutPutVariables(MappingExecutionContext.buildMappingExecutionContext(execution), integrationContext.getOutBoundVariables()));
        this.leave(execution);
    }

    private String getImplementation(DelegateExecution execution) {
        return ((ServiceTask)execution.getCurrentFlowElement()).getImplementation();
    }

    private Connector getConnector(String implementation) {
        return (Connector)this.applicationContext.getBean(implementation, Connector.class);
    }

    private String getServiceTaskImplementation(DelegateExecution execution) {
        return ((ServiceTask)execution.getCurrentFlowElement()).getImplementation();
    }

    public boolean hasConnectorBean(DelegateExecution execution) {
        String implementation = this.getServiceTaskImplementation(execution);
        return this.applicationContext.containsBean(implementation) && this.applicationContext.getBean(implementation) instanceof Connector;
    }
}

