/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.CallableExpression;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.GeneralComparison10;
import net.sf.saxon.expr.GeneralComparison20;
import net.sf.saxon.expr.IntegerRangeTest;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.RangeExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.Minimax;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public class GeneralComparison
extends BinaryExpression
implements ComparisonExpression,
CallableExpression {
    public static final int ONE_TO_ONE = 0;
    public static final int MANY_TO_ONE = 1;
    public static final int MANY_TO_MANY = 2;
    protected int singletonOperator;
    protected AtomicComparer comparer;
    protected boolean needsRuntimeCheck = true;
    protected int comparisonCardinality = 2;

    public GeneralComparison(Expression p0, int op, Expression p1) {
        super(p0, op, p1);
        this.singletonOperator = GeneralComparison.getCorrespondingSingletonOperator(op);
    }

    public boolean needsRuntimeCheck() {
        return this.needsRuntimeCheck;
    }

    public void setNeedsRuntimeCheck(boolean needsCheck) {
        this.needsRuntimeCheck = needsCheck;
    }

    public int getComparisonCardinality() {
        return this.comparisonCardinality;
    }

    public void setComparisonCardinality(int card) {
        this.comparisonCardinality = card;
    }

    public void setAtomicComparer(AtomicComparer comparer) {
        this.comparer = comparer;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        Expression e = super.simplify(visitor);
        if (e != this) {
            ExpressionTool.copyLocationInfo(this, e);
            return e;
        }
        if (visitor.getStaticContext().isInBackwardsCompatibleMode()) {
            Expression[] operands = this.getOperands();
            GeneralComparison10 gc10 = new GeneralComparison10(operands[0], this.getOperator(), operands[1]);
            gc10.setAtomicComparer(this.getAtomicComparer());
            return gc10;
        }
        Expression[] operands = this.getOperands();
        GeneralComparison20 gc20 = new GeneralComparison20(operands[0], this.getOperator(), operands[1]);
        gc20.setAtomicComparer(this.getAtomicComparer());
        return gc20;
    }

    public String getExpressionName() {
        return "GeneralComparison";
    }

    public AtomicComparer getAtomicComparer() {
        return this.comparer;
    }

    public int getSingletonOperator() {
        return this.singletonOperator;
    }

    public boolean convertsUntypedToOther() {
        return true;
    }

    public int computeCardinality() {
        return 16384;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        Expression oldOp0 = this.operand0;
        Expression oldOp1 = this.operand1;
        this.operand0 = visitor.typeCheck(this.operand0, contextItemType);
        this.operand1 = visitor.typeCheck(this.operand1, contextItemType);
        if (Literal.isEmptySequence(this.operand0) || Literal.isEmptySequence(this.operand1)) {
            return Literal.makeLiteral(BooleanValue.FALSE);
        }
        Optimizer opt = visitor.getConfiguration().obtainOptimizer();
        this.operand0 = ExpressionTool.unsorted(opt, this.operand0, false);
        this.operand1 = ExpressionTool.unsorted(opt, this.operand1, false);
        SequenceType atomicType = SequenceType.ATOMIC_SEQUENCE;
        RoleLocator role0 = new RoleLocator(1, Token.tokens[this.operator], 0);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, atomicType, false, role0, visitor);
        RoleLocator role1 = new RoleLocator(1, Token.tokens[this.operator], 1);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, atomicType, false, role1, visitor);
        if (this.operand0 != oldOp0) {
            this.adoptChildExpression(this.operand0);
        }
        if (this.operand1 != oldOp1) {
            this.adoptChildExpression(this.operand1);
        }
        ItemType t0 = this.operand0.getItemType(th);
        ItemType t1 = this.operand1.getItemType(th);
        if (t0 instanceof EmptySequenceTest || t1 instanceof EmptySequenceTest) {
            return Literal.makeLiteral(BooleanValue.FALSE);
        }
        if (((AtomicType)t0).isExternalType() || ((AtomicType)t1).isExternalType()) {
            XPathException err = new XPathException("Cannot perform comparisons involving external objects");
            err.setIsTypeError(true);
            err.setErrorCode("XPTY0004");
            err.setLocator(this);
            throw err;
        }
        BuiltInAtomicType pt0 = (BuiltInAtomicType)t0.getPrimitiveItemType();
        BuiltInAtomicType pt1 = (BuiltInAtomicType)t1.getPrimitiveItemType();
        int c0 = this.operand0.getCardinality();
        int c1 = this.operand1.getCardinality();
        if (c0 == 8192 || c1 == 8192) {
            return Literal.makeLiteral(BooleanValue.FALSE);
        }
        if (!(t0.equals(BuiltInAtomicType.ANY_ATOMIC) || t0.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || t1.equals(BuiltInAtomicType.ANY_ATOMIC) || t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC))) {
            if (!Type.isComparable(pt0, pt1, Token.isOrderedOperator(this.singletonOperator))) {
                NamePool namePool = visitor.getConfiguration().getNamePool();
                XPathException err = new XPathException("Cannot compare " + t0.toString(namePool) + " to " + t1.toString(namePool));
                err.setErrorCode("XPTY0004");
                err.setIsTypeError(true);
                err.setLocator(this);
                throw err;
            }
            boolean bl = this.needsRuntimeCheck = !Type.isGuaranteedGenerallyComparable(pt0, pt1, Token.isOrderedOperator(this.singletonOperator));
        }
        if (c0 == 16384 && c1 == 16384 && !t0.equals(BuiltInAtomicType.ANY_ATOMIC) && !t1.equals(BuiltInAtomicType.ANY_ATOMIC)) {
            Expression e0 = this.operand0;
            Expression e1 = this.operand1;
            if (t0.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                if (t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                    e0 = new CastExpression(this.operand0, BuiltInAtomicType.STRING, false);
                    this.adoptChildExpression(e0);
                    e1 = new CastExpression(this.operand1, BuiltInAtomicType.STRING, false);
                    this.adoptChildExpression(e1);
                } else if (th.isSubType(t1, BuiltInAtomicType.NUMERIC)) {
                    e0 = new CastExpression(this.operand0, BuiltInAtomicType.DOUBLE, false);
                    this.adoptChildExpression(e0);
                } else {
                    e0 = new CastExpression(this.operand0, pt1, false);
                    this.adoptChildExpression(e0);
                }
            } else if (t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                if (th.isSubType(t0, BuiltInAtomicType.NUMERIC)) {
                    e1 = new CastExpression(this.operand1, BuiltInAtomicType.DOUBLE, false);
                    this.adoptChildExpression(e1);
                } else {
                    e1 = new CastExpression(this.operand1, pt0, false);
                    this.adoptChildExpression(e1);
                }
            }
            ValueComparison vc = new ValueComparison(e0, this.singletonOperator, e1);
            vc.setAtomicComparer(this.comparer);
            ExpressionTool.copyLocationInfo(this, vc);
            return visitor.typeCheck(visitor.simplify(vc), contextItemType);
        }
        StaticContext env = visitor.getStaticContext();
        if (this.comparer == null) {
            String defaultCollationName = env.getDefaultCollationName();
            StringCollator collation = env.getCollation(defaultCollationName);
            if (collation == null) {
                collation = CodepointCollator.getInstance();
            }
            this.comparer = GenericAtomicComparer.makeAtomicComparer(pt0, pt1, collation, visitor.getConfiguration().getConversionContext());
        }
        if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
            return Literal.makeLiteral((AtomicValue)this.evaluateItem(env.makeEarlyEvaluationContext()));
        }
        return this;
    }

    private static Expression makeMinOrMax(Expression exp, String function) {
        FunctionCall fn = SystemFunction.makeSystemFunction(function, new Expression[]{exp});
        ((Minimax)fn).setIgnoreNaN(true);
        return fn;
    }

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Value value0;
        RoleLocator role;
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        StaticContext env = visitor.getStaticContext();
        Optimizer opt = visitor.getConfiguration().obtainOptimizer();
        this.operand0 = visitor.optimize(this.operand0, contextItemType);
        this.operand1 = visitor.optimize(this.operand1, contextItemType);
        if (Literal.isEmptySequence(this.operand0) || Literal.isEmptySequence(this.operand1)) {
            return Literal.makeLiteral(BooleanValue.FALSE);
        }
        this.operand0 = ExpressionTool.unsorted(opt, this.operand0, false);
        this.operand1 = ExpressionTool.unsorted(opt, this.operand1, false);
        if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
            return new Literal(Value.asValue(this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext())));
        }
        ItemType t0 = this.operand0.getItemType(th);
        ItemType t1 = this.operand1.getItemType(th);
        int c0 = this.operand0.getCardinality();
        int c1 = this.operand1.getCardinality();
        boolean checkTypes = t0 == BuiltInAtomicType.ANY_ATOMIC || t1 == BuiltInAtomicType.ANY_ATOMIC || !t0.equals(t1);
        boolean many0 = Cardinality.allowsMany(c0);
        boolean many1 = Cardinality.allowsMany(c1);
        if (many0) {
            this.comparisonCardinality = many1 ? 2 : 1;
        } else {
            if (many1) {
                GeneralComparison mc = this.getInverseComparison();
                mc.comparisonCardinality = 1;
                ExpressionTool.copyLocationInfo(this, mc);
                mc.comparer = this.comparer;
                mc.needsRuntimeCheck = this.needsRuntimeCheck;
                return visitor.optimize(mc, contextItemType);
            }
            this.comparisonCardinality = 0;
        }
        if (this.comparer == null) {
            String defaultCollationName = env.getDefaultCollationName();
            StringCollator comp = env.getCollation(defaultCollationName);
            if (comp == null) {
                comp = CodepointCollator.getInstance();
            }
            BuiltInAtomicType pt0 = (BuiltInAtomicType)t0.getPrimitiveItemType();
            BuiltInAtomicType pt1 = (BuiltInAtomicType)t1.getPrimitiveItemType();
            this.comparer = GenericAtomicComparer.makeAtomicComparer(pt0, pt1, comp, env.getConfiguration().getConversionContext());
        }
        Expression e0 = this.operand0;
        Expression e1 = this.operand1;
        boolean numeric0 = th.isSubType(t0, BuiltInAtomicType.NUMERIC);
        boolean numeric1 = th.isSubType(t1, BuiltInAtomicType.NUMERIC);
        if (numeric1 && !numeric0) {
            role = new RoleLocator(1, Token.tokens[this.operator], 0);
            e0 = TypeChecker.staticTypeCheck(e0, SequenceType.NUMERIC_SEQUENCE, false, role, visitor);
        }
        if (numeric0 && !numeric1) {
            role = new RoleLocator(1, Token.tokens[this.operator], 1);
            e1 = TypeChecker.staticTypeCheck(e1, SequenceType.NUMERIC_SEQUENCE, false, role, visitor);
        }
        if (this.operand0 instanceof RangeExpression && th.isSubType(this.operand1.getItemType(th), BuiltInAtomicType.NUMERIC) && this.operator == 6 && !Cardinality.allowsMany(this.operand1.getCardinality())) {
            Expression min = ((RangeExpression)this.operand0).operand0;
            Expression max = ((RangeExpression)this.operand0).operand1;
            IntegerRangeTest ir = new IntegerRangeTest(this.operand1, min, max);
            ExpressionTool.copyLocationInfo(this, ir);
            return ir;
        }
        if (this.operand0 instanceof Literal && (value0 = ((Literal)this.operand0).getValue()) instanceof IntegerRange && th.isSubType(this.operand1.getItemType(th), BuiltInAtomicType.NUMERIC) && this.operator == 6 && !Cardinality.allowsMany(this.operand1.getCardinality())) {
            long min = ((IntegerRange)value0).getStart();
            long max = ((IntegerRange)value0).getEnd();
            IntegerRangeTest ir = new IntegerRangeTest(this.operand1, Literal.makeLiteral(Int64Value.makeIntegerValue(min)), Literal.makeLiteral(Int64Value.makeIntegerValue(max)));
            ExpressionTool.copyLocationInfo(this, ir);
            return ir;
        }
        if (this.operator != 6 && this.operator != 22 && (th.isSubType(t0, BuiltInAtomicType.NUMERIC) || th.isSubType(t1, BuiltInAtomicType.NUMERIC))) {
            ValueComparison vc;
            switch (this.operator) {
                case 12: 
                case 14: {
                    vc = new ValueComparison(GeneralComparison.makeMinOrMax(e0, "min"), this.singletonOperator, GeneralComparison.makeMinOrMax(e1, "max"));
                    vc.setResultWhenEmpty(BooleanValue.FALSE);
                    vc.setAtomicComparer(this.comparer);
                    break;
                }
                case 11: 
                case 13: {
                    vc = new ValueComparison(GeneralComparison.makeMinOrMax(e0, "max"), this.singletonOperator, GeneralComparison.makeMinOrMax(e1, "min"));
                    vc.setResultWhenEmpty(BooleanValue.FALSE);
                    vc.setAtomicComparer(this.comparer);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown operator " + this.operator);
                }
            }
            ExpressionTool.copyLocationInfo(this, vc);
            return visitor.typeCheck(vc, contextItemType);
        }
        if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
            return Literal.makeLiteral((AtomicValue)this.evaluateItem(env.makeEarlyEvaluationContext()));
        }
        return visitor.getConfiguration().obtainOptimizer().optimizeGeneralComparison(this, false);
    }

    public Expression copy() {
        GeneralComparison gc = new GeneralComparison(this.operand0.copy(), this.operator, this.operand1.copy());
        gc.comparer = this.comparer;
        gc.singletonOperator = this.singletonOperator;
        gc.needsRuntimeCheck = this.needsRuntimeCheck;
        gc.comparisonCardinality = this.comparisonCardinality;
        return gc;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        switch (this.comparisonCardinality) {
            case 0: {
                AtomicValue value0 = (AtomicValue)this.operand0.evaluateItem(context);
                AtomicValue value1 = (AtomicValue)this.operand1.evaluateItem(context);
                return BooleanValue.get(this.evaluateOneToOne(value0, value1, context));
            }
            case 1: {
                SequenceIterator<? extends Item> iter0 = this.operand0.iterate(context);
                AtomicValue value1 = (AtomicValue)this.operand1.evaluateItem(context);
                return BooleanValue.get(this.evaluateManyToOne(iter0, value1, context));
            }
            case 2: {
                SequenceIterator<? extends Item> iter1 = this.operand0.iterate(context);
                SequenceIterator<? extends Item> iter2 = this.operand1.iterate(context);
                return BooleanValue.get(this.evaluateManyToMany(iter1, iter2, context));
            }
        }
        return null;
    }

    public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
        switch (this.comparisonCardinality) {
            case 0: {
                AtomicValue value0 = (AtomicValue)arguments[0].next();
                AtomicValue value1 = (AtomicValue)arguments[1].next();
                return Value.asIterator(BooleanValue.get(this.evaluateOneToOne(value0, value1, context)));
            }
            case 1: {
                SequenceIterator iter0 = arguments[0];
                AtomicValue value1 = (AtomicValue)arguments[1].next();
                return Value.asIterator(BooleanValue.get(this.evaluateManyToOne(iter0, value1, context)));
            }
            case 2: {
                SequenceIterator iter1 = arguments[0];
                SequenceIterator iter2 = arguments[1];
                return Value.asIterator(BooleanValue.get(this.evaluateManyToMany(iter1, iter2, context)));
            }
        }
        return null;
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        switch (this.comparisonCardinality) {
            case 0: {
                AtomicValue value0 = (AtomicValue)this.operand0.evaluateItem(context);
                AtomicValue value1 = (AtomicValue)this.operand1.evaluateItem(context);
                return this.evaluateOneToOne(value0, value1, context);
            }
            case 1: {
                SequenceIterator<? extends Item> iter0 = this.operand0.iterate(context);
                AtomicValue value1 = (AtomicValue)this.operand1.evaluateItem(context);
                return this.evaluateManyToOne(iter0, value1, context);
            }
            case 2: {
                SequenceIterator<? extends Item> iter1 = this.operand0.iterate(context);
                SequenceIterator<? extends Item> iter2 = this.operand1.iterate(context);
                return this.evaluateManyToMany(iter1, iter2, context);
            }
        }
        return false;
    }

    private boolean evaluateOneToOne(AtomicValue value0, AtomicValue value1, XPathContext context) throws XPathException {
        try {
            return value0 != null && value1 != null && GeneralComparison.compare(value0, this.singletonOperator, value1, this.comparer, this.needsRuntimeCheck, context);
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            e.maybeSetContext(context);
            throw e;
        }
    }

    private boolean evaluateManyToOne(SequenceIterator iter0, AtomicValue value1, XPathContext context) throws XPathException {
        try {
            AtomicValue item0;
            if (value1 == null) {
                return false;
            }
            while ((item0 = (AtomicValue)iter0.next()) != null) {
                if (!GeneralComparison.compare(item0, this.singletonOperator, value1, this.comparer, this.needsRuntimeCheck, context)) continue;
                iter0.close();
                return true;
            }
            return false;
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            e.maybeSetContext(context);
            throw e;
        }
    }

    public boolean evaluateManyToMany(SequenceIterator iter0, SequenceIterator iter1, XPathContext context) throws XPathException {
        try {
            boolean exhausted0 = false;
            boolean exhausted1 = false;
            ArrayList<AtomicValue> value0 = new ArrayList<AtomicValue>();
            ArrayList<AtomicValue> value1 = new ArrayList<AtomicValue>();
            while (true) {
                if (!exhausted0) {
                    AtomicValue item0 = (AtomicValue)iter0.next();
                    if (item0 == null) {
                        if (exhausted1) {
                            return false;
                        }
                        exhausted0 = true;
                    } else {
                        for (AtomicValue item1 : value1) {
                            if (!GeneralComparison.compare(item0, this.singletonOperator, item1, this.comparer, this.needsRuntimeCheck, context)) continue;
                            iter0.close();
                            iter1.close();
                            return true;
                        }
                        if (!exhausted1) {
                            value0.add(item0);
                        }
                    }
                }
                if (exhausted1) continue;
                AtomicValue item1 = (AtomicValue)iter1.next();
                if (item1 == null) {
                    if (exhausted0) {
                        return false;
                    }
                    exhausted1 = true;
                    continue;
                }
                for (AtomicValue item0 : value0) {
                    if (!GeneralComparison.compare(item0, this.singletonOperator, item1, this.comparer, this.needsRuntimeCheck, context)) continue;
                    iter0.close();
                    iter1.close();
                    return true;
                }
                if (exhausted0) continue;
                value1.add(item1);
            }
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            e.maybeSetContext(context);
            throw e;
        }
    }

    public static boolean compare(AtomicValue a0, int operator, AtomicValue a1, AtomicComparer comparer, boolean checkTypes, XPathContext context) throws XPathException {
        ConversionRules rules = context.getConfiguration().getConversionRules();
        boolean u0 = a0 instanceof UntypedAtomicValue;
        boolean u1 = a1 instanceof UntypedAtomicValue;
        if (u0 != u1) {
            if (u0) {
                a0 = a1 instanceof NumericValue ? Converter.convert(a0, BuiltInAtomicType.DOUBLE, rules).asAtomic() : Converter.convert(a0, a1.getPrimitiveType(), rules).asAtomic();
            } else {
                a1 = a0 instanceof NumericValue ? Converter.convert(a1, BuiltInAtomicType.DOUBLE, rules).asAtomic() : Converter.convert(a1, a0.getPrimitiveType(), rules).asAtomic();
            }
            checkTypes = false;
        }
        return ValueComparison.compare(a0, operator, a1, comparer.provideContext(context), checkTypes);
    }

    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    public static int getCorrespondingSingletonOperator(int op) {
        switch (op) {
            case 6: {
                return 50;
            }
            case 13: {
                return 54;
            }
            case 22: {
                return 51;
            }
            case 12: {
                return 53;
            }
            case 11: {
                return 52;
            }
            case 14: {
                return 55;
            }
        }
        return op;
    }

    protected GeneralComparison getInverseComparison() {
        return new GeneralComparison(this.operand1, Token.inverse(this.operator), this.operand0);
    }

    protected void explainExtraAttributes(ExpressionPresenter out) {
        String cc = "";
        switch (this.comparisonCardinality) {
            case 0: {
                cc = "one-to-one";
                break;
            }
            case 1: {
                cc = "many-to-one";
                break;
            }
            case 2: {
                cc = "many-to-many";
            }
        }
        out.emitAttribute("cardinality", cc);
    }
}

