/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.File;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.Filter;
import net.sf.saxon.IdentityTransformer;
import net.sf.saxon.IdentityTransformerHandler;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.TemplatesHandlerImpl;
import net.sf.saxon.TransformerHandlerImpl;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.ConfigurationReader;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.XMLFilter;

public class TransformerFactoryImpl
extends SAXTransformerFactory {
    private Configuration config;
    private static final String FEATURE_SECURE_PROCESSING = "http://javax.xml.XMLConstants/feature/secure-processing";

    public TransformerFactoryImpl() {
        this.config = Configuration.newConfiguration();
        this.config.setProcessor(this);
    }

    public TransformerFactoryImpl(Configuration config) {
        this.config = config;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        return templates.newTransformer();
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        return new IdentityTransformer(this.config);
    }

    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        CompilerInfo info = this.config.getDefaultXsltCompilerInfo();
        PreparedStylesheet pss = new PreparedStylesheet(this.config, info);
        pss.prepare(source);
        return pss;
    }

    public Templates newTemplates(Source source, CompilerInfo info) throws TransformerConfigurationException {
        PreparedStylesheet pss = new PreparedStylesheet(this.config, info);
        pss.prepare(source);
        return pss;
    }

    public Source getAssociatedStylesheet(Source source, String media, String title, String charset) throws TransformerConfigurationException {
        return PreparedStylesheet.getAssociatedStylesheet(this.config, source, media, title, charset);
    }

    public void setURIResolver(URIResolver resolver) {
        this.config.setURIResolver(resolver);
    }

    public URIResolver getURIResolver() {
        return this.config.getURIResolver();
    }

    public boolean getFeature(String name) {
        if (name.equals("http://javax.xml.transform.sax.SAXSource/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.sax.SAXResult/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.dom.DOMSource/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.dom.DOMResult/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.stream.StreamSource/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.stream.StreamResult/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.sax.SAXTransformerFactory/feature/xmlfilter")) {
            return true;
        }
        if (name.equals(FEATURE_SECURE_PROCESSING)) {
            return !this.config.isAllowExternalFunctions();
        }
        try {
            Object val = this.config.getConfigurationProperty(name);
            return val instanceof Boolean && (Boolean)val != false;
        }
        catch (IllegalArgumentException err) {
            return false;
        }
    }

    public void setAttribute(String name, Object value) throws IllegalArgumentException {
        if (name.equals("http://saxon.sf.net/feature/configuration-file")) {
            ConfigurationReader reader = new ConfigurationReader();
            try {
                this.setConfiguration(reader.makeConfiguration(new StreamSource(new File((String)value))));
            }
            catch (XPathException err) {
                throw new IllegalArgumentException(err);
            }
        } else if (name.equals("http://saxon.sf.net/feature/configuration")) {
            this.config = (Configuration)value;
        } else {
            this.config.setConfigurationProperty(name, value);
        }
    }

    public Object getAttribute(String name) throws IllegalArgumentException {
        if (name.equals("http://saxon.sf.net/feature/configuration")) {
            return this.config;
        }
        return this.config.getConfigurationProperty(name);
    }

    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        this.config.setErrorListener(listener);
    }

    public ErrorListener getErrorListener() {
        return this.config.getErrorListener();
    }

    public TransformerHandler newTransformerHandler(Source src) throws TransformerConfigurationException {
        Templates tmpl = this.newTemplates(src);
        return this.newTransformerHandler(tmpl);
    }

    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        if (!(templates instanceof PreparedStylesheet)) {
            throw new TransformerConfigurationException("Templates object was not created by Saxon");
        }
        Controller controller = (Controller)templates.newTransformer();
        return new TransformerHandlerImpl(controller);
    }

    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        IdentityTransformer controller = new IdentityTransformer(this.config);
        return new IdentityTransformerHandler(controller);
    }

    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        return new TemplatesHandlerImpl(this.config);
    }

    public XMLFilter newXMLFilter(Source src) throws TransformerConfigurationException {
        Templates tmpl = this.newTemplates(src);
        return this.newXMLFilter(tmpl);
    }

    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        if (!(templates instanceof PreparedStylesheet)) {
            throw new TransformerConfigurationException("Supplied Templates object was not created using Saxon");
        }
        Controller controller = (Controller)templates.newTransformer();
        return new Filter(controller);
    }

    public void setFeature(String name, boolean value) throws TransformerConfigurationException {
        if (name.equals(FEATURE_SECURE_PROCESSING)) {
            this.config.setAllowExternalFunctions(!value);
        } else {
            try {
                this.config.setConfigurationProperty(name, value);
            }
            catch (IllegalArgumentException err) {
                throw new TransformerConfigurationException("Unsupported TransformerFactory feature: " + name);
            }
        }
    }
}

