/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pickle.objects;

import java.util.Calendar;
import java.util.GregorianCalendar;
import net.razorvine.pickle.IObjectConstructor;
import net.razorvine.pickle.PickleException;
import net.razorvine.pickle.objects.Time;
import net.razorvine.pickle.objects.TimeDelta;

public class DateTimeConstructor
implements IObjectConstructor {
    public static int DATETIME = 1;
    public static int DATE = 2;
    public static int TIME = 3;
    public static int TIMEDELTA = 4;
    private int pythontype;

    public DateTimeConstructor(int pythontype) {
        this.pythontype = pythontype;
    }

    @Override
    public Object construct(Object[] args) {
        if (this.pythontype == DATE) {
            return this.createDate(args);
        }
        if (this.pythontype == TIME) {
            return this.createTime(args);
        }
        if (this.pythontype == DATETIME) {
            return this.createDateTime(args);
        }
        if (this.pythontype == TIMEDELTA) {
            return this.createTimedelta(args);
        }
        throw new PickleException("invalid object type");
    }

    private TimeDelta createTimedelta(Object[] args) {
        if (args.length != 3) {
            throw new PickleException("invalid pickle data for timedelta; expected 3 args, got " + args.length);
        }
        int days = ((Number)args[0]).intValue();
        int seconds = ((Number)args[1]).intValue();
        int micro = ((Number)args[2]).intValue();
        return new TimeDelta(days, seconds, micro);
    }

    private Calendar createDateTime(Object[] args) {
        int microsec;
        int second;
        int minute;
        int hour;
        int day;
        int month;
        int ylo;
        int yhi;
        Object params;
        if (args.length == 7) {
            int year = (Integer)args[0];
            int month2 = (Integer)args[1] - 1;
            int day2 = (Integer)args[2];
            int hour2 = (Integer)args[3];
            int minute2 = (Integer)args[4];
            int second2 = (Integer)args[5];
            int microsec2 = (Integer)args[6];
            GregorianCalendar cal = new GregorianCalendar(year, month2, day2, hour2, minute2, second2);
            cal.set(14, microsec2 / 1000);
            return cal;
        }
        if (args.length != 1) {
            throw new PickleException("invalid pickle data for datetime; expected 1 or 7 args, got " + args.length);
        }
        if (args[0] instanceof String) {
            params = (String)args[0];
            if (((String)params).length() != 10) {
                throw new PickleException("invalid pickle data for datetime; expected arg of length 10, got length " + ((String)params).length());
            }
            yhi = ((String)params).charAt(0);
            ylo = ((String)params).charAt(1);
            month = ((String)params).charAt(2) - '\u0001';
            day = ((String)params).charAt(3);
            hour = ((String)params).charAt(4);
            minute = ((String)params).charAt(5);
            second = ((String)params).charAt(6);
            char ms1 = ((String)params).charAt(7);
            char ms2 = ((String)params).charAt(8);
            char ms3 = ((String)params).charAt(9);
            microsec = (ms1 << 8 | ms2) << 8 | ms3;
        } else {
            params = (byte[])args[0];
            if (((Object)params).length != 10) {
                throw new PickleException("invalid pickle data for datetime; expected arg of length 10, got length " + ((Object)params).length);
            }
            yhi = params[0] & 0xFF;
            ylo = params[1] & 0xFF;
            month = (params[2] & 0xFF) - 1;
            day = params[3] & 0xFF;
            hour = params[4] & 0xFF;
            minute = params[5] & 0xFF;
            second = params[6] & 0xFF;
            int ms1 = params[7] & 0xFF;
            int ms2 = params[8] & 0xFF;
            int ms3 = params[9] & 0xFF;
            microsec = (ms1 << 8 | ms2) << 8 | ms3;
        }
        GregorianCalendar cal = new GregorianCalendar(yhi * 256 + ylo, month, day, hour, minute, second);
        cal.set(14, microsec / 1000);
        return cal;
    }

    private Time createTime(Object[] args) {
        int microsec;
        int second;
        int minute;
        int hour;
        if (args.length == 4) {
            int hour2 = (Integer)args[0];
            int minute2 = (Integer)args[1];
            int second2 = (Integer)args[2];
            int microsec2 = (Integer)args[3];
            return new Time(hour2, minute2, second2, microsec2);
        }
        if (args.length != 1) {
            throw new PickleException("invalid pickle data for time; expected 1 or 4 args, got " + args.length);
        }
        if (args[0] instanceof String) {
            String params = (String)args[0];
            if (params.length() != 6) {
                throw new PickleException("invalid pickle data for time; expected arg of length 6, got length " + params.length());
            }
            hour = params.charAt(0);
            minute = params.charAt(1);
            second = params.charAt(2);
            char ms1 = params.charAt(3);
            char ms2 = params.charAt(4);
            char ms3 = params.charAt(5);
            microsec = (ms1 << 8 | ms2) << 8 | ms3;
        } else {
            byte[] params = (byte[])args[0];
            if (params.length != 6) {
                throw new PickleException("invalid pickle data for datetime; expected arg of length 6, got length " + params.length);
            }
            hour = params[0] & 0xFF;
            minute = params[1] & 0xFF;
            second = params[2] & 0xFF;
            int ms1 = params[3] & 0xFF;
            int ms2 = params[4] & 0xFF;
            int ms3 = params[5] & 0xFF;
            microsec = (ms1 << 8 | ms2) << 8 | ms3;
        }
        return new Time(hour, minute, second, microsec);
    }

    private Calendar createDate(Object[] args) {
        int day;
        int month;
        int ylo;
        int yhi;
        if (args.length != 1) {
            throw new PickleException("invalid pickle data for date; expected 1 arg, got " + args.length);
        }
        if (args[0] instanceof String) {
            String params = (String)args[0];
            if (params.length() != 4) {
                throw new PickleException("invalid pickle data for date; expected arg of length 4, got length " + params.length());
            }
            yhi = params.charAt(0);
            ylo = params.charAt(1);
            month = params.charAt(2) - '\u0001';
            day = params.charAt(3);
        } else {
            byte[] params = (byte[])args[0];
            if (params.length != 4) {
                throw new PickleException("invalid pickle data for date; expected arg of length 4, got length " + params.length);
            }
            yhi = params[0] & 0xFF;
            ylo = params[1] & 0xFF;
            month = (params[2] & 0xFF) - 1;
            day = params[3] & 0xFF;
        }
        return new GregorianCalendar(yhi * 256 + ylo, month, day);
    }
}

