/*
 * Decompiled with CFR 0.152.
 */
package com.bill99.crypto.utils;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.x509.certificate.X509Cert;
import com.bill99.crypto.config.CryptoConfig;
import com.bill99.crypto.entity.Bill99CertConfig;
import com.bill99.crypto.entity.KeyPair;
import com.bill99.crypto.utils.FileLoader;
import com.bill99.crypto.utils.StringHelp;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

public class Bill99CertLoader {
    private static final Logger logger = LoggerFactory.getLogger(Bill99CertLoader.class);
    private static Provider BC = new BouncyCastleProvider();

    public static CryptoConfig loadCryptoConfig(Bill99CertConfig bill99CertConfig) throws Exception {
        KeyPair decKeyPair;
        CryptoConfig cryptoConfig = new CryptoConfig();
        KeyPair sigKeyPair = Bill99CertLoader.loadMerchantKeyStore(bill99CertConfig.getMerchantDefaultPrivatePath(), bill99CertConfig.getMerchantDefaultPrivatePassword());
        if (sigKeyPair != null) {
            cryptoConfig.setSigMerchantCert(sigKeyPair.getCert());
            cryptoConfig.setSigMerchantKey(sigKeyPair.getPrivateKey());
        }
        if ((decKeyPair = Bill99CertLoader.loadMerchantKeyStore(bill99CertConfig.getMerchantDefaultPrivatePath(), bill99CertConfig.getMerchantDefaultPrivatePassword())) != null) {
            cryptoConfig.setDecMerchantCert(decKeyPair.getCert());
            cryptoConfig.setDecMerchantKey(decKeyPair.getPrivateKey());
        }
        X509Cert cert = Bill99CertLoader.loadBill99PublicCert(bill99CertConfig.getBill99DefaultPublicPath());
        cryptoConfig.setEncKqCert(cert);
        cryptoConfig.setVfyKqCert(cert);
        KeyPair merchantDecAltKeyPair = Bill99CertLoader.loadMerchantKeyStore(bill99CertConfig.getMerchantAlternatePrivatePath(), bill99CertConfig.getMerchantAlternatePrivatePassword());
        if (merchantDecAltKeyPair != null) {
            cryptoConfig.setAltDecMerchantCert(merchantDecAltKeyPair.getCert());
            cryptoConfig.setAltDecMerchantKey(merchantDecAltKeyPair.getPrivateKey());
        }
        X509Cert altCert = Bill99CertLoader.loadBill99PublicCert(bill99CertConfig.getBill99AlternatePublicPath());
        cryptoConfig.setAltVfyKqCert(altCert);
        return cryptoConfig;
    }

    private static KeyPair loadMerchantKeyStore(String merchantCertPath, String password) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, PKIException {
        KeyPair keyPair = null;
        Certificate certificate = null;
        PrivateKey privateKey = null;
        if (StringHelp.isNullOrEmpty(merchantCertPath).booleanValue()) {
            return null;
        }
        InputStream certFileStream = FileLoader.getCertFileStream(merchantCertPath);
        if (null == certFileStream) {
            logger.info("load private cert file not exists! location = {}", (Object)merchantCertPath);
        }
        logger.info("load private cert file success. location = {}", (Object)merchantCertPath);
        KeyStore keyStore = KeyStore.getInstance("PKCS12", BC);
        keyStore.load(certFileStream, password.toCharArray());
        certificate = keyStore.getCertificate(keyStore.aliases().nextElement());
        X509Cert x509Cert = new X509Cert(certificate.getEncoded());
        privateKey = (PrivateKey)keyStore.getKey(keyStore.aliases().nextElement(), password.toCharArray());
        keyPair = new KeyPair(x509Cert, privateKey);
        return keyPair;
    }

    private static X509Cert loadBill99PublicCert(String billCertPath) throws FileNotFoundException, CertificateException, PKIException {
        if (StringHelp.isNullOrEmpty(billCertPath).booleanValue()) {
            return null;
        }
        X509Cert bill99PublicCert = null;
        InputStream certFileStream = null;
        certFileStream = FileLoader.getCertFileStream(billCertPath);
        if (null == certFileStream) {
            logger.info("load 99bill cert file not exists! location = {}", (Object)billCertPath);
        }
        logger.info("load 99bill public cert file success. location = {}", (Object)billCertPath);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X509", BC);
        Certificate cerCert = certificateFactory.generateCertificate(certFileStream);
        bill99PublicCert = new X509Cert(cerCert.getEncoded());
        return bill99PublicCert;
    }
}

