/*
 * Decompiled with CFR 0.152.
 */
package com.bill99.crypto.service.processor;

import com.alibaba.fastjson.JSONObject;
import com.bill99.crypto.config.CryptoConfig;
import com.bill99.crypto.entity.Bill99CertConfig;
import com.bill99.crypto.processor.P7CryptoProcessor;
import com.bill99.crypto.service.P7CryptoService;
import com.bill99.crypto.utils.Bill99CertLoader;

public class P7CryptoServiceProcessor
implements P7CryptoService {
    private Bill99CertConfig bill99CertConfig;

    private P7CryptoServiceProcessor() {
    }

    public static final P7CryptoServiceProcessor getInstance() {
        return P7CryptoServiceProcessorHolder.INSTANCE;
    }

    @Override
    public void setBill99CertConfig(Bill99CertConfig bill99CertConfig) {
        this.bill99CertConfig = bill99CertConfig;
    }

    @Override
    public JSONObject seal(String originalData) throws Exception {
        JSONObject requestBody = new JSONObject();
        P7CryptoProcessor processor = new P7CryptoProcessor();
        CryptoConfig cryptoConfig = Bill99CertLoader.loadCryptoConfig(this.bill99CertConfig);
        processor.setCryptoConfig(cryptoConfig);
        requestBody.put("signedData", (Object)processor.p7Sign(originalData));
        requestBody.put("envelopedData", (Object)processor.p7Envelop(originalData));
        return requestBody;
    }

    @Override
    public String unSeal(String envelopedData, String signedData) throws Exception {
        P7CryptoProcessor processor = new P7CryptoProcessor();
        CryptoConfig cryptoConfig = Bill99CertLoader.loadCryptoConfig(this.bill99CertConfig);
        processor.setCryptoConfig(cryptoConfig);
        String originalData = processor.p7OpenEnvelope(envelopedData);
        boolean result = processor.p7Verify(originalData, signedData);
        if (result) {
            return originalData;
        }
        return null;
    }

    private static class P7CryptoServiceProcessorHolder {
        private static final P7CryptoServiceProcessor INSTANCE = new P7CryptoServiceProcessor();

        private P7CryptoServiceProcessorHolder() {
        }
    }
}

