/*
 * Decompiled with CFR 0.152.
 */
package com.bill99.crypto.processor;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.util.CertUtil;
import cfca.sadk.util.EnvelopeUtil;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import com.bill99.crypto.config.CryptoConfig;
import java.security.PrivateKey;

public class P7CryptoProcessor {
    private static final Logger logger = LoggerFactory.getLogger(P7CryptoProcessor.class);
    private static CryptoConfig cryptoConfig;

    public CryptoConfig getCryptoConfig() {
        return cryptoConfig;
    }

    public void setCryptoConfig(CryptoConfig cryptoConfig) {
        P7CryptoProcessor.cryptoConfig = cryptoConfig;
    }

    public String p7Sign(String content) throws Exception {
        X509Cert sigMerchantCert = this.getCryptoConfig().getSigMerchantCert();
        PrivateKey sigMerchantKey = this.getCryptoConfig().getSigMerchantKey();
        this.checkNotNull(sigMerchantCert, "\u7b7e\u540d\u5546\u6237\u8bc1\u4e66\u5fc5\u987b\u914d\u7f6e");
        this.checkNotNull(sigMerchantKey, "\u7b7e\u540d\u5546\u6237\u79c1\u94a5\u5fc5\u987b\u914d\u7f6e");
        String sigAlg = CertUtil.isSM2Cert((X509Cert)sigMerchantCert) ? "SM3withSM2" : "sha256WithRSAEncryption";
        byte[] signedDataBinary = new Signature().p7SignMessageDetach(sigAlg, content.getBytes("UTF-8"), sigMerchantKey, sigMerchantCert, BCSoftLib.INSTANCE());
        String signedData = new String(signedDataBinary);
        return signedData;
    }

    public boolean p7Verify(String content, String signedData) throws Exception {
        Signature processor = new Signature();
        boolean v = processor.p7VerifyMessageDetach(content.getBytes("UTF-8"), signedData.getBytes(), BCSoftLib.INSTANCE());
        if (v) {
            X509Cert verifiedCert = processor.getSignerCert();
            if (verifiedCert.equals((Object)this.getCryptoConfig().getVfyKqCert()) || verifiedCert.equals((Object)this.getCryptoConfig().getAltVfyKqCert())) {
                return true;
            }
            logger.error("\u672a\u5339\u914d\u7b7e\u540d\u8bc1\u4e66SN={}", (Object)verifiedCert.getSerialNumber().toString(16));
            return false;
        }
        logger.error("\u9a8c\u7b7e\u5931\u8d25");
        return false;
    }

    public String p7Envelop(String content) throws Exception {
        X509Cert encKqCert = this.getCryptoConfig().getEncKqCert();
        this.checkNotNull(encKqCert, "\u52a0\u5bc6\u5feb\u94b1\u8bc1\u4e66\u5fc5\u987b\u914d\u7f6e");
        String symmetricAlgorithm = CertUtil.isSM2Cert((X509Cert)encKqCert) ? "SM4/CBC/PKCS7Padding" : "AES/CBC/PKCS7Padding";
        byte[] envelopedData = EnvelopeUtil.envelopeMessage((byte[])content.getBytes("UTF-8"), (String)symmetricAlgorithm, (X509Cert[])new X509Cert[]{encKqCert});
        return new String(envelopedData);
    }

    public String p7OpenEnvelope(String envelopedData) throws Exception {
        byte[] decryptedData = null;
        byte[] envelope = envelopedData.getBytes();
        boolean primarySuccess = false;
        PrivateKey decMerchantKey = this.getCryptoConfig().getDecMerchantKey();
        X509Cert decMerchantCert = this.getCryptoConfig().getDecMerchantCert();
        this.checkNotNull(decMerchantKey, "\u89e3\u5bc6\u5546\u6237\u8bc1\u4e66\u5fc5\u987b\u914d\u7f6e");
        this.checkNotNull(decMerchantCert, "\u89e3\u5bc6\u5546\u6237\u79c1\u94a5\u5fc5\u987b\u914d\u7f6e");
        PKIException exceptionMemo = null;
        try {
            decryptedData = EnvelopeUtil.openEvelopedMessage((byte[])envelope, (PrivateKey)decMerchantKey, (X509Cert)decMerchantCert, (Session)BCSoftLib.INSTANCE());
            primarySuccess = true;
        }
        catch (PKIException e) {
            exceptionMemo = e;
        }
        if (!primarySuccess) {
            PrivateKey altDecMerchantKey = this.getCryptoConfig().getAltDecMerchantKey();
            X509Cert altDecMerchantCert = this.getCryptoConfig().getAltDecMerchantCert();
            if (altDecMerchantKey != null && altDecMerchantCert != null) {
                try {
                    logger.info("decrypt by default cert config but fail , try to use alternate cert...");
                    decryptedData = EnvelopeUtil.openEvelopedMessage((byte[])envelope, (PrivateKey)altDecMerchantKey, (X509Cert)altDecMerchantCert, (Session)BCSoftLib.INSTANCE());
                }
                catch (PKIException e) {
                    // empty catch block
                }
            }
        }
        if (decryptedData == null) {
            logger.info("decrypt by default and alternate cert config , but all of them fail...");
            throw exceptionMemo;
        }
        return new String(decryptedData, "UTF-8");
    }

    private void checkNotNull(Object o, String message) {
        if (o == null) {
            throw new IllegalStateException(message);
        }
    }
}

