/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.rbac.api;

import io.weaviate.client.v1.rbac.model.BackupsPermission;
import io.weaviate.client.v1.rbac.model.CollectionsPermission;
import io.weaviate.client.v1.rbac.model.DataPermission;
import io.weaviate.client.v1.rbac.model.NodesPermission;
import io.weaviate.client.v1.rbac.model.Permission;
import io.weaviate.client.v1.rbac.model.RolesPermission;
import io.weaviate.client.v1.rbac.model.TenantsPermission;
import io.weaviate.client.v1.rbac.model.UsersPermission;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class WeaviatePermission {
    String action;
    BackupsPermission backups;
    CollectionsPermission collections;
    DataPermission data;
    NodesPermission nodes;
    RolesPermission roles;
    TenantsPermission tenants;
    UsersPermission users;

    public WeaviatePermission(String action) {
        this.action = action;
    }

    public <P extends Permission<P>> WeaviatePermission(String action, Permission<P> perm) {
        this.action = action;
        if (perm instanceof BackupsPermission) {
            this.backups = (BackupsPermission)perm;
        } else if (perm instanceof CollectionsPermission) {
            this.collections = (CollectionsPermission)perm;
        } else if (perm instanceof DataPermission) {
            this.data = (DataPermission)perm;
        } else if (perm instanceof NodesPermission) {
            this.nodes = (NodesPermission)perm;
        } else if (perm instanceof RolesPermission) {
            this.roles = (RolesPermission)perm;
        } else if (perm instanceof TenantsPermission) {
            this.tenants = (TenantsPermission)perm;
        } else if (perm instanceof UsersPermission) {
            this.users = (UsersPermission)perm;
        }
    }

    public static List<WeaviatePermission> mergePermissions(List<Permission<?>> permissions) {
        ArrayList<WeaviatePermission> merged = new ArrayList<WeaviatePermission>();
        for (Permission<?> perm : permissions) {
            merged.addAll(perm.toWeaviate());
        }
        return merged;
    }

    @Generated
    public static WeaviatePermissionBuilder builder() {
        return new WeaviatePermissionBuilder();
    }

    @Generated
    public String getAction() {
        return this.action;
    }

    @Generated
    public BackupsPermission getBackups() {
        return this.backups;
    }

    @Generated
    public CollectionsPermission getCollections() {
        return this.collections;
    }

    @Generated
    public DataPermission getData() {
        return this.data;
    }

    @Generated
    public NodesPermission getNodes() {
        return this.nodes;
    }

    @Generated
    public RolesPermission getRoles() {
        return this.roles;
    }

    @Generated
    public TenantsPermission getTenants() {
        return this.tenants;
    }

    @Generated
    public UsersPermission getUsers() {
        return this.users;
    }

    @Generated
    public WeaviatePermission(String action, BackupsPermission backups, CollectionsPermission collections, DataPermission data, NodesPermission nodes, RolesPermission roles, TenantsPermission tenants, UsersPermission users) {
        this.action = action;
        this.backups = backups;
        this.collections = collections;
        this.data = data;
        this.nodes = nodes;
        this.roles = roles;
        this.tenants = tenants;
        this.users = users;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeaviatePermission)) {
            return false;
        }
        WeaviatePermission other = (WeaviatePermission)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        BackupsPermission this$backups = this.getBackups();
        BackupsPermission other$backups = other.getBackups();
        if (this$backups == null ? other$backups != null : !((Object)this$backups).equals(other$backups)) {
            return false;
        }
        CollectionsPermission this$collections = this.getCollections();
        CollectionsPermission other$collections = other.getCollections();
        if (this$collections == null ? other$collections != null : !((Object)this$collections).equals(other$collections)) {
            return false;
        }
        DataPermission this$data = this.getData();
        DataPermission other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        NodesPermission this$nodes = this.getNodes();
        NodesPermission other$nodes = other.getNodes();
        if (this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes)) {
            return false;
        }
        RolesPermission this$roles = this.getRoles();
        RolesPermission other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        TenantsPermission this$tenants = this.getTenants();
        TenantsPermission other$tenants = other.getTenants();
        if (this$tenants == null ? other$tenants != null : !((Object)this$tenants).equals(other$tenants)) {
            return false;
        }
        UsersPermission this$users = this.getUsers();
        UsersPermission other$users = other.getUsers();
        return !(this$users == null ? other$users != null : !((Object)this$users).equals(other$users));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WeaviatePermission;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        BackupsPermission $backups = this.getBackups();
        result = result * 59 + ($backups == null ? 43 : ((Object)$backups).hashCode());
        CollectionsPermission $collections = this.getCollections();
        result = result * 59 + ($collections == null ? 43 : ((Object)$collections).hashCode());
        DataPermission $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        NodesPermission $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        RolesPermission $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        TenantsPermission $tenants = this.getTenants();
        result = result * 59 + ($tenants == null ? 43 : ((Object)$tenants).hashCode());
        UsersPermission $users = this.getUsers();
        result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WeaviatePermission(action=" + this.getAction() + ", backups=" + this.getBackups() + ", collections=" + this.getCollections() + ", data=" + this.getData() + ", nodes=" + this.getNodes() + ", roles=" + this.getRoles() + ", tenants=" + this.getTenants() + ", users=" + this.getUsers() + ")";
    }

    @Generated
    public static class WeaviatePermissionBuilder {
        @Generated
        private String action;
        @Generated
        private BackupsPermission backups;
        @Generated
        private CollectionsPermission collections;
        @Generated
        private DataPermission data;
        @Generated
        private NodesPermission nodes;
        @Generated
        private RolesPermission roles;
        @Generated
        private TenantsPermission tenants;
        @Generated
        private UsersPermission users;

        @Generated
        WeaviatePermissionBuilder() {
        }

        @Generated
        public WeaviatePermissionBuilder action(String action) {
            this.action = action;
            return this;
        }

        @Generated
        public WeaviatePermissionBuilder backups(BackupsPermission backups) {
            this.backups = backups;
            return this;
        }

        @Generated
        public WeaviatePermissionBuilder collections(CollectionsPermission collections) {
            this.collections = collections;
            return this;
        }

        @Generated
        public WeaviatePermissionBuilder data(DataPermission data) {
            this.data = data;
            return this;
        }

        @Generated
        public WeaviatePermissionBuilder nodes(NodesPermission nodes) {
            this.nodes = nodes;
            return this;
        }

        @Generated
        public WeaviatePermissionBuilder roles(RolesPermission roles) {
            this.roles = roles;
            return this;
        }

        @Generated
        public WeaviatePermissionBuilder tenants(TenantsPermission tenants) {
            this.tenants = tenants;
            return this;
        }

        @Generated
        public WeaviatePermissionBuilder users(UsersPermission users) {
            this.users = users;
            return this;
        }

        @Generated
        public WeaviatePermission build() {
            return new WeaviatePermission(this.action, this.backups, this.collections, this.data, this.nodes, this.roles, this.tenants, this.users);
        }

        @Generated
        public String toString() {
            return "WeaviatePermission.WeaviatePermissionBuilder(action=" + this.action + ", backups=" + this.backups + ", collections=" + this.collections + ", data=" + this.data + ", nodes=" + this.nodes + ", roles=" + this.roles + ", tenants=" + this.tenants + ", users=" + this.users + ")";
        }
    }
}

