/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.model;

import io.weaviate.client.base.WeaviateErrorMessage;
import io.weaviate.client.v1.graphql.model.GraphQLError;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class GraphQLResponse<T> {
    private T data;
    private GraphQLError[] errors;

    public List<WeaviateErrorMessage> errorMessages() {
        if (this.errors == null || this.errors.length == 0) {
            return null;
        }
        return Arrays.stream(this.errors).map(err -> new WeaviateErrorMessage(err.getMessage(), null)).collect(Collectors.toList());
    }

    @Generated
    GraphQLResponse(T data, GraphQLError[] errors) {
        this.data = data;
        this.errors = errors;
    }

    @Generated
    public static <T> GraphQLResponseBuilder<T> builder() {
        return new GraphQLResponseBuilder();
    }

    @Generated
    public T getData() {
        return this.data;
    }

    @Generated
    public GraphQLError[] getErrors() {
        return this.errors;
    }

    @Generated
    public String toString() {
        return "GraphQLResponse(data=" + this.getData() + ", errors=" + Arrays.deepToString(this.getErrors()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphQLResponse)) {
            return false;
        }
        GraphQLResponse other = (GraphQLResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        return Arrays.deepEquals(this.getErrors(), other.getErrors());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GraphQLResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getErrors());
        return result;
    }

    @Generated
    public static class GraphQLResponseBuilder<T> {
        @Generated
        private T data;
        @Generated
        private GraphQLError[] errors;

        @Generated
        GraphQLResponseBuilder() {
        }

        @Generated
        public GraphQLResponseBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        @Generated
        public GraphQLResponseBuilder<T> errors(GraphQLError[] errors) {
            this.errors = errors;
            return this;
        }

        @Generated
        public GraphQLResponse<T> build() {
            return new GraphQLResponse<T>(this.data, this.errors);
        }

        @Generated
        public String toString() {
            return "GraphQLResponse.GraphQLResponseBuilder(data=" + this.data + ", errors=" + Arrays.deepToString(this.errors) + ")";
        }
    }
}

