/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.experimental;

import io.weaviate.client.grpc.protocol.v1.WeaviateProtoBase;
import io.weaviate.client.v1.experimental.Operand;
import io.weaviate.client.v1.experimental.Where$;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class Where
implements Operand {
    private final Operator operator;
    private List<Operand> operands = new ArrayList<Operand>();

    public boolean isEmpty() {
        return this.operands.isEmpty();
    }

    @SafeVarargs
    private Where(Operator operator, Operand ... operands) {
        this(operator, Arrays.asList(operands));
    }

    private Where(Operator operator, List<Operand> operands) {
        this.operator = operator;
        this.operands = operands;
    }

    public static Where and(Operand ... operands) {
        return new Where(Operator.AND, operands);
    }

    public static Where and(Map<String, Object> filters, Operator operator) {
        return new Where(Operator.AND, Where.fromMap(filters, operator));
    }

    public static Where or(Operand ... operands) {
        return new Where(Operator.OR, operands);
    }

    public static Where or(Map<String, Object> filters, Operator operator) {
        return new Where(Operator.OR, Where.fromMap(filters, operator));
    }

    public static List<Operand> fromMap(Map<String, Object> filters, Operator operator) {
        if (operator.equals((Object)Operator.AND) || operator.equals((Object)Operator.OR)) {
            throw new IllegalArgumentException("AND/OR operators are not comparison operators");
        }
        return filters.entrySet().stream().map(entry -> new Where(operator, new Path(new String[]{(String)entry.getKey()}), ComparisonBuilder.fromObject(entry.getValue()))).collect(Collectors.toList());
    }

    public static ComparisonBuilder property(String property) {
        return new ComparisonBuilder(new Path(new String[]{property}));
    }

    public static ComparisonBuilder reference(String ... path) {
        return new ComparisonBuilder(new Path(path));
    }

    @Override
    public void append(WeaviateProtoBase.Filters.Builder where) {
        switch (this.operands.size()) {
            case 0: {
                return;
            }
            case 1: {
                this.operands.get(0).append(where);
                return;
            }
        }
        if (this.operator.equals((Object)Operator.AND) || this.operator.equals((Object)Operator.OR)) {
            this.operands.forEach(op -> {
                WeaviateProtoBase.Filters.Builder nested = WeaviateProtoBase.Filters.newBuilder();
                op.append(nested);
                where.addFilters(nested);
            });
        } else {
            this.operands.forEach(op -> op.append(where));
        }
        this.operator.append(where);
    }

    public static enum Operator {
        AND("And", WeaviateProtoBase.Filters.Operator.OPERATOR_AND),
        OR("Or", WeaviateProtoBase.Filters.Operator.OPERATOR_OR),
        EQUAL("Equal", WeaviateProtoBase.Filters.Operator.OPERATOR_EQUAL),
        NOT_EQUAL("NotEqual", WeaviateProtoBase.Filters.Operator.OPERATOR_NOT_EQUAL),
        LESS_THAN("LessThen", WeaviateProtoBase.Filters.Operator.OPERATOR_LESS_THAN),
        LESS_THAN_EQUAL("LessThenEqual", WeaviateProtoBase.Filters.Operator.OPERATOR_LESS_THAN_EQUAL),
        GREATER_THAN("GreaterThen", WeaviateProtoBase.Filters.Operator.OPERATOR_GREATER_THAN),
        GREATER_THAN_EQUAL("GreaterThenEqual", WeaviateProtoBase.Filters.Operator.OPERATOR_GREATER_THAN_EQUAL),
        LIKE("Like", WeaviateProtoBase.Filters.Operator.OPERATOR_LIKE),
        CONTAINS_ANY("ContainsAny", WeaviateProtoBase.Filters.Operator.OPERATOR_CONTAINS_ANY),
        CONTAINS_ALL("ContainsAll", WeaviateProtoBase.Filters.Operator.OPERATOR_CONTAINS_ALL),
        WITHIN_GEO_RANGE("WithinGeoRange", WeaviateProtoBase.Filters.Operator.OPERATOR_WITHIN_GEO_RANGE);

        private final String string;
        private final WeaviateProtoBase.Filters.Operator grpc;

        public void append(WeaviateProtoBase.Filters.Builder where) {
            where.setOperator(this.grpc);
        }

        public String toString() {
            return this.string;
        }

        @Generated
        private Operator(String string2, WeaviateProtoBase.Filters.Operator grpc) {
            this.string = string2;
            this.grpc = grpc;
        }
    }

    public static class ComparisonBuilder {
        private Operand left;

        private ComparisonBuilder(Operand left) {
            this.left = left;
        }

        static Operand fromObject(Object value) {
            if (value instanceof String) {
                return new $Text((String)value);
            }
            if (value instanceof Boolean) {
                return new $Boolean((Boolean)value);
            }
            if (value instanceof Integer) {
                return new $Integer((Integer)value);
            }
            if (value instanceof Number) {
                return new $Number((Number)value);
            }
            if (value instanceof Date) {
                return new $Date((Date)value);
            }
            if (value instanceof String[]) {
                return new $TextArray((String[])value, null);
            }
            if (value instanceof Boolean[]) {
                return new $BooleanArray((Boolean[])value, null);
            }
            if (value instanceof Integer[]) {
                return new $IntegerArray((Integer[])value, null);
            }
            if (value instanceof Number[]) {
                return new $NumberArray((Number[])value, null);
            }
            if (value instanceof Date[]) {
                return new $DateArray((Date[])value, null);
            }
            if (value instanceof List) {
                if (((List)value).isEmpty()) {
                    throw new IllegalArgumentException("Filter with non-reifiable type (List<T>) cannot be empty, use an array instead");
                }
                Object first = ((List)value).get(0);
                if (first instanceof String) {
                    return new $TextArray((List)value);
                }
                if (first instanceof Boolean) {
                    return new $BooleanArray((List)value);
                }
                if (first instanceof Integer) {
                    return new $IntegerArray((List)value);
                }
                if (first instanceof Number) {
                    return new $NumberArray((List)value);
                }
                if (first instanceof Date) {
                    return new $DateArray((List)value);
                }
            }
            throw new IllegalArgumentException("value must be either of String, Boolean, Date, Integer, Number, Array/List of these types");
        }

        public Where eq(String value) {
            return new Where(Operator.EQUAL, new Operand[]{this.left, new $Text(value)});
        }

        public Where eq(String ... values) {
            return new Where(Operator.EQUAL, new Operand[]{this.left, new $TextArray(values, null)});
        }

        public Where eq(Boolean value) {
            return new Where(Operator.EQUAL, new Operand[]{this.left, new $Boolean(value)});
        }

        public Where eq(Boolean ... values) {
            return new Where(Operator.EQUAL, new Operand[]{this.left, new $BooleanArray(values, null)});
        }

        public Where eq(Integer value) {
            return new Where(Operator.EQUAL, new Operand[]{this.left, new $Integer(value)});
        }

        public Where eq(Integer ... values) {
            return new Where(Operator.EQUAL, new Operand[]{this.left, new $IntegerArray(values, null)});
        }

        public Where eq(Number value) {
            return new Where(Operator.EQUAL, new Operand[]{this.left, new $Number(value.doubleValue())});
        }

        public Where eq(Number ... values) {
            return new Where(Operator.EQUAL, new Operand[]{this.left, new $NumberArray(values, null)});
        }

        public Where eq(Date value) {
            return new Where(Operator.EQUAL, new Operand[]{this.left, new $Date(value)});
        }

        public Where eq(Date ... values) {
            return new Where(Operator.EQUAL, new Operand[]{this.left, new $DateArray(values, null)});
        }

        public Where eq(Object value) {
            return new Where(Operator.EQUAL, new Operand[]{this.left, ComparisonBuilder.fromObject(value)});
        }

        public Where ne(String value) {
            return new Where(Operator.NOT_EQUAL, new Operand[]{this.left, new $Text(value)});
        }

        public Where ne(String ... values) {
            return new Where(Operator.NOT_EQUAL, new Operand[]{this.left, new $TextArray(values, null)});
        }

        public Where ne(Boolean value) {
            return new Where(Operator.NOT_EQUAL, new Operand[]{this.left, new $Boolean(value)});
        }

        public Where ne(Boolean ... values) {
            return new Where(Operator.NOT_EQUAL, new Operand[]{this.left, new $BooleanArray(values, null)});
        }

        public Where ne(Integer value) {
            return new Where(Operator.NOT_EQUAL, new Operand[]{this.left, new $Integer(value)});
        }

        public Where ne(Integer ... values) {
            return new Where(Operator.NOT_EQUAL, new Operand[]{this.left, new $IntegerArray(values, null)});
        }

        public Where ne(Number value) {
            return new Where(Operator.NOT_EQUAL, new Operand[]{this.left, new $Number(value.doubleValue())});
        }

        public Where ne(Number ... values) {
            return new Where(Operator.NOT_EQUAL, new Operand[]{this.left, new $NumberArray(values, null)});
        }

        public Where ne(Date value) {
            return new Where(Operator.NOT_EQUAL, new Operand[]{this.left, new $Date(value)});
        }

        public Where ne(Date ... values) {
            return new Where(Operator.NOT_EQUAL, new Operand[]{this.left, new $DateArray(values, null)});
        }

        public Where lt(String value) {
            return new Where(Operator.LESS_THAN, new Operand[]{this.left, new $Text(value)});
        }

        public Where lt(String ... values) {
            return new Where(Operator.LESS_THAN, new Operand[]{this.left, new $TextArray(values, null)});
        }

        public Where lt(Boolean value) {
            return new Where(Operator.LESS_THAN, new Operand[]{this.left, new $Boolean(value)});
        }

        public Where lt(Boolean ... values) {
            return new Where(Operator.LESS_THAN, new Operand[]{this.left, new $BooleanArray(values, null)});
        }

        public Where lt(Integer value) {
            return new Where(Operator.LESS_THAN, new Operand[]{this.left, new $Integer(value)});
        }

        public Where lt(Integer ... values) {
            return new Where(Operator.LESS_THAN, new Operand[]{this.left, new $IntegerArray(values, null)});
        }

        public Where lt(Number value) {
            return new Where(Operator.LESS_THAN, new Operand[]{this.left, new $Number(value.doubleValue())});
        }

        public Where lt(Number ... values) {
            return new Where(Operator.LESS_THAN, new Operand[]{this.left, new $NumberArray(values, null)});
        }

        public Where lt(Date value) {
            return new Where(Operator.LESS_THAN, new Operand[]{this.left, new $Date(value)});
        }

        public Where lt(Date ... values) {
            return new Where(Operator.LESS_THAN, new Operand[]{this.left, new $DateArray(values, null)});
        }

        public Where lte(String value) {
            return new Where(Operator.LESS_THAN_EQUAL, new Operand[]{this.left, new $Text(value)});
        }

        public Where lte(String ... values) {
            return new Where(Operator.LESS_THAN_EQUAL, new Operand[]{this.left, new $TextArray(values, null)});
        }

        public Where lte(Boolean value) {
            return new Where(Operator.LESS_THAN_EQUAL, new Operand[]{this.left, new $Boolean(value)});
        }

        public Where lte(Boolean ... values) {
            return new Where(Operator.LESS_THAN_EQUAL, new Operand[]{this.left, new $BooleanArray(values, null)});
        }

        public Where lte(Integer value) {
            return new Where(Operator.LESS_THAN_EQUAL, new Operand[]{this.left, new $Integer(value)});
        }

        public Where lte(Integer ... values) {
            return new Where(Operator.LESS_THAN_EQUAL, new Operand[]{this.left, new $IntegerArray(values, null)});
        }

        public Where lte(Number value) {
            return new Where(Operator.LESS_THAN_EQUAL, new Operand[]{this.left, new $Number(value.doubleValue())});
        }

        public Where lte(Number ... values) {
            return new Where(Operator.LESS_THAN_EQUAL, new Operand[]{this.left, new $NumberArray(values, null)});
        }

        public Where lte(Date value) {
            return new Where(Operator.LESS_THAN_EQUAL, new Operand[]{this.left, new $Date(value)});
        }

        public Where lte(Date ... values) {
            return new Where(Operator.LESS_THAN_EQUAL, new Operand[]{this.left, new $DateArray(values, null)});
        }

        public Where gt(String value) {
            return new Where(Operator.GREATER_THAN, new Operand[]{this.left, new $Text(value)});
        }

        public Where gt(String ... values) {
            return new Where(Operator.GREATER_THAN, new Operand[]{this.left, new $TextArray(values, null)});
        }

        public Where gt(Boolean value) {
            return new Where(Operator.GREATER_THAN, new Operand[]{this.left, new $Boolean(value)});
        }

        public Where gt(Boolean ... values) {
            return new Where(Operator.GREATER_THAN, new Operand[]{this.left, new $BooleanArray(values, null)});
        }

        public Where gt(Integer value) {
            return new Where(Operator.GREATER_THAN, new Operand[]{this.left, new $Integer(value)});
        }

        public Where gt(Integer ... values) {
            return new Where(Operator.GREATER_THAN, new Operand[]{this.left, new $IntegerArray(values, null)});
        }

        public Where gt(Number value) {
            return new Where(Operator.GREATER_THAN, new Operand[]{this.left, new $Number(value.doubleValue())});
        }

        public Where gt(Number ... values) {
            return new Where(Operator.GREATER_THAN, new Operand[]{this.left, new $NumberArray(values, null)});
        }

        public Where gt(Date value) {
            return new Where(Operator.GREATER_THAN, new Operand[]{this.left, new $Date(value)});
        }

        public Where gt(Date ... values) {
            return new Where(Operator.GREATER_THAN, new Operand[]{this.left, new $DateArray(values, null)});
        }

        public Where gte(String value) {
            return new Where(Operator.GREATER_THAN_EQUAL, new Operand[]{this.left, new $Text(value)});
        }

        public Where gte(String ... values) {
            return new Where(Operator.GREATER_THAN, new Operand[]{this.left, new $TextArray(values, null)});
        }

        public Where gte(Boolean value) {
            return new Where(Operator.GREATER_THAN, new Operand[]{this.left, new $Boolean(value)});
        }

        public Where gte(Boolean ... values) {
            return new Where(Operator.GREATER_THAN, new Operand[]{this.left, new $BooleanArray(values, null)});
        }

        public Where gte(Integer value) {
            return new Where(Operator.GREATER_THAN, new Operand[]{this.left, new $Integer(value)});
        }

        public Where gte(Integer ... values) {
            return new Where(Operator.GREATER_THAN, new Operand[]{this.left, new $IntegerArray(values, null)});
        }

        public Where gte(Number value) {
            return new Where(Operator.GREATER_THAN, new Operand[]{this.left, new $Number(value.doubleValue())});
        }

        public Where gte(Number ... values) {
            return new Where(Operator.GREATER_THAN, new Operand[]{this.left, new $NumberArray(values, null)});
        }

        public Where gte(Date value) {
            return new Where(Operator.GREATER_THAN, new Operand[]{this.left, new $Date(value)});
        }

        public Where gte(Date ... values) {
            return new Where(Operator.GREATER_THAN, new Operand[]{this.left, new $DateArray(values, null)});
        }

        public Where like(String value) {
            return new Where(Operator.LIKE, new Operand[]{this.left, new $Text(value)});
        }

        public Where like(String ... values) {
            return new Where(Operator.LIKE, new Operand[]{this.left, new $TextArray(values, null)});
        }

        public Where like(Boolean value) {
            return new Where(Operator.LIKE, new Operand[]{this.left, new $Boolean(value)});
        }

        public Where like(Boolean ... values) {
            return new Where(Operator.LIKE, new Operand[]{this.left, new $BooleanArray(values, null)});
        }

        public Where like(Integer value) {
            return new Where(Operator.LIKE, new Operand[]{this.left, new $Integer(value)});
        }

        public Where like(Integer ... values) {
            return new Where(Operator.LIKE, new Operand[]{this.left, new $IntegerArray(values, null)});
        }

        public Where like(Number value) {
            return new Where(Operator.LIKE, new Operand[]{this.left, new $Number(value.doubleValue())});
        }

        public Where like(Number ... values) {
            return new Where(Operator.LIKE, new Operand[]{this.left, new $NumberArray(values, null)});
        }

        public Where like(Date value) {
            return new Where(Operator.LIKE, new Operand[]{this.left, new $Date(value)});
        }

        public Where like(Date ... values) {
            return new Where(Operator.LIKE, new Operand[]{this.left, new $DateArray(values, null)});
        }

        public Where containsAny(String value) {
            return new Where(Operator.CONTAINS_ANY, new Operand[]{this.left, new $Text(value)});
        }

        public Where containsAny(String ... values) {
            return new Where(Operator.CONTAINS_ANY, new Operand[]{this.left, new $TextArray(values, null)});
        }

        public Where containsAny(Boolean ... values) {
            return new Where(Operator.CONTAINS_ANY, new Operand[]{this.left, new $BooleanArray(values, null)});
        }

        public Where containsAny(Integer ... values) {
            return new Where(Operator.CONTAINS_ANY, new Operand[]{this.left, new $IntegerArray(values, null)});
        }

        public Where containsAny(Number ... values) {
            return new Where(Operator.CONTAINS_ANY, new Operand[]{this.left, new $NumberArray(values, null)});
        }

        public Where containsAny(Date ... values) {
            return new Where(Operator.CONTAINS_ANY, new Operand[]{this.left, new $DateArray(values, null)});
        }

        public Where containsAll(String value) {
            return new Where(Operator.CONTAINS_ALL, new Operand[]{this.left, new $Text(value)});
        }

        public Where containsAll(String ... values) {
            return new Where(Operator.CONTAINS_ALL, new Operand[]{this.left, new $TextArray(values, null)});
        }

        public Where containsAll(Boolean ... values) {
            return new Where(Operator.CONTAINS_ALL, new Operand[]{this.left, new $BooleanArray(values, null)});
        }

        public Where containsAll(Integer ... values) {
            return new Where(Operator.CONTAINS_ALL, new Operand[]{this.left, new $IntegerArray(values, null)});
        }

        public Where containsAll(Number ... values) {
            return new Where(Operator.CONTAINS_ALL, new Operand[]{this.left, new $NumberArray(values, null)});
        }

        public Where containsAll(Date ... values) {
            return new Where(Operator.CONTAINS_ALL, new Operand[]{this.left, new $DateArray(values, null)});
        }

        public Where withinGeoRange(float lat, float lon, float maxDistance) {
            return new Where(Operator.WITHIN_GEO_RANGE, new Operand[]{this.left, new $GeoRange(Float.valueOf(lat), Float.valueOf(lon), Float.valueOf(maxDistance))});
        }
    }

    private static class Path
    implements Operand {
        List<String> path = new ArrayList<String>();

        @SafeVarargs
        private Path(String ... property) {
            this.path = Arrays.asList(property);
        }

        @Override
        public void append(WeaviateProtoBase.Filters.Builder where) {
            if (!this.path.isEmpty()) {
                where.addOn(this.path.get(0));
            }
        }
    }
}

