/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.async.rbac.api;

import io.weaviate.client.Config;
import io.weaviate.client.base.AsyncBaseClient;
import io.weaviate.client.base.AsyncClientResult;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.WeaviateError;
import io.weaviate.client.base.WeaviateErrorResponse;
import io.weaviate.client.v1.async.rbac.api.RoleGetter;
import io.weaviate.client.v1.auth.provider.AccessTokenProvider;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;

public class RoleExists
extends AsyncBaseClient<Boolean>
implements AsyncClientResult<Boolean> {
    private final RoleGetter getter;

    public RoleExists(CloseableHttpAsyncClient httpClient, Config config, AccessTokenProvider tokenProvider) {
        super(httpClient, config, tokenProvider);
        this.getter = new RoleGetter(httpClient, config, tokenProvider);
    }

    public RoleExists withName(String name) {
        this.getter.withName(name);
        return this;
    }

    @Override
    public Future<Result<Boolean>> run(FutureCallback<Result<Boolean>> callback) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Result resp = this.getter.run().get();
                if (resp.hasErrors()) {
                    WeaviateError error = resp.getError();
                    return new Result<Object>(error.getStatusCode(), null, WeaviateErrorResponse.builder().error(error.getMessages()).build());
                }
                return new Result<Boolean>(200, resp.getResult() != null, null);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new CompletionException(e);
            }
        });
    }
}

