/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.authentication;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.TokenCredentialsConverter;
import java.util.Map;

@DataObject(generateConverter=true, publicConverter=false)
public class TokenCredentials
implements Credentials {
    private String token;

    protected TokenCredentials() {
    }

    public TokenCredentials(String token) {
        this.token = token;
    }

    public TokenCredentials(JsonObject jsonObject) {
        TokenCredentialsConverter.fromJson((Iterable<Map.Entry<String, Object>>)jsonObject, this);
    }

    public String getToken() {
        return this.token;
    }

    public TokenCredentials setToken(String token) {
        this.token = token;
        return this;
    }

    @Override
    public <V> void checkValid(V arg) throws CredentialValidationException {
        if (this.token == null || this.token.length() == 0) {
            throw new CredentialValidationException("token cannot be null or empty");
        }
    }

    @Override
    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        TokenCredentialsConverter.toJson(this, result);
        return result;
    }

    public String toString() {
        return this.toJson().encode();
    }

    @Override
    public TokenCredentials applyHttpChallenge(String challenge, HttpMethod method, String uri, Integer nc, String cnonce) throws CredentialValidationException {
        int spc;
        if (challenge != null && !"Bearer".equalsIgnoreCase(challenge.substring(0, spc = challenge.indexOf(32)))) {
            throw new IllegalArgumentException("Only 'Bearer' auth-scheme is supported");
        }
        this.checkValid(null);
        return this;
    }

    @Override
    public String toHttpAuthorization() {
        return "Bearer " + this.token;
    }
}

